/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import org.apache.sis.internal.jdk8.Function;
import org.apache.sis.internal.jdk8.JDK8;
import org.apache.sis.internal.netcdf.Decoder;
import org.apache.sis.internal.netcdf.GridGeometry;
import org.apache.sis.internal.netcdf.Variable;
import org.apache.sis.internal.netcdf.impl.Attribute;
import org.apache.sis.internal.netcdf.impl.Dimension;
import org.apache.sis.internal.netcdf.impl.GridGeometryInfo;
import org.apache.sis.internal.netcdf.impl.VariableInfo;
import org.apache.sis.internal.storage.ChannelDataInput;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.measure.Units;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.logging.WarningListeners;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.parameter.InvalidParameterCardinalityException;

public final class ChannelDecoder
extends Decoder {
    public static final int MAGIC_NUMBER = 1128547840;
    public static final int MAX_VERSION = 2;
    private static final String NAME_ENCODING = "UTF-8";
    private static final Locale NAME_LOCALE = Locale.US;
    private static final Pattern TIME_UNIT_PATTERN = Pattern.compile("(?i)\\bsince\\b");
    private static final int STREAMING = -1;
    private static final int DIMENSION = 10;
    private static final int VARIABLE = 11;
    private static final int ATTRIBUTE = 12;
    private final ChannelDataInput input;
    private final boolean is64bits;
    private final int numrecs;
    private final String encoding = "ISO-8859-1";
    private final VariableInfo[] variables;
    private final Map<String, Attribute> attributeMap;
    private transient GridGeometry[] gridGeometries;

    public ChannelDecoder(WarningListeners<?> warningListeners, ChannelDataInput channelDataInput) throws IOException, DataStoreException {
        super(warningListeners);
        this.input = channelDataInput;
        int n = channelDataInput.readInt();
        if ((n & 0xFFFFFF00) != 1128547840) {
            throw new DataStoreException(this.errors().getString((short)111, "NetCDF", channelDataInput.filename));
        }
        switch (n &= 0xFF) {
            case 1: {
                this.is64bits = false;
                break;
            }
            case 2: {
                this.is64bits = true;
                break;
            }
            default: {
                throw new DataStoreException(this.errors().getString((short)130, n));
            }
        }
        this.numrecs = channelDataInput.readInt();
        Dimension[] dimensionArray = null;
        VariableInfo[] variableInfoArray = null;
        Attribute[] attributeArray = null;
        block9: for (int i = 0; i < 3; ++i) {
            long l = channelDataInput.readLong();
            if (l == 0L) continue;
            int n2 = (int)(l >>> 32);
            int n3 = (int)l;
            this.ensureNonNegative(n3, n2);
            switch (n2) {
                case 10: {
                    dimensionArray = this.readDimensions(n3);
                    continue block9;
                }
                case 11: {
                    variableInfoArray = this.readVariables(n3, dimensionArray);
                    continue block9;
                }
                case 12: {
                    attributeArray = this.readAttributes(n3);
                    continue block9;
                }
                default: {
                    throw this.malformedHeader();
                }
            }
        }
        this.attributeMap = this.toMap(attributeArray, Attribute.NAME_FUNCTION);
        this.variables = variableInfoArray;
    }

    private static String tagName(int n) {
        short s;
        switch (n) {
            case 10: {
                s = 15;
                break;
            }
            case 11: {
                s = 61;
                break;
            }
            case 12: {
                s = 4;
                break;
            }
            default: {
                return Integer.toHexString(n);
            }
        }
        return Vocabulary.format(s);
    }

    private Errors errors() {
        return Errors.getResources(this.listeners.getLocale());
    }

    private DataStoreException malformedHeader() {
        return new DataStoreException(this.errors().getString((short)8, "NetCDF", this.input.filename));
    }

    private void ensureNonNegative(int n, int n2) throws DataStoreException {
        if (n < 0) {
            throw new DataStoreException(this.errors().getString((short)68, this.input.filename + ':' + ChannelDecoder.tagName(n2)));
        }
    }

    private int ensureBufferContains(int n, int n2, String string) throws IOException, DataStoreException {
        long l = ((long)n & 0xFFFFFFFFL) * (long)n2 + 3L & 0xFFFFFFFFFFFFFFFCL;
        if (l > (long)this.input.buffer.capacity()) {
            string = this.input.filename + ':' + string;
            Errors errors = this.errors();
            throw new DataStoreException(n < 0 ? errors.getString((short)68, string) : errors.getString((short)25, string, n));
        }
        this.input.ensureBufferContains((int)l);
        return (int)l;
    }

    private long readOffset() throws IOException {
        return this.is64bits ? this.input.readLong() : this.input.readUnsignedInt();
    }

    private String readName() throws IOException, DataStoreException {
        int n = this.input.readInt();
        if (n < 0) {
            throw this.malformedHeader();
        }
        int n2 = this.ensureBufferContains(n, 1, "<name>");
        String string = this.input.readString(n, NAME_ENCODING);
        this.input.buffer.position(this.input.buffer.position() + (n2 - n));
        return string;
    }

    private Object readValues(String string, int n, int n2) throws IOException, DataStoreException {
        Object object;
        if (n2 == 0) {
            return null;
        }
        ByteBuffer byteBuffer = this.input.buffer;
        int n3 = this.ensureBufferContains(n2, VariableInfo.sizeOf(n), string);
        int n4 = byteBuffer.position();
        switch (n) {
            case 2: {
                String string2 = this.input.readString(n2, "ISO-8859-1").trim();
                object = string2.isEmpty() ? null : string2;
                break;
            }
            case 1: {
                byte[] byArray = new byte[n2];
                byteBuffer.get(byArray);
                object = byArray;
                break;
            }
            case 3: {
                short[] sArray = new short[n2];
                byteBuffer.asShortBuffer().get(sArray);
                object = sArray;
                break;
            }
            case 4: {
                int[] nArray = new int[n2];
                byteBuffer.asIntBuffer().get(nArray);
                object = nArray;
                break;
            }
            case 5: {
                float[] fArray = new float[n2];
                byteBuffer.asFloatBuffer().get(fArray);
                object = fArray;
                break;
            }
            case 6: {
                double[] dArray = new double[n2];
                byteBuffer.asDoubleBuffer().get(dArray);
                object = dArray;
                break;
            }
            default: {
                throw this.malformedHeader();
            }
        }
        byteBuffer.position(n4 + n3);
        return object;
    }

    private Dimension[] readDimensions(int n) throws IOException, DataStoreException {
        Dimension[] dimensionArray = new Dimension[n];
        for (int i = 0; i < n; ++i) {
            String string = this.readName();
            int n2 = this.input.readInt();
            if (n2 == 0 && (n2 = this.numrecs) == -1) {
                throw new DataStoreException(this.errors().getString((short)64, "numrecs"));
            }
            dimensionArray[i] = new Dimension(string, n2);
        }
        return dimensionArray;
    }

    private Attribute[] readAttributes(int n) throws IOException, DataStoreException {
        Attribute[] attributeArray = new Attribute[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string = this.readName();
            Object object = this.readValues(string, this.input.readInt(), this.input.readInt());
            if (object == null) continue;
            attributeArray[n2++] = new Attribute(string, object);
        }
        return ArraysExt.resize(attributeArray, n2);
    }

    private VariableInfo[] readVariables(int n, Dimension[] dimensionArray) throws IOException, DataStoreException {
        if (dimensionArray == null) {
            throw this.malformedHeader();
        }
        VariableInfo[] variableInfoArray = new VariableInfo[n];
        for (int i = 0; i < n; ++i) {
            String string = this.readName();
            int n2 = this.input.readInt();
            Dimension[] dimensionArray2 = new Dimension[n2];
            try {
                for (int j = 0; j < n2; ++j) {
                    dimensionArray2[j] = dimensionArray[this.input.readInt()];
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                DataStoreException dataStoreException = this.malformedHeader();
                dataStoreException.initCause(indexOutOfBoundsException);
                throw dataStoreException;
            }
            Attribute[] attributeArray = null;
            long l = this.input.readLong();
            if (l != 0L) {
                int n3 = (int)(l >>> 32);
                int n4 = (int)l;
                this.ensureNonNegative(n4, n3);
                switch (n3) {
                    case 12: {
                        attributeArray = this.readAttributes(n4);
                        break;
                    }
                    default: {
                        throw this.malformedHeader();
                    }
                }
            }
            variableInfoArray[i] = new VariableInfo(this.input, string, dimensionArray2, dimensionArray, this.toMap(attributeArray, Attribute.NAME_FUNCTION), this.input.readInt(), this.input.readInt(), this.readOffset());
        }
        return variableInfoArray;
    }

    private <E> Map<String, E> toMap(E[] EArray, Function<E, String> function) throws DataStoreException {
        try {
            return CollectionsExt.toCaseInsensitiveNameMap(Arrays.asList(EArray), function, NAME_LOCALE);
        }
        catch (InvalidParameterCardinalityException invalidParameterCardinalityException) {
            throw new DataStoreException(this.errors().getString((short)131, invalidParameterCardinalityException.getParameterName()));
        }
    }

    @Override
    public void setSearchPath(String ... stringArray) throws IOException {
    }

    @Override
    public String[] getSearchPath() throws IOException {
        return new String[1];
    }

    private Attribute findAttribute(String string) {
        String string2;
        Attribute attribute = this.attributeMap.get(string);
        if (attribute == null && string != null && (string2 = string.toLowerCase(NAME_LOCALE)) != string) {
            attribute = this.attributeMap.get(string2);
        }
        return attribute;
    }

    @Override
    public String stringValue(String string) throws IOException {
        Attribute attribute = this.findAttribute(string);
        if (attribute != null) {
            return attribute.value.toString();
        }
        return null;
    }

    @Override
    public Number numericValue(String string) throws IOException {
        Attribute attribute = this.findAttribute(string);
        if (attribute != null && attribute.value != null) {
            if (attribute.value instanceof String) {
                return this.parseNumber((String)attribute.value);
            }
            return (Number)Array.get(attribute.value, 0);
        }
        return null;
    }

    @Override
    public Date dateValue(String string) throws IOException {
        Attribute attribute = this.findAttribute(string);
        if (attribute != null && attribute.value instanceof String) {
            try {
                return JDK8.parseDateTime(Attribute.dateToISO((String)attribute.value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.listeners.warning(null, illegalArgumentException);
            }
        }
        return null;
    }

    @Override
    public Date[] numberToDate(String string, Number ... numberArray) throws IOException {
        Date[] dateArray = new Date[numberArray.length];
        String[] stringArray = TIME_UNIT_PATTERN.split(string);
        if (stringArray.length == 2) {
            try {
                UnitConverter unitConverter = Units.valueOf(stringArray[0]).getConverterToAny(Units.MILLISECOND);
                long l = JDK8.parseDateTime(Attribute.dateToISO(stringArray[1])).getTime();
                for (int i = 0; i < numberArray.length; ++i) {
                    Number number = numberArray[i];
                    if (number == null) continue;
                    dateArray[i] = new Date(l + Math.round(unitConverter.convert(number.doubleValue())));
                }
            }
            catch (ConversionException conversionException) {
                this.listeners.warning(null, conversionException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.listeners.warning(null, illegalArgumentException);
            }
        }
        return dateArray;
    }

    @Override
    public Variable[] getVariables() throws IOException {
        return this.variables;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public GridGeometry[] getGridGeometries() throws IOException {
        if (this.gridGeometries == null) {
            IdentityHashMap identityHashMap = new IdentityHashMap();
            for (VariableInfo variableInfo : this.variables) {
                if (!variableInfo.isCoordinateSystemAxis()) continue;
                for (Dimension object : variableInfo.dimensions) {
                    CollectionsExt.addToMultiValuesMap(identityHashMap, object, variableInfo);
                }
            }
            LinkedHashSet linkedHashSet = new LinkedHashSet(4);
            LinkedHashMap<List<Dimension>, GridGeometryInfo> linkedHashMap = new LinkedHashMap<List<Dimension>, GridGeometryInfo>();
            block2: for (VariableInfo variableInfo : this.variables) {
                void var9_20;
                if (variableInfo.isCoordinateSystemAxis()) continue;
                List<Dimension> list = Arrays.asList(variableInfo.dimensions);
                GridGeometryInfo gridGeometryInfo = (GridGeometryInfo)linkedHashMap.get(list);
                if (gridGeometryInfo == null) {
                    for (Dimension dimension : variableInfo.dimensions) {
                        List list2 = (List)identityHashMap.get(dimension);
                        if (list2 == null) {
                            linkedHashSet.clear();
                            continue block2;
                        }
                        linkedHashSet.addAll(list2);
                    }
                    GridGeometryInfo gridGeometryInfo2 = new GridGeometryInfo(variableInfo.dimensions, linkedHashSet.toArray(new VariableInfo[linkedHashSet.size()]));
                    linkedHashMap.put(list, gridGeometryInfo2);
                    linkedHashSet.clear();
                }
                variableInfo.gridGeometry = var9_20;
            }
            this.gridGeometries = linkedHashMap.values().toArray(new GridGeometry[linkedHashMap.size()]);
        }
        return this.gridGeometries;
    }

    @Override
    public void close() throws IOException {
        this.input.channel.close();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SIS driver: \u201c").append(this.input.filename).append('\u201d');
        if (!this.input.channel.isOpen()) {
            stringBuilder.append(" (closed)");
        }
        return stringBuilder.toString();
    }
}

