/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.referencing;

import javax.measure.unit.NonSI;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.gco.PropertyType;
import org.apache.sis.measure.MeasurementRange;
import org.apache.sis.parameter.DefaultParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;

public final class CC_OperationParameter
extends PropertyType<CC_OperationParameter, ParameterDescriptor<?>> {
    public Class<?> valueClass;
    public MeasurementRange<?> valueDomain;

    public CC_OperationParameter() {
    }

    @Override
    protected Class<ParameterDescriptor<?>> getBoundType() {
        return ParameterDescriptor.class;
    }

    private CC_OperationParameter(ParameterDescriptor<?> parameterDescriptor) {
        super(parameterDescriptor);
    }

    @Override
    protected CC_OperationParameter wrap(ParameterDescriptor<?> parameterDescriptor) {
        return new CC_OperationParameter(parameterDescriptor);
    }

    @XmlElement(name="OperationParameter")
    public DefaultParameterDescriptor<?> getElement() {
        return DefaultParameterDescriptor.castOrCopy((ParameterDescriptor)this.metadata);
    }

    public void setElement(DefaultParameterDescriptor<?> defaultParameterDescriptor) {
        this.metadata = defaultParameterDescriptor;
    }

    private void beforeUnmarshal(Unmarshaller unmarshaller, Object object) {
        Object t;
        if (object instanceof ParameterValue && (t = ((ParameterValue)object).getValue()) != null) {
            this.valueClass = t.getClass();
            Unit<Object> unit = ((ParameterValue)object).getUnit();
            if (unit != null) {
                if (SI.RADIAN.equals(unit = unit.toSI())) {
                    unit = NonSI.DEGREE_ANGLE;
                }
                assert (this.valueClass == Double.class || this.valueClass == double[].class) : this.valueClass;
                this.valueDomain = MeasurementRange.create(Double.NEGATIVE_INFINITY, false, Double.POSITIVE_INFINITY, false, unit);
            }
            Context.setWrapper(Context.current(), this);
        }
    }

    private void afterUnmarshal(Unmarshaller unmarshaller, Object object) {
        Context.setWrapper(Context.current(), null);
    }
}

