/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gml;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlValue;
import org.apache.sis.util.iso.Names;
import org.opengis.util.GenericName;
import org.opengis.util.NameSpace;

@XmlSeeAlso(value={LocalName.class, ScopedName.class})
public class CodeType {
    @XmlValue
    String value;
    @XmlAttribute
    @XmlSchemaType(name="anyURI")
    String codeSpace;

    public final void setName(GenericName genericName) {
        this.value = genericName.toString();
        NameSpace nameSpace = genericName.scope();
        if (nameSpace != null && !nameSpace.isGlobal()) {
            this.codeSpace = nameSpace.name().toString();
        }
    }

    public GenericName getName() {
        return Names.parseGenericName(this.codeSpace, ":", this.value);
    }

    @XmlRootElement(name="ScopedName", namespace="http://www.isotc211.org/2005/gco")
    public static final class ScopedName
    extends CodeType {
    }

    @XmlRootElement(name="LocalName", namespace="http://www.isotc211.org/2005/gco")
    public static final class LocalName
    extends CodeType {
        @Override
        public GenericName getName() {
            return Names.createLocalName(this.codeSpace, ":", this.value);
        }
    }
}

