/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.hslf.model.textproperties.TextPropCollection;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LittleEndianOutputStream;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class TxMasterStyleAtom
extends RecordAtom {
    private static final POILogger LOG = POILogFactory.getLogger(TxMasterStyleAtom.class);
    public static final int MAX_INDENT = 5;
    private byte[] _header = new byte[8];
    private static long _type = 4003L;
    private byte[] _data;
    private List<TextPropCollection> paragraphStyles;
    private List<TextPropCollection> charStyles;

    protected TxMasterStyleAtom(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._data = new byte[len - 8];
        System.arraycopy(source, start + 8, this._data, 0, this._data.length);
        try {
            this.init();
        }
        catch (Exception e) {
            LOG.log(5, new Object[]{"Exception when reading available styles", e});
        }
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._data);
    }

    public List<TextPropCollection> getCharacterStyles() {
        return this.charStyles;
    }

    public List<TextPropCollection> getParagraphStyles() {
        return this.paragraphStyles;
    }

    public int getTextType() {
        return LittleEndian.getShort(this._header, 0) >> 4;
    }

    protected void init() {
        int type = this.getTextType();
        int pos = 0;
        short levels = LittleEndian.getShort(this._data, 0);
        pos += 2;
        this.paragraphStyles = new ArrayList<TextPropCollection>(levels);
        this.charStyles = new ArrayList<TextPropCollection>(levels);
        for (short i = 0; i < levels; i = (short)(i + 1)) {
            TextPropCollection prprops = new TextPropCollection(0, TextPropCollection.TextPropType.paragraph);
            if (type >= 5) {
                short indentLevel = LittleEndian.getShort(this._data, pos);
                prprops.setIndentLevel(indentLevel);
                pos += 2;
            } else {
                prprops.setIndentLevel((short)-1);
            }
            int head = LittleEndian.getInt(this._data, pos);
            pos += 4;
            pos += prprops.buildTextPropList(head, this._data, pos);
            this.paragraphStyles.add(prprops);
            head = LittleEndian.getInt(this._data, pos);
            pos += 4;
            TextPropCollection chprops = new TextPropCollection(0, TextPropCollection.TextPropType.character);
            pos += chprops.buildTextPropList(head, this._data, pos);
            this.charStyles.add(chprops);
        }
    }

    public void updateStyles() {
        int type = this.getTextType();
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            LittleEndianOutputStream leos = new LittleEndianOutputStream(bos);
            int levels = this.paragraphStyles.size();
            leos.writeShort(levels);
            TextPropCollection prdummy = new TextPropCollection(0, TextPropCollection.TextPropType.paragraph);
            TextPropCollection chdummy = new TextPropCollection(0, TextPropCollection.TextPropType.character);
            for (int i = 0; i < levels; ++i) {
                prdummy.copy(this.paragraphStyles.get(i));
                chdummy.copy(this.charStyles.get(i));
                if (type >= 5) {
                    leos.writeShort(prdummy.getIndentLevel());
                }
                prdummy.setIndentLevel((short)-1);
                prdummy.writeOut(bos, true);
                chdummy.writeOut(bos, true);
            }
            this._data = bos.toByteArray();
            leos.close();
            LittleEndian.putInt(this._header, 4, this._data.length);
        }
        catch (IOException e) {
            throw new HSLFException("error in updating master style properties", e);
        }
    }
}

