/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.ddf.DefaultEscherRecordFactory;
import org.apache.poi.ddf.EscherBoolProperty;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherDgRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherRGBProperty;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.ddf.EscherSpRecord;
import org.apache.poi.ddf.EscherSpgrRecord;
import org.apache.poi.ddf.EscherTextboxRecord;
import org.apache.poi.hslf.record.BinaryTagDataBlob;
import org.apache.poi.hslf.record.CString;
import org.apache.poi.hslf.record.DummyPositionSensitiveRecordWithChildren;
import org.apache.poi.hslf.record.EscherTextboxWrapper;
import org.apache.poi.hslf.record.HSLFEscherClientDataRecord;
import org.apache.poi.hslf.record.HSLFEscherRecordFactory;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.record.StyleTextProp9Atom;
import org.apache.poi.sl.usermodel.ShapeType;
import org.apache.poi.util.LittleEndian;

public final class PPDrawing
extends RecordAtom {
    private byte[] _header;
    private long _type;
    private final List<EscherRecord> childRecords = new ArrayList<EscherRecord>();
    private EscherTextboxWrapper[] textboxWrappers;
    private EscherDgRecord dg;

    public List<EscherRecord> getEscherRecords() {
        return this.childRecords;
    }

    public EscherTextboxWrapper[] getTextboxWrappers() {
        return this.textboxWrappers;
    }

    public PPDrawing() {
        this._header = new byte[8];
        LittleEndian.putUShort(this._header, 0, 15);
        LittleEndian.putUShort(this._header, 2, RecordTypes.PPDrawing.typeID);
        LittleEndian.putInt(this._header, 4, 0);
        this.textboxWrappers = new EscherTextboxWrapper[0];
        this.create();
    }

    protected PPDrawing(byte[] source, int start, int len) {
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this._type = LittleEndian.getUShort(this._header, 2);
        byte[] contents = new byte[len];
        System.arraycopy(source, start, contents, 0, len);
        HSLFEscherRecordFactory erf = new HSLFEscherRecordFactory();
        this.findEscherChildren(erf, contents, 8, len - 8, this.childRecords);
        EscherContainerRecord dgContainer = this.getDgContainer();
        if (dgContainer != null) {
            this.textboxWrappers = this.findInDgContainer(dgContainer);
        } else {
            ArrayList<EscherTextboxWrapper> textboxes = new ArrayList<EscherTextboxWrapper>();
            this.findEscherTextboxRecord(this.childRecords, textboxes);
            this.textboxWrappers = textboxes.toArray(new EscherTextboxWrapper[textboxes.size()]);
        }
    }

    private EscherTextboxWrapper[] findInDgContainer(EscherContainerRecord dgContainer) {
        EscherContainerRecord[] spContainers;
        LinkedList<EscherTextboxWrapper> found = new LinkedList<EscherTextboxWrapper>();
        EscherContainerRecord spgrContainer = this.findFirstEscherContainerRecordOfType(RecordTypes.EscherSpgrContainer, dgContainer);
        for (EscherContainerRecord spContainer : spContainers = this.findAllEscherContainerRecordOfType(RecordTypes.EscherSpContainer, spgrContainer)) {
            EscherSpRecord sp = (EscherSpRecord)this.findFirstEscherRecordOfType(RecordTypes.EscherSp, spContainer);
            EscherTextboxRecord clientTextbox = (EscherTextboxRecord)this.findFirstEscherRecordOfType(RecordTypes.EscherClientTextbox, spContainer);
            if (null == clientTextbox) continue;
            EscherTextboxWrapper w = new EscherTextboxWrapper(clientTextbox);
            StyleTextProp9Atom nineAtom = this.findInSpContainer(spContainer);
            w.setStyleTextProp9Atom(nineAtom);
            if (null != sp) {
                w.setShapeId(sp.getShapeId());
            }
            found.add(w);
        }
        return found.toArray(new EscherTextboxWrapper[found.size()]);
    }

    private StyleTextProp9Atom findInSpContainer(EscherContainerRecord spContainer) {
        HSLFEscherClientDataRecord cldata = (HSLFEscherClientDataRecord)spContainer.getChildById(RecordTypes.EscherClientData.typeID);
        if (cldata == null) {
            return null;
        }
        DummyPositionSensitiveRecordWithChildren progTags = (DummyPositionSensitiveRecordWithChildren)PPDrawing.getChildRecord(cldata.getHSLFChildRecords(), RecordTypes.ProgTags);
        if (progTags == null) {
            return null;
        }
        DummyPositionSensitiveRecordWithChildren progBinaryTag = (DummyPositionSensitiveRecordWithChildren)progTags.findFirstOfType(RecordTypes.ProgBinaryTag.typeID);
        if (progBinaryTag == null) {
            return null;
        }
        int size = progBinaryTag.getChildRecords().length;
        if (2 != size) {
            return null;
        }
        Record r0 = progBinaryTag.getChildRecords()[0];
        Record r1 = progBinaryTag.getChildRecords()[1];
        if (!(r0 instanceof CString)) {
            return null;
        }
        if (!"___PPT9".equals(((CString)r0).getText())) {
            return null;
        }
        if (!(r1 instanceof BinaryTagDataBlob)) {
            return null;
        }
        BinaryTagDataBlob blob = (BinaryTagDataBlob)r1;
        if (1 != blob.getChildRecords().length) {
            return null;
        }
        return (StyleTextProp9Atom)blob.findFirstOfType(RecordTypes.StyleTextProp9Atom.typeID);
    }

    private void findEscherChildren(DefaultEscherRecordFactory erf, byte[] source, int startPos, int lenToGo, List<EscherRecord> found) {
        int escherBytes = LittleEndian.getInt(source, startPos + 4) + 8;
        EscherRecord r = erf.createRecord(source, startPos);
        r.fillFields(source, startPos, erf);
        found.add(r);
        int size = r.getRecordSize();
        if (size < 8) {
            logger.log(5, new Object[]{"Hit short DDF record at " + startPos + " - " + size});
        }
        if (size != escherBytes) {
            logger.log(5, new Object[]{"Record length=" + escherBytes + " but getRecordSize() returned " + r.getRecordSize() + "; record: " + r.getClass()});
            size = escherBytes;
        }
        startPos += size;
        if ((lenToGo -= size) >= 8) {
            this.findEscherChildren(erf, source, startPos, lenToGo, found);
        }
    }

    private void findEscherTextboxRecord(List<EscherRecord> toSearch, List<EscherTextboxWrapper> found) {
        EscherSpRecord sp = null;
        for (EscherRecord r : toSearch) {
            if (r instanceof EscherSpRecord) {
                sp = (EscherSpRecord)r;
                continue;
            }
            if (r instanceof EscherTextboxRecord) {
                EscherTextboxRecord tbr = (EscherTextboxRecord)r;
                EscherTextboxWrapper w = new EscherTextboxWrapper(tbr);
                if (sp != null) {
                    w.setShapeId(sp.getShapeId());
                }
                found.add(w);
                continue;
            }
            if (!r.isContainerRecord()) continue;
            List<EscherRecord> children = r.getChildRecords();
            this.findEscherTextboxRecord(children, found);
        }
    }

    @Override
    public long getRecordType() {
        return this._type;
    }

    @Override
    public Record[] getChildRecords() {
        return null;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        for (EscherTextboxWrapper w : this.textboxWrappers) {
            w.writeOut(null);
        }
        int newSize = 0;
        for (EscherRecord er : this.childRecords) {
            newSize += er.getRecordSize();
        }
        LittleEndian.putInt(this._header, 4, newSize);
        out.write(this._header);
        byte[] b = new byte[newSize];
        int done = 0;
        for (EscherRecord r : this.childRecords) {
            done += r.serialize(done, b);
        }
        out.write(b);
    }

    private void create() {
        EscherContainerRecord dgContainer = new EscherContainerRecord();
        dgContainer.setRecordId((short)-4094);
        dgContainer.setOptions((short)15);
        this.dg = new EscherDgRecord();
        this.dg.setOptions((short)16);
        this.dg.setNumShapes(1);
        dgContainer.addChildRecord(this.dg);
        EscherContainerRecord spgrContainer = new EscherContainerRecord();
        spgrContainer.setOptions((short)15);
        spgrContainer.setRecordId((short)-4093);
        EscherContainerRecord spContainer = new EscherContainerRecord();
        spContainer.setOptions((short)15);
        spContainer.setRecordId((short)-4092);
        EscherSpgrRecord spgr = new EscherSpgrRecord();
        spgr.setOptions((short)1);
        spContainer.addChildRecord(spgr);
        EscherSpRecord sp = new EscherSpRecord();
        sp.setOptions((short)((ShapeType.NOT_PRIMITIVE.nativeId << 4) + 2));
        sp.setFlags(5);
        spContainer.addChildRecord(sp);
        spgrContainer.addChildRecord(spContainer);
        dgContainer.addChildRecord(spgrContainer);
        spContainer = new EscherContainerRecord();
        spContainer.setOptions((short)15);
        spContainer.setRecordId((short)-4092);
        sp = new EscherSpRecord();
        sp.setOptions((short)((ShapeType.RECT.nativeId << 4) + 2));
        sp.setFlags(3072);
        spContainer.addChildRecord(sp);
        EscherOptRecord opt = new EscherOptRecord();
        opt.setRecordId((short)-4085);
        opt.addEscherProperty(new EscherRGBProperty(385, 0x8000000));
        opt.addEscherProperty(new EscherRGBProperty(387, 0x8000005));
        opt.addEscherProperty(new EscherSimpleProperty(403, 10064750));
        opt.addEscherProperty(new EscherSimpleProperty(404, 7778750));
        opt.addEscherProperty(new EscherBoolProperty(447, 0x120012));
        opt.addEscherProperty(new EscherBoolProperty(511, 524288));
        opt.addEscherProperty(new EscherSimpleProperty(772, 9));
        opt.addEscherProperty(new EscherSimpleProperty(831, 65537));
        spContainer.addChildRecord(opt);
        dgContainer.addChildRecord(spContainer);
        this.childRecords.add(dgContainer);
    }

    public void addTextboxWrapper(EscherTextboxWrapper txtbox) {
        EscherTextboxWrapper[] tw = new EscherTextboxWrapper[this.textboxWrappers.length + 1];
        System.arraycopy(this.textboxWrappers, 0, tw, 0, this.textboxWrappers.length);
        tw[this.textboxWrappers.length] = txtbox;
        this.textboxWrappers = tw;
    }

    public EscherContainerRecord getDgContainer() {
        if (this.childRecords.isEmpty()) {
            return null;
        }
        EscherRecord r = this.childRecords.get(0);
        if (r instanceof EscherContainerRecord && r.getRecordId() == RecordTypes.EscherDgContainer.typeID) {
            return (EscherContainerRecord)r;
        }
        return null;
    }

    public EscherDgRecord getEscherDgRecord() {
        if (this.dg == null) {
            for (EscherRecord r : this.getDgContainer().getChildRecords()) {
                if (!(r instanceof EscherDgRecord)) continue;
                this.dg = (EscherDgRecord)r;
                break;
            }
        }
        return this.dg;
    }

    protected EscherContainerRecord findFirstEscherContainerRecordOfType(RecordTypes type, EscherContainerRecord parent) {
        if (null == parent) {
            return null;
        }
        List<EscherContainerRecord> children = parent.getChildContainers();
        for (EscherContainerRecord child : children) {
            if (type.typeID != child.getRecordId()) continue;
            return child;
        }
        return null;
    }

    protected EscherRecord findFirstEscherRecordOfType(RecordTypes type, EscherContainerRecord parent) {
        if (null == parent) {
            return null;
        }
        List<EscherRecord> children = parent.getChildRecords();
        for (EscherRecord child : children) {
            if (type.typeID != child.getRecordId()) continue;
            return child;
        }
        return null;
    }

    protected EscherContainerRecord[] findAllEscherContainerRecordOfType(RecordTypes type, EscherContainerRecord parent) {
        if (null == parent) {
            return new EscherContainerRecord[0];
        }
        List<EscherContainerRecord> children = parent.getChildContainers();
        LinkedList<EscherContainerRecord> result = new LinkedList<EscherContainerRecord>();
        for (EscherContainerRecord child : children) {
            if (type.typeID != child.getRecordId()) continue;
            result.add(child);
        }
        return result.toArray(new EscherContainerRecord[result.size()]);
    }

    public StyleTextProp9Atom[] getNumberedListInfo() {
        EscherContainerRecord[] spContainers;
        LinkedList<StyleTextProp9Atom> result = new LinkedList<StyleTextProp9Atom>();
        EscherContainerRecord dgContainer = this.getDgContainer();
        EscherContainerRecord spgrContainer = this.findFirstEscherContainerRecordOfType(RecordTypes.EscherSpgrContainer, dgContainer);
        for (EscherContainerRecord spContainer : spContainers = this.findAllEscherContainerRecordOfType(RecordTypes.EscherSpContainer, spgrContainer)) {
            StyleTextProp9Atom prop9 = this.findInSpContainer(spContainer);
            if (prop9 == null) continue;
            result.add(prop9);
        }
        return result.toArray(new StyleTextProp9Atom[result.size()]);
    }

    private static <T extends Record> T getChildRecord(List<? extends Record> children, RecordTypes type) {
        for (Record record : children) {
            if (record.getRecordType() != (long)type.typeID) continue;
            return (T)record;
        }
        return null;
    }
}

