/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.extractor;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.POIOLE2TextExtractor;
import org.apache.poi.POITextExtractor;
import org.apache.poi.hdgf.extractor.VisioTextExtractor;
import org.apache.poi.hpbf.extractor.PublisherTextExtractor;
import org.apache.poi.hslf.extractor.PowerPointExtractor;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.extractor.OutlookTextExtactor;
import org.apache.poi.hwpf.OldWordFileFormatException;
import org.apache.poi.hwpf.extractor.Word6Extractor;
import org.apache.poi.hwpf.extractor.WordExtractor;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;

public class OLE2ScratchpadExtractorFactory {
    public static POITextExtractor createExtractor(DirectoryNode poifsDir) throws IOException {
        String[] outlookEntryNames;
        if (poifsDir.hasEntry("WordDocument")) {
            try {
                return new WordExtractor(poifsDir);
            }
            catch (OldWordFileFormatException e) {
                return new Word6Extractor(poifsDir);
            }
        }
        if (poifsDir.hasEntry("PowerPoint Document")) {
            return new PowerPointExtractor(poifsDir);
        }
        if (poifsDir.hasEntry("VisioDocument")) {
            return new VisioTextExtractor(poifsDir);
        }
        if (poifsDir.hasEntry("Quill")) {
            return new PublisherTextExtractor(poifsDir);
        }
        for (String entryName : outlookEntryNames = new String[]{"__substg1.0_1000001E", "__substg1.0_1000001F", "__substg1.0_0047001E", "__substg1.0_0047001F", "__substg1.0_0037001E", "__substg1.0_0037001F"}) {
            if (!poifsDir.hasEntry(entryName)) continue;
            return new OutlookTextExtactor(poifsDir);
        }
        throw new IllegalArgumentException("No supported documents found in the OLE2 stream");
    }

    public static void identifyEmbeddedResources(POIOLE2TextExtractor ext, List<Entry> dirs, List<InputStream> nonPOIFS) throws IOException {
        DirectoryEntry root = ext.getRoot();
        if (root == null) {
            throw new IllegalStateException("The extractor didn't know which POIFS it came from!");
        }
        if (ext instanceof WordExtractor) {
            try {
                DirectoryEntry op = (DirectoryEntry)root.getEntry("ObjectPool");
                Iterator<Entry> it = op.getEntries();
                while (it.hasNext()) {
                    Entry entry = it.next();
                    if (!entry.getName().startsWith("_")) continue;
                    dirs.add(entry);
                }
            }
            catch (FileNotFoundException op) {}
        } else if (ext instanceof OutlookTextExtactor) {
            MAPIMessage msg = ((OutlookTextExtactor)ext).getMAPIMessage();
            for (AttachmentChunks attachment : msg.getAttachmentFiles()) {
                if (attachment.attachData != null) {
                    byte[] data = attachment.attachData.getValue();
                    nonPOIFS.add(new ByteArrayInputStream(data));
                    continue;
                }
                if (attachment.attachmentDirectory == null) continue;
                dirs.add(attachment.attachmentDirectory.getDirectory());
            }
        }
    }
}

