/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.attachment.ByteDataSource;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PrimitiveUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.ContentDisposition;
import org.apache.cxf.jaxrs.ext.multipart.InputStreamDataSource;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.apache.cxf.jaxrs.ext.multipart.MultipartBody;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.multipart.AttachmentUtils;
import org.apache.cxf.message.MessageUtils;

@Provider
@Consumes(value={"multipart/related", "multipart/mixed", "multipart/alternative", "multipart/form-data"})
@Produces(value={"multipart/related", "multipart/mixed", "multipart/alternative", "multipart/form-data"})
public class MultipartProvider
extends AbstractConfigurableProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final String SUPPORT_TYPE_AS_MULTIPART = "support.type.as.multipart";
    private static final Logger LOG = LogUtils.getL7dLogger(MultipartProvider.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(MultipartProvider.class);
    private static final Set<Class<?>> WELL_KNOWN_MULTIPART_CLASSES = new HashSet();
    private static final Set<String> MULTIPART_SUBTYPES;
    @Context
    private MessageContext mc;
    private String attachmentDir;
    private String attachmentThreshold;
    private String attachmentMaxSize;

    public void setMessageContext(MessageContext context) {
        this.mc = context;
    }

    public void setAttachmentDirectory(String dir) {
        this.attachmentDir = dir;
    }

    public void setAttachmentThreshold(String threshold) {
        this.attachmentThreshold = threshold;
    }

    public void setAttachmentMaxSize(String maxSize) {
        this.attachmentMaxSize = maxSize;
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return this.isSupported(type, genericType, annotations, mt);
    }

    private boolean isSupported(Class<?> type, Type genericType, Annotation[] anns, MediaType mt) {
        return this.mediaTypeSupported(mt) && (WELL_KNOWN_MULTIPART_CLASSES.contains(type) || Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type) && type != MultivaluedMap.class || AnnotationUtils.getAnnotation(anns, Multipart.class) != null || MessageUtils.isTrue(this.mc.getContextualProperty(SUPPORT_TYPE_AS_MULTIPART)));
    }

    protected void checkContentLength() {
        if (this.mc != null && this.isPayloadEmpty(this.mc.getHttpHeaders())) {
            String message = new Message("EMPTY_BODY", BUNDLE, new Object[0]).toString();
            LOG.warning(message);
            throw new WebApplicationException(400);
        }
    }

    @Override
    public Object readFrom(Class<Object> c, Type t, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException, WebApplicationException {
        this.checkContentLength();
        List<Attachment> infos = AttachmentUtils.getAttachments(this.mc, this.attachmentDir, this.attachmentThreshold, this.attachmentMaxSize);
        boolean collectionExpected = Collection.class.isAssignableFrom(c);
        if (collectionExpected && AnnotationUtils.getAnnotation(anns, Multipart.class) == null) {
            return this.getAttachmentCollection(t, infos, anns);
        }
        if (c.isAssignableFrom(Map.class)) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(infos.size());
            Class<?> actual = this.getActualType(t, 1);
            for (Attachment a : infos) {
                map.put(a.getContentType().toString(), this.fromAttachment(a, actual, actual, anns));
            }
            return map;
        }
        if (MultipartBody.class.isAssignableFrom(c)) {
            return new MultipartBody(infos);
        }
        Multipart id = AnnotationUtils.getAnnotation(anns, Multipart.class);
        Attachment multipart = AttachmentUtils.getMultipart(id, mt, infos);
        if (multipart != null) {
            if (collectionExpected && !this.mediaTypeSupported(multipart.getContentType())) {
                List<Attachment> allMultiparts = AttachmentUtils.getMatchingAttachments(id, infos);
                return this.getAttachmentCollection(t, allMultiparts, anns);
            }
            return this.fromAttachment(multipart, c, t, anns);
        }
        if (id != null && !id.required()) {
            Object defaultValue = null;
            if (c.isPrimitive()) {
                defaultValue = PrimitiveUtils.read(c == Boolean.TYPE ? "false" : "0", c);
            }
            return defaultValue;
        }
        throw ExceptionUtils.toBadRequestException(null, null);
    }

    private Object getAttachmentCollection(Type t, List<Attachment> infos, Annotation[] anns) throws IOException {
        Class<?> actual = this.getActualType(t, 0);
        if (Attachment.class.isAssignableFrom(actual)) {
            return infos;
        }
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Attachment a : infos) {
            objects.add(this.fromAttachment(a, actual, actual, anns));
        }
        return objects;
    }

    private Class<?> getActualType(Type type, int pos) {
        Class<?> actual = null;
        try {
            actual = InjectionUtils.getActualType(type, pos);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return actual != null && actual != Object.class ? actual : Attachment.class;
    }

    private <T> Object fromAttachment(Attachment multipart, Class<T> c, Type t, Annotation[] anns) throws IOException {
        MessageBodyReader<T> r;
        if (DataHandler.class.isAssignableFrom(c)) {
            return multipart.getDataHandler();
        }
        if (DataSource.class.isAssignableFrom(c)) {
            return multipart.getDataHandler().getDataSource();
        }
        if (Attachment.class.isAssignableFrom(c)) {
            return multipart;
        }
        if (this.mediaTypeSupported(multipart.getContentType())) {
            this.mc.put("org.apache.cxf.multipart.embedded", true);
            this.mc.put("org.apache.cxf.multipart.embedded.ctype", multipart.getContentType());
            this.mc.put("org.apache.cxf.multipart.embedded.input", multipart.getDataHandler().getInputStream());
            anns = new Annotation[]{};
        }
        if ((r = this.mc.getProviders().getMessageBodyReader(c, t, anns, multipart.getContentType())) != null) {
            InputStream is = multipart.getDataHandler().getInputStream();
            return r.readFrom(c, t, anns, multipart.getContentType(), multipart.getHeaders(), is);
        }
        return null;
    }

    private boolean mediaTypeSupported(MediaType mt) {
        return mt.getType().equals("multipart") && MULTIPART_SUBTYPES.contains(mt.getSubtype());
    }

    @Override
    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return this.isSupported(type, genericType, annotations, mt);
    }

    @Override
    public void writeTo(Object obj, Class<?> type, Type genericType, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        List<Attachment> handlers = this.convertToDataHandlers(obj, type, genericType, anns, mt);
        this.mc.put("org.apache.cxf.jaxrs.attachments.outbound", handlers);
        handlers.get(0).getDataHandler().writeTo(os);
    }

    private List<Attachment> convertToDataHandlers(Object obj, Class<?> type, Type genericType, Annotation[] anns, MediaType mt) throws IOException {
        if (Map.class.isAssignableFrom(obj.getClass())) {
            Map objects = CastUtils.cast((Map)obj);
            ArrayList<Attachment> handlers = new ArrayList<Attachment>(objects.size());
            int i = 0;
            for (Map.Entry entry : objects.entrySet()) {
                Object value = entry.getValue();
                Attachment handler = this.createDataHandler(value, value.getClass(), new Annotation[0], entry.getKey().toString(), mt.toString(), i++);
                handlers.add(handler);
            }
            return handlers;
        }
        String rootMediaType = this.getRootMediaType(anns, mt);
        if (List.class.isAssignableFrom(obj.getClass())) {
            return this.getAttachments((List)obj, rootMediaType);
        }
        if (MultipartBody.class.isAssignableFrom(type)) {
            List<Attachment> atts = ((MultipartBody)obj).getAllAttachments();
            return this.getAttachments(atts, rootMediaType);
        }
        Attachment handler = this.createDataHandler(obj, genericType, anns, rootMediaType, mt.toString(), 1);
        return Collections.singletonList(handler);
    }

    private List<Attachment> getAttachments(List<?> objects, String rootMediaType) throws IOException {
        ArrayList<Attachment> handlers = new ArrayList<Attachment>(objects.size());
        for (int i = 0; i < objects.size(); ++i) {
            Object value = objects.get(i);
            Attachment handler = this.createDataHandler(value, value.getClass(), new Annotation[0], rootMediaType, rootMediaType, i);
            handlers.add(handler);
        }
        return handlers;
    }

    private <T> Attachment createDataHandler(T obj, Type genericType, Annotation[] anns, String mimeType, String mainMediaType, int id) throws IOException {
        Class<?> cls = obj.getClass();
        return this.createDataHandler(obj, cls, genericType, anns, mimeType, mainMediaType, id);
    }

    private <T> Attachment createDataHandler(T obj, Class<T> cls, Type genericType, Annotation[] anns, String mimeType, String mainMediaType, int id) throws IOException {
        DataHandler dh = null;
        if (InputStream.class.isAssignableFrom(obj.getClass())) {
            dh = this.createInputStreamDH((InputStream)obj, mimeType);
        } else if (DataHandler.class.isAssignableFrom(obj.getClass())) {
            dh = (DataHandler)obj;
        } else if (DataSource.class.isAssignableFrom(obj.getClass())) {
            dh = new DataHandler((DataSource)obj);
        } else {
            if (File.class.isAssignableFrom(obj.getClass())) {
                File f = (File)obj;
                ContentDisposition cd = mainMediaType.startsWith("multipart/form-data") ? new ContentDisposition("form-data;name=file;filename=" + f.getName()) : null;
                return new Attachment("root.message@cxf.apache.org", new FileInputStream(f), cd);
            }
            if (Attachment.class.isAssignableFrom(obj.getClass())) {
                Attachment att = (Attachment)obj;
                if (att.getObject() == null) {
                    return att;
                }
                dh = this.getHandlerForObject(att.getObject(), att.getObject().getClass(), new Annotation[0], att.getContentType().toString(), id);
                return new Attachment(att.getContentId(), dh, att.getHeaders());
            }
            if (byte[].class.isAssignableFrom(obj.getClass())) {
                ByteDataSource source = new ByteDataSource((byte[])obj);
                source.setContentType(mimeType);
                dh = new DataHandler((DataSource)source);
            } else {
                dh = this.getHandlerForObject(obj, cls, genericType, anns, mimeType, id);
            }
        }
        String contentId = this.getContentId(anns, id);
        return new Attachment(contentId, dh, new MetadataMap<String, String>());
    }

    private String getContentId(Annotation[] anns, int id) {
        Multipart part = AnnotationUtils.getAnnotation(anns, Multipart.class);
        if (part != null && !"".equals(part.value())) {
            return part.value();
        }
        return id == 0 ? "root.message@cxf.apache.org" : Integer.toString(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> DataHandler getHandlerForObject(T obj, Class<T> cls, Type genericType, Annotation[] anns, String mimeType, int id) {
        MediaType mt = JAXRSUtils.toMediaType(mimeType);
        this.mc.put("active.jaxrs.provider", this);
        MessageBodyWriter<T> r = null;
        try {
            r = this.mc.getProviders().getMessageBodyWriter(cls, genericType, anns, mt);
        }
        finally {
            this.mc.put("active.jaxrs.provider", null);
        }
        if (r == null) {
            Message message = new Message("NO_MSG_WRITER", BUNDLE, cls);
            LOG.severe(message.toString());
            throw ExceptionUtils.toInternalServerErrorException(null, null);
        }
        return new MessageBodyWriterDataHandler<T>(r, obj, cls, genericType, anns, mt);
    }

    private <T> DataHandler getHandlerForObject(T obj, Type genericType, Annotation[] anns, String mimeType, int id) {
        Class<?> cls = obj.getClass();
        return this.getHandlerForObject(obj, cls, genericType, anns, mimeType, id);
    }

    private DataHandler createInputStreamDH(InputStream is, String mimeType) {
        return new DataHandler((DataSource)new InputStreamDataSource(is, mimeType));
    }

    private String getRootMediaType(Annotation[] anns, MediaType mt) {
        String mimeType = mt.getParameters().get("type");
        if (mimeType != null) {
            return mimeType;
        }
        Multipart id = AnnotationUtils.getAnnotation(anns, Multipart.class);
        if (id != null && !"*/*".equals(id.type())) {
            mimeType = id.type();
        }
        if (mimeType == null) {
            mimeType = MessageUtils.isTrue(this.mc.getContextualProperty("mtom-enabled")) ? "text/xml" : "application/octet-stream";
        }
        return mimeType;
    }

    static {
        WELL_KNOWN_MULTIPART_CLASSES.add(MultipartBody.class);
        WELL_KNOWN_MULTIPART_CLASSES.add(Attachment.class);
        MULTIPART_SUBTYPES = new HashSet<String>();
        MULTIPART_SUBTYPES.add("form-data");
        MULTIPART_SUBTYPES.add("mixed");
        MULTIPART_SUBTYPES.add("related");
        MULTIPART_SUBTYPES.add("alternative");
    }

    private static class MessageBodyWriterDataHandler<T>
    extends DataHandler {
        private MessageBodyWriter<T> writer;
        private T obj;
        private Class<T> cls;
        private Type genericType;
        private Annotation[] anns;
        private MediaType contentType;

        public MessageBodyWriterDataHandler(MessageBodyWriter<T> writer, T obj, Class<T> cls, Type genericType, Annotation[] anns, MediaType contentType) {
            super((DataSource)new ByteDataSource("1".getBytes()));
            this.writer = writer;
            this.obj = obj;
            this.cls = cls;
            this.genericType = genericType;
            this.anns = anns;
            this.contentType = contentType;
        }

        public void writeTo(OutputStream os) {
            try {
                this.writer.writeTo(this.obj, this.cls, this.genericType, this.anns, this.contentType, new MetadataMap<String, Object>(), os);
            }
            catch (IOException ex) {
                throw ExceptionUtils.toInternalServerErrorException(ex, null);
            }
        }

        public String getContentType() {
            return this.contentType.toString();
        }
    }
}

