/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.spec;

import java.net.URI;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.client.spec.ClientConfigurableImpl;
import org.apache.cxf.jaxrs.client.spec.InvocationBuilderImpl;
import org.apache.cxf.jaxrs.client.spec.TLSConfiguration;
import org.apache.cxf.jaxrs.model.FilterProviderInfo;
import org.apache.cxf.transport.https.SSLUtils;

public class ClientImpl
implements Client {
    private Configurable<Client> configImpl;
    private TLSConfiguration secConfig;
    private boolean closed;
    private Set<WebClient> baseClients = Collections.newSetFromMap(new WeakHashMap());

    public ClientImpl(Configuration config, TLSConfiguration secConfig) {
        this.configImpl = new ClientConfigurableImpl<ClientImpl>(this, config);
        this.secConfig = secConfig;
    }

    @Override
    public void close() {
        if (!this.closed) {
            for (WebClient wc : this.baseClients) {
                wc.close();
            }
            this.baseClients = null;
            this.closed = true;
        }
    }

    @Override
    public Invocation.Builder invocation(Link link) {
        this.checkNull(link);
        this.checkClosed();
        Invocation.Builder builder = this.target(link.getUriBuilder()).request();
        String type = link.getType();
        if (type != null) {
            builder.accept(type);
        }
        return builder;
    }

    @Override
    public WebTarget target(UriBuilder builder) {
        this.checkNull(builder);
        this.checkClosed();
        return new WebTargetImpl(builder, this.getConfiguration());
    }

    @Override
    public WebTarget target(String address) {
        this.checkNull(address);
        if (address.isEmpty()) {
            address = "/";
        }
        return this.target(UriBuilder.fromUri(address));
    }

    @Override
    public WebTarget target(Link link) {
        this.checkNull(link);
        return this.target(link.getUriBuilder());
    }

    @Override
    public WebTarget target(URI uri) {
        this.checkNull(uri);
        return this.target(UriBuilder.fromUri(uri));
    }

    private void checkNull(Object ... target) {
        for (Object o : target) {
            if (o != null) continue;
            throw new NullPointerException("Value is null");
        }
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        this.checkClosed();
        return this.secConfig.getTlsClientParams().getHostnameVerifier();
    }

    @Override
    public SSLContext getSslContext() {
        this.checkClosed();
        if (this.secConfig.getSslContext() != null) {
            return this.secConfig.getSslContext();
        }
        if (this.secConfig.getTlsClientParams().getTrustManagers() != null) {
            try {
                return SSLUtils.getSSLContext(this.secConfig.getTlsClientParams());
            }
            catch (Exception ex) {
                throw new ProcessingException(ex);
            }
        }
        return null;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException();
        }
    }

    @Override
    public Configuration getConfiguration() {
        this.checkClosed();
        return this.configImpl.getConfiguration();
    }

    @Override
    public Client property(String name, Object value) {
        this.checkClosed();
        return this.configImpl.property(name, value);
    }

    @Override
    public Client register(Class<?> cls) {
        this.checkClosed();
        return this.configImpl.register(cls);
    }

    @Override
    public Client register(Object object) {
        this.checkClosed();
        return this.configImpl.register(object);
    }

    @Override
    public Client register(Class<?> cls, int index) {
        this.checkClosed();
        return this.configImpl.register(cls, index);
    }

    @Override
    public Client register(Class<?> cls, Class<?> ... contracts) {
        this.checkClosed();
        return this.configImpl.register(cls, contracts);
    }

    @Override
    public Client register(Class<?> cls, Map<Class<?>, Integer> map) {
        this.checkClosed();
        return this.configImpl.register(cls, map);
    }

    @Override
    public Client register(Object object, int index) {
        this.checkClosed();
        return this.configImpl.register(object, index);
    }

    @Override
    public Client register(Object object, Class<?> ... contracts) {
        this.checkClosed();
        return this.configImpl.register(object, contracts);
    }

    @Override
    public Client register(Object object, Map<Class<?>, Integer> map) {
        this.checkClosed();
        return this.configImpl.register(object, map);
    }

    public class WebTargetImpl
    implements WebTarget {
        private Configurable<WebTarget> configImpl;
        private UriBuilder uriBuilder;
        private WebClient targetClient;

        public WebTargetImpl(UriBuilder uriBuilder, Configuration config) {
            this(uriBuilder, config, null);
        }

        public WebTargetImpl(UriBuilder uriBuilder, Configuration config, WebClient targetClient) {
            this.configImpl = new ClientConfigurableImpl<WebTargetImpl>(this, config);
            this.uriBuilder = uriBuilder.clone();
            this.targetClient = targetClient;
        }

        public WebClient getWebClient() {
            return this.targetClient;
        }

        @Override
        public Invocation.Builder request() {
            ClientImpl.this.checkClosed();
            this.initTargetClientIfNeeded();
            ClientProviderFactory pf = ClientProviderFactory.getInstance(WebClient.getConfig(this.targetClient).getEndpoint());
            LinkedList<Object> providers = new LinkedList<Object>();
            Configuration cfg = this.configImpl.getConfiguration();
            for (Object p : cfg.getInstances()) {
                if (p instanceof Feature) continue;
                Map<Class<?>, Integer> contracts = cfg.getContracts(p.getClass());
                if (contracts == null || contracts.isEmpty()) {
                    providers.add(p);
                    continue;
                }
                providers.add(new FilterProviderInfo<Object>(p, pf.getBus(), contracts));
            }
            pf.setUserProviders(providers);
            WebClient.getConfig(this.targetClient).getRequestContext().putAll(this.getConfiguration().getProperties());
            WebClient.getConfig(this.targetClient).getRequestContext().put(Client.class.getName(), ClientImpl.this);
            WebClient.getConfig(this.targetClient).getRequestContext().put(Configuration.class.getName(), this.getConfiguration());
            TLSClientParameters tlsParams = ClientImpl.this.secConfig.getTlsClientParams();
            if (tlsParams.getSSLSocketFactory() != null || tlsParams.getTrustManagers() != null) {
                WebClient.getConfig(this.targetClient).getHttpConduit().setTlsClientParameters(tlsParams);
            }
            return new InvocationBuilderImpl(WebClient.fromClient(this.targetClient));
        }

        private void initTargetClientIfNeeded() {
            URI uri = this.uriBuilder.build(new Object[0]);
            if (this.targetClient == null) {
                JAXRSClientFactoryBean bean = new JAXRSClientFactoryBean();
                bean.setAddress(uri.toString());
                this.targetClient = bean.createWebClient();
                ClientImpl.this.baseClients.add(this.targetClient);
            } else if (!this.targetClient.getCurrentURI().equals(uri)) {
                this.targetClient.to(uri.toString(), false);
            }
        }

        @Override
        public Invocation.Builder request(String ... accept) {
            return this.request().accept(accept);
        }

        @Override
        public Invocation.Builder request(MediaType ... accept) {
            return this.request().accept(accept);
        }

        @Override
        public URI getUri() {
            ClientImpl.this.checkClosed();
            return this.uriBuilder.build(new Object[0]);
        }

        @Override
        public UriBuilder getUriBuilder() {
            ClientImpl.this.checkClosed();
            return this.uriBuilder.clone();
        }

        @Override
        public WebTarget path(String path) {
            ClientImpl.this.checkNull(new Object[]{path});
            return this.newWebTarget(this.getUriBuilder().path(path));
        }

        @Override
        public WebTarget queryParam(String name, Object ... values) {
            this.checkNullValues(name, values);
            UriBuilder thebuilder = this.getUriBuilder();
            if (values == null || values.length == 1 && values[0] == null) {
                thebuilder.replaceQueryParam(name, null);
            } else {
                thebuilder.queryParam(name, values);
            }
            return this.newWebTarget(thebuilder);
        }

        @Override
        public WebTarget matrixParam(String name, Object ... values) {
            this.checkNullValues(name, values);
            UriBuilder thebuilder = this.getUriBuilder();
            if (values == null || values.length == 1 && values[0] == null) {
                thebuilder.replaceMatrixParam(name, null);
            } else {
                thebuilder.matrixParam(name, values);
            }
            return this.newWebTarget(thebuilder);
        }

        @Override
        public WebTarget resolveTemplate(String name, Object value) {
            return this.resolveTemplate(name, value, true);
        }

        @Override
        public WebTarget resolveTemplate(String name, Object value, boolean encodeSlash) {
            ClientImpl.this.checkNull(new Object[]{name, value});
            return this.newWebTarget(this.getUriBuilder().resolveTemplate(name, value, encodeSlash));
        }

        @Override
        public WebTarget resolveTemplateFromEncoded(String name, Object value) {
            ClientImpl.this.checkNull(new Object[]{name, value});
            return this.newWebTarget(this.getUriBuilder().resolveTemplateFromEncoded(name, value));
        }

        @Override
        public WebTarget resolveTemplates(Map<String, Object> templatesMap) {
            return this.resolveTemplates(templatesMap, true);
        }

        @Override
        public WebTarget resolveTemplates(Map<String, Object> templatesMap, boolean encodeSlash) {
            this.checkNullMap(templatesMap);
            if (templatesMap.isEmpty()) {
                return this;
            }
            return this.newWebTarget(this.getUriBuilder().resolveTemplates(templatesMap, encodeSlash));
        }

        @Override
        public WebTarget resolveTemplatesFromEncoded(Map<String, Object> templatesMap) {
            this.checkNullMap(templatesMap);
            if (templatesMap.isEmpty()) {
                return this;
            }
            return this.newWebTarget(this.getUriBuilder().resolveTemplatesFromEncoded(templatesMap));
        }

        private WebTarget newWebTarget(UriBuilder newBuilder) {
            ClientImpl.this.checkClosed();
            boolean complete = false;
            if (this.targetClient != null) {
                try {
                    newBuilder.build(new Object[0]);
                    complete = true;
                }
                catch (IllegalArgumentException ex) {
                    // empty catch block
                }
            }
            if (!complete) {
                return new WebTargetImpl(newBuilder, this.getConfiguration());
            }
            WebClient newClient = WebClient.fromClient(this.targetClient);
            return new WebTargetImpl(newBuilder, this.getConfiguration(), newClient);
        }

        @Override
        public Configuration getConfiguration() {
            ClientImpl.this.checkClosed();
            return this.configImpl.getConfiguration();
        }

        @Override
        public WebTarget property(String name, Object value) {
            ClientImpl.this.checkClosed();
            return this.configImpl.property(name, value);
        }

        @Override
        public WebTarget register(Class<?> cls) {
            ClientImpl.this.checkClosed();
            return this.configImpl.register(cls);
        }

        @Override
        public WebTarget register(Object object) {
            ClientImpl.this.checkClosed();
            return this.configImpl.register(object);
        }

        @Override
        public WebTarget register(Class<?> cls, int index) {
            ClientImpl.this.checkClosed();
            return this.configImpl.register(cls, index);
        }

        @Override
        public WebTarget register(Class<?> cls, Class<?> ... contracts) {
            ClientImpl.this.checkClosed();
            return this.configImpl.register(cls, contracts);
        }

        @Override
        public WebTarget register(Class<?> cls, Map<Class<?>, Integer> map) {
            ClientImpl.this.checkClosed();
            return this.configImpl.register(cls, map);
        }

        @Override
        public WebTarget register(Object object, int index) {
            ClientImpl.this.checkClosed();
            return this.configImpl.register(object, index);
        }

        @Override
        public WebTarget register(Object object, Class<?> ... contracts) {
            ClientImpl.this.checkClosed();
            return this.configImpl.register(object, contracts);
        }

        @Override
        public WebTarget register(Object object, Map<Class<?>, Integer> map) {
            ClientImpl.this.checkClosed();
            return this.configImpl.register(object, map);
        }

        private void checkNullValues(Object name, Object ... values) {
            ClientImpl.this.checkNull(new Object[]{name});
            if (values != null && values.length > 1) {
                ClientImpl.this.checkNull(values);
            }
        }

        private void checkNullMap(Map<String, Object> templatesMap) {
            ClientImpl.this.checkNull(new Object[]{templatesMap});
            ClientImpl.this.checkNull(templatesMap.keySet().toArray());
            ClientImpl.this.checkNull(templatesMap.values().toArray());
        }
    }
}

