/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.util.Span;

public final class RegexNameFinder
implements TokenNameFinder {
    private final Pattern[] mPatterns;
    private final String sType;

    public RegexNameFinder(Pattern[] patterns, String type) {
        if (patterns == null || patterns.length == 0) {
            throw new IllegalArgumentException("patterns must not be null or empty!");
        }
        this.mPatterns = patterns;
        this.sType = type;
    }

    public RegexNameFinder(Pattern[] patterns) {
        if (patterns == null || patterns.length == 0) {
            throw new IllegalArgumentException("patterns must not be null or empty!");
        }
        this.mPatterns = patterns;
        this.sType = null;
    }

    public Span[] find(String[] tokens) {
        HashMap<Integer, Integer> sentencePosTokenMap = new HashMap<Integer, Integer>();
        StringBuffer sentenceString = new StringBuffer(tokens.length * 10);
        for (int i = 0; i < tokens.length; ++i) {
            int startIndex = sentenceString.length();
            sentencePosTokenMap.put(startIndex, i);
            sentenceString.append(tokens[i]);
            int endIndex = sentenceString.length();
            sentencePosTokenMap.put(endIndex, i + 1);
            if (i >= tokens.length - 1) continue;
            sentenceString.append(' ');
        }
        LinkedList<Span> annotations = new LinkedList<Span>();
        for (Pattern mPattern : this.mPatterns) {
            Matcher matcher = mPattern.matcher(sentenceString);
            while (matcher.find()) {
                Integer tokenStartIndex = (Integer)sentencePosTokenMap.get(matcher.start());
                Integer tokenEndIndex = (Integer)sentencePosTokenMap.get(matcher.end());
                if (tokenStartIndex == null || tokenEndIndex == null) continue;
                Span annotation = new Span(tokenStartIndex, tokenEndIndex, this.sType);
                annotations.add(annotation);
            }
        }
        return annotations.toArray(new Span[annotations.size()]);
    }

    public void clearAdaptiveData() {
    }
}

