/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentLockedException;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.DbLsn;
import java.io.File;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdUtil {
    private static final String printableChars = "!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";

    public static String getArg(String[] argv, int whichArg) throws IllegalArgumentException {
        if (whichArg < argv.length) {
            return argv[whichArg];
        }
        throw new IllegalArgumentException();
    }

    public static long readLongNumber(String longVal) {
        if (longVal.startsWith("0x")) {
            return Long.parseLong(longVal.substring(2), 16);
        }
        return Long.parseLong(longVal);
    }

    public static long readLsn(String lsnVal) {
        int slashOff = lsnVal.indexOf("/");
        if (slashOff < 0) {
            long fileNum = CmdUtil.readLongNumber(lsnVal);
            return DbLsn.makeLsn(fileNum, 0);
        }
        long fileNum = CmdUtil.readLongNumber(lsnVal.substring(0, slashOff));
        long offset = CmdUtil.readLongNumber(lsnVal.substring(slashOff + 1));
        return DbLsn.makeLsn(fileNum, offset);
    }

    public static void formatEntry(StringBuilder sb, byte[] entryData, boolean formatUsingPrintable) {
        for (byte element : entryData) {
            String hex;
            int b = element & 0xFF;
            if (formatUsingPrintable) {
                if (CmdUtil.isPrint(b)) {
                    if (b == 92) {
                        sb.append('\\');
                    }
                    sb.append(printableChars.charAt(b - 33));
                    continue;
                }
                sb.append('\\');
                hex = Integer.toHexString(b);
                if (b < 16) {
                    sb.append('0');
                }
                sb.append(hex);
                continue;
            }
            hex = Integer.toHexString(b);
            if (b < 16) {
                sb.append('0');
            }
            sb.append(hex);
        }
    }

    private static boolean isPrint(int b) {
        return b < 127 && 32 < b;
    }

    public static EnvironmentImpl makeUtilityEnvironment(File envHome, boolean readOnly) throws EnvironmentNotFoundException, EnvironmentLockedException {
        EnvironmentConfig config = new EnvironmentConfig();
        config.setReadOnly(readOnly);
        config.setConfigParam(EnvironmentParams.JE_LOGGING_DBLOG.getName(), "false");
        config.setConfigParam(EnvironmentParams.ENV_RECOVERY.getName(), "false");
        DbConfigManager.applyFileConfig(envHome, DbInternal.getProps(config), false);
        EnvironmentImpl envImpl = new EnvironmentImpl(envHome, config, null);
        envImpl.finishInit(config);
        return envImpl;
    }

    public static String getJavaCommand(Class<?> cls) {
        String clsName = cls.getName();
        String lastName = clsName.substring(clsName.lastIndexOf(46) + 1);
        return "java { " + cls.getName() + " | -jar je-<version>.jar " + lastName + " }";
    }
}

