/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;

public class LocalCBVLSNTracker {
    private final VLSNIndex vlsnIndex;
    private VLSN lastSyncableVLSN;
    private VLSN currentLocalCBVLSN;
    private long currentFile;
    private boolean allowUpdate = true;
    private final RepImpl repImpl;
    private volatile int freezeCounter = 0;

    LocalCBVLSNTracker(RepNode repNode) {
        this.repImpl = repNode.getRepImpl();
        this.vlsnIndex = this.repImpl.getVLSNIndex();
        this.lastSyncableVLSN = this.currentLocalCBVLSN = this.vlsnIndex.getRange().getLastSync();
        this.currentFile = DbLsn.getFileNumber(-1L);
    }

    public void setAllowUpdate(boolean allowUpdate) {
        this.allowUpdate = allowUpdate;
    }

    public synchronized void incrementFreezeCounter() {
        ++this.freezeCounter;
    }

    public synchronized void decrementFreezeCounter() {
        assert (this.freezeCounter > 0);
        --this.freezeCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void track(VLSN newVLSN, long lsn) {
        if (!this.allowUpdate) {
            return;
        }
        if (this.repImpl.isMaster() && this.freezeCounter > 0) {
            return;
        }
        LocalCBVLSNTracker localCBVLSNTracker = this;
        synchronized (localCBVLSNTracker) {
            if (newVLSN.compareTo(this.lastSyncableVLSN) > 0) {
                VLSN old = this.lastSyncableVLSN;
                this.lastSyncableVLSN = newVLSN;
                if (DbLsn.getFileNumber(lsn) != this.currentFile) {
                    this.currentFile = DbLsn.getFileNumber(lsn);
                    this.currentLocalCBVLSN = old;
                }
            }
        }
    }

    public void registerMatchpoint(VLSN matchpoint) {
        this.currentLocalCBVLSN = matchpoint;
        this.lastSyncableVLSN = matchpoint;
    }

    public VLSN getBroadcastCBVLSN() {
        return this.currentLocalCBVLSN;
    }
}

