/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DupKeyData;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.entry.BaseReplicableEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.VersionedLN;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.VLSN;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LNLogEntry<T extends LN>
extends BaseReplicableEntry<T> {
    private static final byte ABORT_KNOWN_DELETED_MASK = 1;
    public static final int MIN_LOG_SIZE = 16;
    public static final int LAST_FORMAT_CHANGE = 8;
    private LN ln;
    private DatabaseId dbId;
    private byte[] key;
    private long abortLsn = -1L;
    private boolean abortKnownDeleted;
    private Txn txn;
    private DupStatus dupStatus;
    private final Constructor<VersionedLN> versionedLNConstructor;

    public static <T extends LN> LNLogEntry<T> create(Class<T> cls) {
        return new LNLogEntry<T>(cls);
    }

    LNLogEntry(Class<T> cls) {
        super(cls);
        this.versionedLNConstructor = cls == LN.class ? LNLogEntry.getNoArgsConstructor(VersionedLN.class) : null;
    }

    public LNLogEntry(LogEntryType entryType, T ln, DatabaseId dbId, byte[] key, long abortLsn, boolean abortKnownDeleted, Txn txn) {
        this.setLogType(entryType);
        this.ln = ln;
        this.dbId = dbId;
        this.key = key;
        this.abortLsn = abortLsn;
        this.abortKnownDeleted = abortKnownDeleted;
        this.txn = txn;
        this.versionedLNConstructor = null;
        assert (entryType.isTransactional() == (txn != null));
    }

    @Override
    public void readEntry(EnvironmentImpl envImpl, LogEntryHeader header, ByteBuffer entryBuffer) {
        assert (this.getClass() == LNLogEntry.class);
        boolean keyIsLastSerializedField = header.getVersion() >= 8 || this.entryType.isUserLNType();
        this.readBaseLNEntry(envImpl, header, entryBuffer, keyIsLastSerializedField);
    }

    final void readBaseLNEntry(EnvironmentImpl envImpl, LogEntryHeader header, ByteBuffer entryBuffer, boolean keyIsLastSerializedField) {
        int logVersion = header.getVersion();
        boolean unpacked = logVersion < 6;
        int recStartPosition = entryBuffer.position();
        if (unpacked) {
            this.ln = this.newLNInstance(envImpl);
            this.ln.readFromLog(entryBuffer, logVersion);
        }
        this.dbId = new DatabaseId();
        this.dbId.readFromLog(entryBuffer, logVersion);
        if (unpacked) {
            this.key = LogUtils.readByteArray(entryBuffer, true);
        }
        if (this.entryType.isTransactional()) {
            this.abortLsn = LogUtils.readLong(entryBuffer, unpacked);
            if (DbLsn.getFileNumber(this.abortLsn) == DbLsn.getFileNumber(-1L)) {
                this.abortLsn = -1L;
            }
            this.abortKnownDeleted = (entryBuffer.get() & 1) != 0;
            this.txn = new Txn();
            this.txn.readFromLog(entryBuffer, logVersion);
        }
        if (!unpacked) {
            int keySize;
            this.ln = this.newLNInstance(envImpl);
            this.ln.readFromLog(entryBuffer, logVersion);
            if (keyIsLastSerializedField) {
                int bytesWritten = entryBuffer.position() - recStartPosition;
                keySize = header.getItemSize() - bytesWritten;
            } else {
                keySize = LogUtils.readPackedInt(entryBuffer);
            }
            this.key = LogUtils.readBytesNoLength(entryBuffer, keySize);
        }
        this.setLNTransientFields(header, this.ln);
        this.dupStatus = logVersion < 8 ? DupStatus.NEED_CONVERSION : DupStatus.UNKNOWN;
    }

    LN newLNInstance(EnvironmentImpl envImpl) {
        if (this.versionedLNConstructor != null && envImpl.getPreserveVLSN()) {
            return LNLogEntry.newInstanceOfType(this.versionedLNConstructor);
        }
        return (LN)this.newInstanceOfType();
    }

    @Override
    public StringBuilder dumpEntry(StringBuilder sb, boolean verbose) {
        this.ln.dumpLog(sb, verbose);
        this.dbId.dumpLog(sb, verbose);
        this.ln.dumpKey(sb, this.key);
        if (this.entryType.isTransactional()) {
            if (this.abortLsn != -1L) {
                sb.append(DbLsn.toString(this.abortLsn));
            }
            sb.append("<knownDeleted val=\"");
            sb.append(this.abortKnownDeleted ? "true" : "false");
            sb.append("\"/>");
            this.txn.dumpLog(sb, verbose);
        }
        return sb;
    }

    @Override
    public void dumpRep(StringBuilder sb) {
        if (this.entryType.isTransactional()) {
            sb.append(" txn=").append(this.txn.getId());
        }
    }

    @Override
    public LN getMainItem() {
        return this.ln;
    }

    @Override
    public long getTransactionId() {
        if (this.entryType.isTransactional()) {
            return this.txn.getId();
        }
        return 0L;
    }

    @Override
    public int getLastFormatChange() {
        return 8;
    }

    @Override
    public int getSize() {
        assert (this.getClass() == LNLogEntry.class);
        return this.getBaseLNEntrySize(true);
    }

    final int getBaseLNEntrySize(boolean keyIsLastSerializedField) {
        int len = this.key.length;
        int size = this.ln.getLogSize() + this.dbId.getLogSize() + len;
        if (!keyIsLastSerializedField) {
            size += LogUtils.getPackedIntLogSize(len);
        }
        if (this.entryType.isTransactional()) {
            size += LogUtils.getPackedLongLogSize(this.abortLsn);
            ++size;
            size += this.txn.getLogSize();
        }
        return size;
    }

    @Override
    public int getLastLoggedSize() {
        return this.ln.getLastLoggedSize();
    }

    @Override
    public void writeEntry(ByteBuffer destBuffer, int logVersion) {
        assert (this.getClass() == LNLogEntry.class);
        this.writeBaseLNEntry(destBuffer, true, logVersion);
    }

    final void writeBaseLNEntry(ByteBuffer destBuffer, boolean keyIsLastSerializedField, int logVersion) {
        LNLogEntry.checkCurrentVersion(this, logVersion);
        assert (this.ln.getLastFormatChange() <= 8 && this.dbId.getLastFormatChange() <= 8) : "Format of loggable newer than format of entry";
        this.dbId.writeToLog(destBuffer, logVersion);
        if (this.entryType.isTransactional()) {
            LogUtils.writePackedLong(destBuffer, this.abortLsn);
            byte aKD = 0;
            if (this.abortKnownDeleted) {
                aKD = (byte)(aKD | 1);
            }
            destBuffer.put(aKD);
            assert (this.txn.getLastFormatChange() <= 8) : "Format of loggable newer than format of entry";
            this.txn.writeToLog(destBuffer, logVersion);
        }
        this.ln.writeToLog(destBuffer, logVersion);
        if (!keyIsLastSerializedField) {
            LogUtils.writePackedInt(destBuffer, this.key.length);
        }
        LogUtils.writeBytesNoLength(destBuffer, this.key);
    }

    private void setLNTransientFields(LogEntryHeader header, LN ln) {
        ln.setLastLoggedSize(header.getSize() + header.getItemSize());
        VLSN vlsn = header.getVLSN();
        if (vlsn != null) {
            ln.setVLSNSequence(vlsn.getSequence());
        }
    }

    @Override
    public boolean isDeleted() {
        return this.ln.isDeleted();
    }

    @Override
    public void postLogWork(LogEntryHeader header, long justLoggedLsn) {
        if (this.entryType.isTransactional()) {
            this.txn.addLogInfo(justLoggedLsn);
        }
        this.setLNTransientFields(header, this.ln);
    }

    @Override
    public void postFetchInit(DatabaseImpl dbImpl) {
        this.postFetchInit(dbImpl.getSortedDuplicates());
    }

    public void postFetchInit(boolean isDupDb) {
        boolean needConversion = this.dupStatus == DupStatus.NEED_CONVERSION;
        DupStatus dupStatus = this.dupStatus = isDupDb ? DupStatus.DUP_DB : DupStatus.NOT_DUP_DB;
        if (!needConversion) {
            return;
        }
        if (this.dupStatus == DupStatus.NOT_DUP_DB) {
            return;
        }
        this.key = this.combineDupKeyData();
    }

    byte[] combineDupKeyData() {
        assert (!this.ln.isDeleted());
        return DupKeyData.combine(this.key, this.ln.setEmpty());
    }

    public void getUserKeyData(DatabaseEntry keyParam, DatabaseEntry dataParam) {
        this.requireKnownDupStatus();
        if (this.dupStatus == DupStatus.DUP_DB) {
            DupKeyData.split(new DatabaseEntry(this.key), keyParam, dataParam);
        } else {
            if (keyParam != null) {
                keyParam.setData(this.key);
            }
            if (dataParam != null) {
                dataParam.setData(this.ln.getData());
            }
        }
    }

    public LN getLN() {
        this.requireKnownDupStatus();
        return this.ln;
    }

    public byte[] getKey() {
        this.requireKnownDupStatus();
        return this.key;
    }

    private void requireKnownDupStatus() {
        if (this.dupStatus != DupStatus.DUP_DB && this.dupStatus != DupStatus.NOT_DUP_DB) {
            throw EnvironmentFailureException.unexpectedState("postFetchInit was not called");
        }
    }

    public int getUnconvertedDataLength() {
        return this.ln.getData().length;
    }

    public int getUnconvertedKeyLength() {
        return this.key.length;
    }

    @Override
    public DatabaseId getDbId() {
        return this.dbId;
    }

    public long getAbortLsn() {
        return this.abortLsn;
    }

    public boolean getAbortKnownDeleted() {
        return this.abortKnownDeleted;
    }

    public Long getTxnId() {
        if (this.entryType.isTransactional()) {
            return this.txn.getId();
        }
        return null;
    }

    public Txn getUserTxn() {
        if (this.entryType.isTransactional()) {
            return this.txn;
        }
        return null;
    }

    @Override
    public boolean logicalEquals(LogEntry other) {
        if (!(other instanceof LNLogEntry)) {
            return false;
        }
        LNLogEntry otherEntry = (LNLogEntry)other;
        if (!this.dbId.logicalEquals(otherEntry.dbId)) {
            return false;
        }
        if (this.txn != null ? !this.txn.logicalEquals(otherEntry.txn) : otherEntry.txn != null) {
            return false;
        }
        if (!Arrays.equals(this.key, otherEntry.key)) {
            return false;
        }
        return this.ln.logicalEquals(otherEntry.ln);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DupStatus {
        UNKNOWN,
        NEED_CONVERSION,
        DUP_DB,
        NOT_DUP_DB;

    }
}

