/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.DupKeyData;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryHeader;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeletedDupLNLogEntry
extends LNLogEntry<LN> {
    private byte[] dataAsKey;

    public DeletedDupLNLogEntry() {
        super(LN.class);
    }

    @Override
    byte[] combineDupKeyData() {
        return DupKeyData.combine(this.getKey(), this.dataAsKey);
    }

    @Override
    public void readEntry(EnvironmentImpl envImpl, LogEntryHeader header, ByteBuffer entryBuffer) {
        this.readBaseLNEntry(envImpl, header, entryBuffer, false);
        int logVersion = header.getVersion();
        this.dataAsKey = LogUtils.readByteArray(entryBuffer, logVersion < 6);
    }

    @Override
    public StringBuilder dumpEntry(StringBuilder sb, boolean verbose) {
        super.dumpEntry(sb, verbose);
        sb.append(Key.dumpString(this.dataAsKey, 0));
        return sb;
    }

    @Override
    public int getSize() {
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    public void writeEntry(ByteBuffer destBuffer) {
        throw EnvironmentFailureException.unexpectedState();
    }

    @Override
    public void writeEntry(ByteBuffer destBuffer, int logVersion) {
        throw EnvironmentFailureException.unexpectedState();
    }
}

