/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LogBuffer;
import com.sleepycat.je.log.LogStatDefinition;
import com.sleepycat.je.utilint.AtomicLongStat;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.IntStat;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;

class LogBufferPool {
    private static final String DEBUG_NAME = LogBufferPool.class.getName();
    private EnvironmentImpl envImpl = null;
    private int logBufferSize;
    private LinkedList<LogBuffer> bufferPool;
    private LogBuffer currentWriteBuffer;
    private final FileManager fileManager;
    private final StatGroup stats;
    private final AtomicLongStat nNotResident;
    private final AtomicLongStat nCacheMiss;
    private final IntStat logBuffers;
    private final LongStat nBufferBytes;
    private final boolean runInMemory;
    private final Latch bufferPoolLatch;
    private volatile long minBufferLsn = 0L;

    LogBufferPool(FileManager fileManager, EnvironmentImpl envImpl) throws DatabaseException {
        this.fileManager = fileManager;
        this.envImpl = envImpl;
        this.bufferPoolLatch = new Latch(DEBUG_NAME + "_FullLatch");
        DbConfigManager configManager = envImpl.getConfigManager();
        this.runInMemory = envImpl.isMemOnly();
        this.reset(configManager);
        this.currentWriteBuffer = this.bufferPool.getFirst();
        this.stats = new StatGroup("LogBufferPool", "LogBufferPool statistics");
        this.nNotResident = new AtomicLongStat(this.stats, LogStatDefinition.LBFP_NOT_RESIDENT);
        this.nCacheMiss = new AtomicLongStat(this.stats, LogStatDefinition.LBFP_MISS);
        this.logBuffers = new IntStat(this.stats, LogStatDefinition.LBFP_LOG_BUFFERS);
        this.nBufferBytes = new LongStat(this.stats, LogStatDefinition.LBFP_BUFFER_BYTES);
    }

    final int getLogBufferSize() {
        return this.logBufferSize;
    }

    void reset(DbConfigManager configManager) throws DatabaseException {
        if (this.runInMemory && this.bufferPool != null) {
            return;
        }
        int numBuffers = configManager.getInt(EnvironmentParams.NUM_LOG_BUFFERS);
        long logBufferBudget = this.envImpl.getMemoryBudget().getLogBufferBudget();
        long logFileSize = configManager.getLong(EnvironmentParams.LOG_FILE_MAX);
        int newBufferSize = (int)logBufferBudget / numBuffers;
        newBufferSize = Math.min(newBufferSize, (int)logFileSize);
        LinkedList<LogBuffer> newPool = new LinkedList<LogBuffer>();
        if (this.runInMemory) {
            numBuffers = 1;
        }
        for (int i = 0; i < numBuffers; ++i) {
            newPool.add(new LogBuffer(newBufferSize, this.envImpl));
        }
        this.bufferPoolLatch.acquire();
        this.bufferPool = newPool;
        this.logBufferSize = newBufferSize;
        this.bufferPoolLatch.release();
    }

    LogBuffer getWriteBuffer(int sizeNeeded, boolean flippedFile) throws IOException, DatabaseException {
        if (!this.currentWriteBuffer.hasRoom(sizeNeeded) || flippedFile) {
            this.writeBufferToFile(sizeNeeded, false);
        }
        if (flippedFile && !this.runInMemory) {
            this.fileManager.syncLogEndAndFinishFile();
        }
        return this.currentWriteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeBufferToFile(int sizeNeeded, boolean flushRequired) {
        int bufferSize = this.logBufferSize > sizeNeeded ? this.logBufferSize : sizeNeeded;
        this.currentWriteBuffer.latchForWrite();
        LogBuffer latchedBuffer = this.currentWriteBuffer;
        try {
            ByteBuffer currentByteBuffer = latchedBuffer.getDataBuffer();
            int savePosition = currentByteBuffer.position();
            int saveLimit = currentByteBuffer.limit();
            currentByteBuffer.flip();
            if (this.runInMemory) {
                latchedBuffer.release();
                latchedBuffer = null;
                this.bufferPoolLatch.acquire();
                this.currentWriteBuffer = new LogBuffer(bufferSize, this.envImpl);
                this.bufferPool.add(this.currentWriteBuffer);
                this.bufferPoolLatch.release();
            } else {
                try {
                    this.fileManager.writeLogBuffer(latchedBuffer, sizeNeeded == 0 && flushRequired);
                    latchedBuffer.getDataBuffer().rewind();
                    latchedBuffer.release();
                    latchedBuffer = null;
                    LogBuffer nextToUse = null;
                    try {
                        this.bufferPoolLatch.acquire();
                        Iterator iter = this.bufferPool.iterator();
                        nextToUse = (LogBuffer)iter.next();
                        assert (iter.hasNext());
                        LogBuffer newInitialBuffer = (LogBuffer)iter.next();
                        boolean done = this.bufferPool.remove(nextToUse);
                        assert (done);
                        nextToUse.reinit();
                        this.bufferPool.add(nextToUse);
                        this.currentWriteBuffer = nextToUse;
                        this.updateMinBufferLsn(newInitialBuffer);
                        Object var13_13 = null;
                        this.bufferPoolLatch.releaseIfOwner();
                    }
                    catch (Throwable throwable) {
                        Object var13_14 = null;
                        this.bufferPoolLatch.releaseIfOwner();
                        throw throwable;
                    }
                }
                catch (Throwable t) {
                    currentByteBuffer.position(savePosition);
                    currentByteBuffer.limit(saveLimit);
                    if (FileManager.continueAfterWriteException() && t instanceof RuntimeException) {
                        throw (RuntimeException)t;
                    }
                    if (t instanceof EnvironmentFailureException) {
                        if (!this.envImpl.isValid()) {
                            throw (EnvironmentFailureException)t;
                        }
                        throw EnvironmentFailureException.unexpectedException(this.envImpl, (Exception)((EnvironmentFailureException)t));
                    }
                    if (t instanceof Error) {
                        this.envImpl.invalidate((Error)t);
                        throw (Error)t;
                    }
                    if (t instanceof Exception) {
                        throw EnvironmentFailureException.unexpectedException(this.envImpl, (Exception)t);
                    }
                    throw EnvironmentFailureException.unexpectedException(this.envImpl, t.getMessage(), null);
                }
            }
            Object var15_16 = null;
            if (latchedBuffer != null) {
                latchedBuffer.release();
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            if (latchedBuffer != null) {
                latchedBuffer.release();
            }
            throw throwable;
        }
    }

    private void updateMinBufferLsn(LogBuffer newInitialBuffer) {
        long newMinLsn = newInitialBuffer.getFirstLsn();
        if (newMinLsn != -1L) {
            this.minBufferLsn = newMinLsn;
        }
    }

    void writeCompleted(long lsn, boolean flushRequired, boolean fsyncRequired) throws DatabaseException {
        this.currentWriteBuffer.registerLsn(lsn);
        if (flushRequired) {
            this.writeBufferToFile(0, flushRequired && !fsyncRequired);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    LogBuffer getReadBufferByLsn(long lsn) throws DatabaseException {
        LogBuffer logBuffer;
        block6: {
            block5: {
                this.nNotResident.increment();
                if (DbLsn.compareTo(lsn, this.minBufferLsn) < 0) {
                    this.nCacheMiss.increment();
                    return null;
                }
                this.bufferPoolLatch.acquire();
                try {
                    for (LogBuffer l : this.bufferPool) {
                        if (!l.containsLsn(lsn)) continue;
                        LogBuffer logBuffer2 = l;
                        Object var7_5 = null;
                        this.bufferPoolLatch.releaseIfOwner();
                        return logBuffer2;
                    }
                    if (this.currentWriteBuffer.containsLsn(lsn)) {
                        logBuffer = this.currentWriteBuffer;
                        break block5;
                    }
                    this.nCacheMiss.increment();
                    logBuffer = null;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    this.bufferPoolLatch.releaseIfOwner();
                    throw throwable;
                }
            }
            Object var7_6 = null;
            this.bufferPoolLatch.releaseIfOwner();
            return logBuffer;
        }
        Object var7_7 = null;
        this.bufferPoolLatch.releaseIfOwner();
        return logBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatGroup loadStats(StatsConfig config) throws DatabaseException {
        this.bufferPoolLatch.acquire();
        long bufferBytes = 0L;
        int nLogBuffers = 0;
        try {
            for (LogBuffer l : this.bufferPool) {
                ++nLogBuffers;
                bufferBytes += (long)l.getCapacity();
            }
            Object var8_6 = null;
            this.bufferPoolLatch.release();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.bufferPoolLatch.release();
            throw throwable;
        }
        this.logBuffers.set(nLogBuffers);
        this.nBufferBytes.set(bufferBytes);
        return this.stats.cloneGroup(config.getClear());
    }

    public long getNCacheMiss() {
        return this.nCacheMiss.get();
    }

    public StatGroup getBufferPoolLatchStats() {
        return this.bufferPoolLatch.getLatchStats();
    }
}

