/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.cleaner.PackedOffsets;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.DbType;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.dbi.StartupTracker;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.FileSummaryLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UtilizationProfile {
    private final EnvironmentImpl env;
    private final UtilizationTracker tracker;
    private DatabaseImpl fileSummaryDb;
    private SortedMap<Long, FileSummary> fileSummaryMap;
    private boolean cachePopulated;
    private final Logger logger;

    public UtilizationProfile(EnvironmentImpl env, UtilizationTracker tracker) {
        this.env = env;
        this.tracker = tracker;
        this.fileSummaryMap = new TreeMap<Long, FileSummary>();
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    synchronized int getNumberOfFiles() {
        return this.fileSummaryMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getTotalLogSize() {
        long size = 0L;
        UtilizationProfile utilizationProfile = this;
        synchronized (utilizationProfile) {
            for (FileSummary summary : this.fileSummaryMap.values()) {
                size += (long)summary.totalSize;
            }
        }
        for (TrackedFileSummary summary : this.tracker.getTrackedFiles()) {
            size += (long)summary.totalSize;
        }
        return size;
    }

    private synchronized FileSummary getFileSummary(Long file) {
        FileSummary summary = (FileSummary)this.fileSummaryMap.get(file);
        TrackedFileSummary trackedSummary = this.tracker.getTrackedFile(file);
        if (trackedSummary != null) {
            FileSummary totals = new FileSummary();
            totals.add(summary);
            totals.add(trackedSummary);
            summary = totals;
        }
        return summary;
    }

    public void flushLocalTracker(LocalUtilizationTracker localTracker) throws DatabaseException {
        this.env.getLogManager().transferToUtilizationTracker(localTracker);
        this.flushFileUtilization(localTracker.getTrackedFiles());
        this.flushDbUtilization(localTracker);
    }

    public void flushFileUtilization(Collection<TrackedFileSummary> activeFiles) throws DatabaseException {
        if (!DbInternal.getCheckpointUP(this.env.getConfigManager().getEnvironmentConfig())) {
            return;
        }
        for (TrackedFileSummary activeFile : activeFiles) {
            long fileNum = activeFile.getFileNumber();
            TrackedFileSummary tfs = this.tracker.getTrackedFile(fileNum);
            if (tfs == null) continue;
            this.flushFileSummary(tfs);
        }
    }

    private void flushDbUtilization(LocalUtilizationTracker localTracker) throws DatabaseException {
        if (!DbInternal.getCheckpointUP(this.env.getConfigManager().getEnvironmentConfig())) {
            return;
        }
        for (DatabaseImpl databaseImpl : localTracker.getTrackedDbs()) {
            if (databaseImpl.isDeleted() || !databaseImpl.isDirtyUtilization()) continue;
            this.env.getDbTree().modifyDbRoot(databaseImpl);
        }
    }

    public synchronized SortedMap<Long, FileSummary> getFileSummaryMap(boolean includeTrackedFiles) {
        assert (this.cachePopulated);
        if (includeTrackedFiles) {
            TreeMap<Long, FileSummary> map = new TreeMap<Long, FileSummary>();
            for (Long file : this.fileSummaryMap.keySet()) {
                FileSummary summary = this.getFileSummary(file);
                map.put(file, summary);
            }
            for (TrackedFileSummary summary : this.tracker.getTrackedFiles()) {
                Long fileNum = summary.getFileNumber();
                if (map.containsKey(fileNum)) continue;
                map.put(fileNum, summary);
            }
            return map;
        }
        return new TreeMap<Long, FileSummary>(this.fileSummaryMap);
    }

    private synchronized void clearCache() {
        int memorySize = this.fileSummaryMap.size() * MemoryBudget.UTILIZATION_PROFILE_ENTRY;
        MemoryBudget mb = this.env.getMemoryBudget();
        mb.updateAdminMemoryUsage(0 - memorySize);
        this.fileSummaryMap = new TreeMap<Long, FileSummary>();
        this.cachePopulated = false;
    }

    void removeFile(Long fileNum, Set<DatabaseId> databases) throws DatabaseException {
        this.removePerDbMetadata(Collections.singleton(fileNum), databases);
        this.removePerFileMetadata(fileNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePerFileMetadata(Long fileNum) throws DatabaseException {
        UtilizationProfile utilizationProfile = this;
        synchronized (utilizationProfile) {
            assert (this.cachePopulated);
            FileSummary oldSummary = (FileSummary)this.fileSummaryMap.remove(fileNum);
            if (oldSummary != null) {
                MemoryBudget mb = this.env.getMemoryBudget();
                mb.updateAdminMemoryUsage(0 - MemoryBudget.UTILIZATION_PROFILE_ENTRY);
            }
        }
        this.deleteFileSummary(fileNum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePerDbMetadata(final Collection<Long> fileNums, Set<DatabaseId> databases) throws DatabaseException {
        final LogManager logManager = this.env.getLogManager();
        final DbTree dbTree = this.env.getDbTree();
        DatabaseImpl idDatabase = dbTree.getDb(DbTree.ID_DB_ID);
        DatabaseImpl nameDatabase = dbTree.getDb(DbTree.NAME_DB_ID);
        boolean logRoot = false;
        if (logManager.removeDbFileSummaries(idDatabase, fileNums)) {
            logRoot = true;
        }
        if (logManager.removeDbFileSummaries(nameDatabase, fileNums)) {
            logRoot = true;
        }
        if (logRoot) {
            this.env.logMapTreeRoot();
        }
        if (databases != null) {
            for (DatabaseId dbId : databases) {
                Object var12_11;
                if (dbId.equals(DbTree.ID_DB_ID) || dbId.equals(DbTree.NAME_DB_ID)) continue;
                DatabaseImpl db = dbTree.getDb(dbId);
                try {
                    if (db != null && logManager.removeDbFileSummaries(db, fileNums)) {
                        dbTree.modifyDbRoot(db);
                    }
                    var12_11 = null;
                    dbTree.releaseDb(db);
                }
                catch (Throwable throwable) {
                    var12_11 = null;
                    dbTree.releaseDb(db);
                    throw throwable;
                }
            }
        } else {
            CursorImpl.traverseDbWithCursor(idDatabase, LockType.NONE, true, new CursorImpl.WithCursor(){

                public boolean withCursor(CursorImpl cursor, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
                    DatabaseImpl db;
                    MapLN mapLN = (MapLN)cursor.getCurrentLN(LockType.NONE);
                    if (mapLN != null && logManager.removeDbFileSummaries(db = mapLN.getDatabase(), fileNums)) {
                        dbTree.modifyDbRoot(db, -1L, false);
                    }
                    return true;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFileSummary(Long fileNum) throws DatabaseException {
        BasicLocker locker;
        block7: {
            locker = null;
            CursorImpl cursor = null;
            try {
                locker = BasicLocker.createBasicLocker(this.env, false);
                cursor = new CursorImpl(this.fileSummaryDb, locker);
                cursor.setAllowEviction(true);
                DatabaseEntry keyEntry = new DatabaseEntry();
                DatabaseEntry dataEntry = new DatabaseEntry();
                long fileNumVal = fileNum;
                dataEntry.setPartial(0, 0, true);
                OperationStatus status = OperationStatus.SUCCESS;
                status = this.getFirstFSLN(cursor, fileNumVal, keyEntry, dataEntry, LockType.WRITE) ? OperationStatus.SUCCESS : OperationStatus.NOTFOUND;
                while (status == OperationStatus.SUCCESS && fileNumVal == FileSummaryLN.getFileNumber(keyEntry.getData())) {
                    this.env.daemonEviction(true);
                    cursor.delete(ReplicationContext.NO_REPLICATE);
                    status = cursor.getNext(keyEntry, dataEntry, LockType.WRITE, true, false, null);
                }
                Object var10_8 = null;
                if (cursor == null) break block7;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                if (cursor != null) {
                    cursor.close();
                }
                if (locker != null) {
                    locker.operationEnd();
                }
                throw throwable;
            }
            cursor.close();
        }
        if (locker != null) {
            locker.operationEnd();
        }
        TrackedFileSummary tfs = this.tracker.getTrackedFile(fileNum);
        if (tfs != null) {
            this.env.getLogManager().removeTrackedFile(tfs);
        }
    }

    public void flushFileSummary(TrackedFileSummary tfs) throws DatabaseException {
        if (tfs.getAllowFlush()) {
            this.putFileSummary(tfs);
        }
    }

    private synchronized PackedOffsets putFileSummary(TrackedFileSummary tfs) throws DatabaseException {
        if (this.env.isReadOnly()) {
            throw EnvironmentFailureException.unexpectedState("Cannot write file summary in a read-only environment");
        }
        if (tfs.isEmpty()) {
            return null;
        }
        if (!this.cachePopulated) {
            return null;
        }
        long fileNum = tfs.getFileNumber();
        Long fileNumLong = fileNum;
        FileSummary summary = (FileSummary)this.fileSummaryMap.get(fileNumLong);
        if (summary == null) {
            if (!this.fileSummaryMap.isEmpty() && fileNum < this.fileSummaryMap.lastKey() && !this.env.getFileManager().isFileValid(fileNum)) {
                this.env.getLogManager().removeTrackedFile(tfs);
                return null;
            }
            summary = new FileSummary();
        }
        FileSummary tmp = new FileSummary();
        tmp.add(summary);
        tmp.add(tfs);
        int sequence = tmp.getEntriesCounted();
        FileSummaryLN ln = new FileSummaryLN(summary);
        ln.setTrackedSummary(tfs);
        this.insertFileSummary(ln, fileNum, sequence);
        summary = ln.getBaseSummary();
        if (this.fileSummaryMap.put(fileNumLong, summary) == null) {
            MemoryBudget mb = this.env.getMemoryBudget();
            mb.updateAdminMemoryUsage(MemoryBudget.UTILIZATION_PROFILE_ENTRY);
        }
        return ln.getObsoleteOffsets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PackedOffsets getObsoleteDetail(Long fileNum, boolean logUpdate) throws DatabaseException {
        PackedOffsets packedOffsets = new PackedOffsets();
        if (!this.env.getCleaner().trackDetail) {
            return packedOffsets;
        }
        assert (this.cachePopulated);
        long fileNumVal = fileNum;
        ArrayList<long[]> list = new ArrayList<long[]>();
        TrackedFileSummary tfs = this.env.getLogManager().getUnflushableTrackedSummary(fileNumVal);
        try {
            BasicLocker locker = BasicLocker.createBasicLocker(this.env, false);
            CursorImpl cursor = new CursorImpl(this.fileSummaryDb, locker);
            try {
                cursor.setAllowEviction(true);
                DatabaseEntry keyEntry = new DatabaseEntry();
                DatabaseEntry dataEntry = new DatabaseEntry();
                OperationStatus status = OperationStatus.SUCCESS;
                if (!this.getFirstFSLN(cursor, fileNumVal, keyEntry, dataEntry, LockType.NONE)) {
                    status = OperationStatus.NOTFOUND;
                }
                while (status == OperationStatus.SUCCESS) {
                    this.env.daemonEviction(true);
                    FileSummaryLN ln = (FileSummaryLN)cursor.getCurrentLN(LockType.NONE);
                    if (ln != null) {
                        if (fileNumVal != FileSummaryLN.getFileNumber(keyEntry.getData())) break;
                        PackedOffsets offsets = ln.getObsoleteOffsets();
                        if (offsets != null) {
                            list.add(offsets.toArray());
                        }
                        cursor.evict();
                    }
                    status = cursor.getNext(keyEntry, dataEntry, LockType.NONE, true, false, null);
                }
                Object var16_19 = null;
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                cursor.close();
                locker.operationEnd();
                throw throwable;
            }
            cursor.close();
            locker.operationEnd();
            if (!tfs.isEmpty()) {
                if (logUpdate) {
                    PackedOffsets offsets = this.putFileSummary(tfs);
                    if (offsets != null) {
                        list.add(offsets.toArray());
                    }
                } else {
                    long[] offsetList = tfs.getObsoleteOffsets();
                    if (offsetList != null) {
                        list.add(offsetList);
                    }
                }
            }
            Object var18_22 = null;
            tfs.setAllowFlush(true);
        }
        catch (Throwable throwable) {
            Object var18_23 = null;
            tfs.setAllowFlush(true);
            throw throwable;
        }
        int size = 0;
        for (int i = 0; i < list.size(); ++i) {
            long[] a = (long[])list.get(i);
            size += a.length;
        }
        long[] offsets = new long[size];
        int index = 0;
        for (int i = 0; i < list.size(); ++i) {
            long[] a = (long[])list.get(i);
            System.arraycopy(a, 0, offsets, index, a.length);
            index += a.length;
        }
        assert (index == offsets.length);
        packedOffsets.pack(offsets);
        return packedOffsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean populateCache(StartupTracker.Counter counter) throws DatabaseException {
        BasicLocker locker;
        int oldMemorySize;
        block19: {
            assert (!this.cachePopulated);
            if (!this.openFileSummaryDatabase()) {
                return false;
            }
            oldMemorySize = this.fileSummaryMap.size() * MemoryBudget.UTILIZATION_PROFILE_ENTRY;
            Object[] existingFiles = this.env.getFileManager().getAllFileNumbers();
            locker = null;
            CursorImpl cursor = null;
            try {
                locker = BasicLocker.createBasicLocker(this.env, false);
                cursor = new CursorImpl(this.fileSummaryDb, locker);
                cursor.setAllowEviction(true);
                DatabaseEntry keyEntry = new DatabaseEntry();
                DatabaseEntry dataEntry = new DatabaseEntry();
                if (cursor.positionFirstOrLast(true)) {
                    OperationStatus status = cursor.getCurrentAlreadyLatched(keyEntry, dataEntry, LockType.NONE);
                    if (status != OperationStatus.SUCCESS) {
                        status = cursor.getNext(keyEntry, dataEntry, LockType.NONE, true, false, null);
                    }
                    while (status == OperationStatus.SUCCESS) {
                        counter.incNumRead();
                        this.env.daemonEviction(false);
                        FileSummaryLN ln = (FileSummaryLN)cursor.getCurrentLN(LockType.NONE);
                        if (ln == null) {
                            status = cursor.getNext(keyEntry, dataEntry, LockType.NONE, true, false, null);
                            continue;
                        }
                        byte[] keyBytes = keyEntry.getData();
                        boolean isOldVersion = FileSummaryLN.hasStringKey(keyBytes);
                        long fileNum = FileSummaryLN.getFileNumber(keyBytes);
                        Long fileNumLong = fileNum;
                        if (Arrays.binarySearch(existingFiles, fileNumLong) >= 0) {
                            counter.incNumProcessed();
                            FileSummary summary = ln.getBaseSummary();
                            this.fileSummaryMap.put(fileNumLong, summary);
                            if (isOldVersion && !this.env.isReadOnly()) {
                                this.insertFileSummary(ln, fileNum, 0);
                                cursor.delete(ReplicationContext.NO_REPLICATE);
                            } else {
                                cursor.evict();
                            }
                        } else {
                            counter.incNumDeleted();
                            this.fileSummaryMap.remove(fileNumLong);
                            if (!this.env.isReadOnly()) {
                                this.removePerDbMetadata(Collections.singleton(fileNumLong), null);
                                if (isOldVersion) {
                                    cursor.latchBIN();
                                    cursor.delete(ReplicationContext.NO_REPLICATE);
                                } else {
                                    this.deleteFileSummary(fileNumLong);
                                }
                            }
                        }
                        if (isOldVersion) {
                            status = cursor.getNext(keyEntry, dataEntry, LockType.NONE, true, false, null);
                            continue;
                        }
                        if (this.getFirstFSLN(cursor, fileNum + 1L, keyEntry, dataEntry, LockType.NONE)) continue;
                        status = OperationStatus.NOTFOUND;
                    }
                }
                Object var17_15 = null;
                if (cursor == null) break block19;
            }
            catch (Throwable throwable) {
                Object var17_16 = null;
                if (cursor != null) {
                    cursor.close();
                }
                if (locker != null) {
                    locker.operationEnd();
                }
                int newMemorySize = this.fileSummaryMap.size() * MemoryBudget.UTILIZATION_PROFILE_ENTRY;
                MemoryBudget mb = this.env.getMemoryBudget();
                mb.updateAdminMemoryUsage(newMemorySize - oldMemorySize);
                throw throwable;
            }
            cursor.close();
        }
        if (locker != null) {
            locker.operationEnd();
        }
        int newMemorySize = this.fileSummaryMap.size() * MemoryBudget.UTILIZATION_PROFILE_ENTRY;
        MemoryBudget mb = this.env.getMemoryBudget();
        mb.updateAdminMemoryUsage(newMemorySize - oldMemorySize);
        this.cachePopulated = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getFirstFSLN(CursorImpl cursor, long fileNum, DatabaseEntry keyEntry, DatabaseEntry dataEntry, LockType lockType) throws DatabaseException {
        block5: {
            boolean exactKeyMatch;
            int result;
            block4: {
                byte[] keyBytes = FileSummaryLN.makePartialKey(fileNum);
                keyEntry.setData(keyBytes);
                try {
                    result = cursor.searchAndPosition(keyEntry, CursorImpl.SearchMode.SET_RANGE, lockType);
                    if ((result & 1) != 0) break block4;
                    boolean bl = false;
                    Object var12_11 = null;
                    cursor.releaseBIN();
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    cursor.releaseBIN();
                    throw throwable;
                }
            }
            boolean bl = exactKeyMatch = (result & 2) != 0;
            if (!exactKeyMatch || cursor.getCurrentAlreadyLatched(keyEntry, dataEntry, lockType) == OperationStatus.KEYEMPTY) break block5;
            boolean bl2 = true;
            Object var12_12 = null;
            cursor.releaseBIN();
            return bl2;
        }
        Object var12_13 = null;
        cursor.releaseBIN();
        cursor.evict();
        OperationStatus status = cursor.getNext(keyEntry, dataEntry, lockType, true, false, null);
        return status == OperationStatus.SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean openFileSummaryDatabase() throws DatabaseException {
        boolean bl;
        boolean operationOk;
        Txn autoTxn;
        block6: {
            boolean bl2;
            block5: {
                if (this.fileSummaryDb != null) {
                    return true;
                }
                DbTree dbTree = this.env.getDbTree();
                autoTxn = null;
                operationOk = false;
                try {
                    autoTxn = Txn.createLocalAutoTxn(this.env, new TransactionConfig());
                    DatabaseImpl db = dbTree.getDb(autoTxn, DbType.UTILIZATION.getInternalName(), null);
                    if (db == null) {
                        if (this.env.isReadOnly()) {
                            bl2 = false;
                            Object var7_8 = null;
                            if (autoTxn == null) return bl2;
                            break block5;
                        }
                        DatabaseConfig dbConfig = new DatabaseConfig();
                        dbConfig.setReplicated(false);
                        db = dbTree.createInternalDb(autoTxn, DbType.UTILIZATION.getInternalName(), dbConfig);
                    }
                    this.fileSummaryDb = db;
                    operationOk = true;
                    bl = true;
                    break block6;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    if (autoTxn == null) throw throwable;
                    ((Locker)autoTxn).operationEnd(operationOk);
                    throw throwable;
                }
            }
            ((Locker)autoTxn).operationEnd(operationOk);
            return bl2;
        }
        Object var7_9 = null;
        if (autoTxn == null) return bl;
        ((Locker)autoTxn).operationEnd(operationOk);
        return bl;
    }

    public DatabaseImpl getFileSummaryDb() {
        return this.fileSummaryDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean insertFileSummary(FileSummaryLN ln, long fileNum, int sequence) throws DatabaseException {
        boolean bl;
        BasicLocker locker;
        block8: {
            CursorImpl cursor;
            block6: {
                boolean bl2;
                block7: {
                    byte[] keyBytes = FileSummaryLN.makeFullKey(fileNum, sequence);
                    locker = null;
                    cursor = null;
                    try {
                        locker = BasicLocker.createBasicLocker(this.env, false);
                        cursor = new CursorImpl(this.fileSummaryDb, locker);
                        OperationStatus status = cursor.putLN(keyBytes, ln, null, ReplicationContext.NO_REPLICATE);
                        if (status != OperationStatus.KEYEXIST) break block6;
                        LoggerUtils.traceAndLog(this.logger, this.env, Level.SEVERE, "Cleaner duplicate key sequence file=0x" + Long.toHexString(fileNum) + " sequence=0x" + Long.toHexString(sequence));
                        bl2 = false;
                        Object var11_10 = null;
                        if (cursor == null) break block7;
                    }
                    catch (Throwable throwable) {
                        block9: {
                            Object var11_12 = null;
                            if (cursor != null) {
                                cursor.close();
                            }
                            if (locker == null) break block9;
                            locker.operationEnd();
                        }
                        throw throwable;
                    }
                    cursor.close();
                }
                if (locker != null) {
                    locker.operationEnd();
                }
                return bl2;
            }
            cursor.evict();
            bl = true;
            Object var11_11 = null;
            if (cursor == null) break block8;
            cursor.close();
        }
        if (locker != null) {
            locker.operationEnd();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyFileSummaryDatabase() throws DatabaseException {
        boolean ok;
        BasicLocker locker;
        block9: {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            this.openFileSummaryDatabase();
            locker = null;
            CursorImpl cursor = null;
            ok = true;
            try {
                locker = BasicLocker.createBasicLocker(this.env, false);
                cursor = new CursorImpl(this.fileSummaryDb, locker);
                cursor.setAllowEviction(true);
                if (cursor.positionFirstOrLast(true)) {
                    OperationStatus status = cursor.getCurrentAlreadyLatched(key, data, LockType.NONE);
                    while (status == OperationStatus.SUCCESS) {
                        this.env.daemonEviction(true);
                        FileSummaryLN ln = (FileSummaryLN)cursor.getCurrentLN(LockType.NONE);
                        if (ln == null) continue;
                        long fileNumVal = FileSummaryLN.getFileNumber(key.getData());
                        PackedOffsets offsets = ln.getObsoleteOffsets();
                        if (offsets != null) {
                            long[] vals = offsets.toArray();
                            for (int i = 0; i < vals.length; ++i) {
                                long lsn = DbLsn.makeLsn(fileNumVal, vals[i]);
                                if (this.verifyLsnIsObsolete(lsn)) continue;
                                ok = false;
                            }
                        }
                        cursor.evict();
                        status = cursor.getNext(key, data, LockType.NONE, true, false, null);
                    }
                }
                Object var16_13 = null;
                if (cursor == null) break block9;
            }
            catch (Throwable throwable) {
                Object var16_14 = null;
                if (cursor != null) {
                    cursor.close();
                }
                if (locker != null) {
                    locker.operationEnd();
                }
                throw throwable;
            }
            cursor.close();
        }
        if (locker != null) {
            locker.operationEnd();
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyLsnIsObsolete(long lsn) throws DatabaseException {
        boolean bl;
        block16: {
            IN bin;
            DatabaseImpl db;
            block14: {
                boolean bl2;
                block15: {
                    int index;
                    block12: {
                        boolean bl3;
                        block13: {
                            block10: {
                                boolean bl4;
                                block11: {
                                    LNLogEntry entry;
                                    block8: {
                                        boolean bl5;
                                        block9: {
                                            LogEntry o = this.env.getLogManager().getLogEntryHandleFileNotFound(lsn);
                                            if (!(o instanceof LNLogEntry)) {
                                                return true;
                                            }
                                            entry = (LNLogEntry)o;
                                            if (entry.isDeleted()) {
                                                return true;
                                            }
                                            DatabaseId dbId = entry.getDbId();
                                            db = this.env.getDbTree().getDb(dbId);
                                            bin = null;
                                            try {
                                                if (db != null && !db.isDeleted()) break block8;
                                                bl5 = true;
                                                Object var14_9 = null;
                                                this.env.getDbTree().releaseDb(db);
                                                if (bin == null) break block9;
                                            }
                                            catch (Throwable throwable) {
                                                block17: {
                                                    Object var14_14 = null;
                                                    this.env.getDbTree().releaseDb(db);
                                                    if (bin == null) break block17;
                                                    bin.releaseLatch();
                                                }
                                                throw throwable;
                                            }
                                            bin.releaseLatch();
                                        }
                                        return bl5;
                                    }
                                    entry.postFetchInit(db);
                                    Tree tree = db.getTree();
                                    TreeLocation location = new TreeLocation();
                                    boolean parentFound = tree.getParentBINForChildLN(location, entry.getKey(), false, true, CacheMode.UNCHANGED);
                                    bin = location.bin;
                                    index = location.index;
                                    if (parentFound) break block10;
                                    bl4 = true;
                                    Object var14_10 = null;
                                    this.env.getDbTree().releaseDb(db);
                                    if (bin == null) break block11;
                                    bin.releaseLatch();
                                }
                                return bl4;
                            }
                            if (!bin.isEntryKnownDeleted(index)) break block12;
                            bl3 = true;
                            Object var14_11 = null;
                            this.env.getDbTree().releaseDb(db);
                            if (bin == null) break block13;
                            bin.releaseLatch();
                        }
                        return bl3;
                    }
                    if (bin.getLsn(index) == lsn) break block14;
                    bl2 = true;
                    Object var14_12 = null;
                    this.env.getDbTree().releaseDb(db);
                    if (bin == null) break block15;
                    bin.releaseLatch();
                }
                return bl2;
            }
            System.err.println("lsn " + DbLsn.getNoFormatString(lsn) + " was found in tree.");
            bl = false;
            Object var14_13 = null;
            this.env.getDbTree().releaseDb(db);
            if (bin == null) break block16;
            bin.releaseLatch();
        }
        return bl;
    }

    void close() {
        this.clearCache();
        if (this.fileSummaryDb != null) {
            this.fileSummaryDb.releaseTreeAdminMemory();
        }
    }
}

