/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.DatabaseEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteBinding
extends TupleBinding<Byte> {
    private static final int BYTE_SIZE = 1;

    @Override
    public Byte entryToObject(TupleInput input) {
        return input.readByte();
    }

    @Override
    public void objectToEntry(Byte object, TupleOutput output) {
        output.writeByte(object.byteValue());
    }

    @Override
    protected TupleOutput getTupleOutput(Byte object) {
        return ByteBinding.sizedOutput();
    }

    public static byte entryToByte(DatabaseEntry entry) {
        return ByteBinding.entryToInput(entry).readByte();
    }

    public static void byteToEntry(byte val, DatabaseEntry entry) {
        ByteBinding.outputToEntry(ByteBinding.sizedOutput().writeByte(val), entry);
    }

    private static TupleOutput sizedOutput() {
        return new TupleOutput(new byte[1]);
    }
}

