/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.serial;

import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.util.ClassResolver;
import com.sleepycat.util.RuntimeExceptionWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;

public class SerialInput
extends ClassResolver.Stream {
    private ClassCatalog classCatalog;

    public SerialInput(InputStream in, ClassCatalog classCatalog) throws IOException {
        this(in, classCatalog, null);
    }

    public SerialInput(InputStream in, ClassCatalog classCatalog, ClassLoader classLoader) throws IOException {
        super(in, classLoader);
        this.classCatalog = classCatalog;
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        try {
            byte len = this.readByte();
            byte[] id = new byte[len];
            this.readFully(id);
            return this.classCatalog.getClassFormat(id);
        }
        catch (DatabaseException e) {
            throw RuntimeExceptionWrapper.wrapIfNeeded(e);
        }
    }
}

