/*
 * Decompiled with CFR 0.152.
 */
package org.jire.netty.haproxy;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jire.netty.haproxy.HAProxyHandlerNames;
import org.jire.netty.haproxy.HAProxyParentHandler;

@ChannelHandler.Sharable
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0012B#\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jire/netty/haproxy/HAProxyPingHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lio/netty/buffer/ByteBuf;", "Lorg/jire/netty/haproxy/HAProxyParentHandler;", "childHandler", "Lio/netty/channel/ChannelInboundHandler;", "requestOpcode", "", "responseOpcode", "(Lio/netty/channel/ChannelInboundHandler;II)V", "getChildHandler", "()Lio/netty/channel/ChannelInboundHandler;", "response", "channelRead0", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "msg", "Companion", "haproxy"})
public final class HAProxyPingHandler
extends SimpleChannelInboundHandler<ByteBuf>
implements HAProxyParentHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ChannelInboundHandler childHandler;
    private final int requestOpcode;
    private final int responseOpcode;
    @NotNull
    private final ByteBuf response;
    public static final int DEFAULT_PING_REQUEST_OPCODE = 200;
    public static final int DEFAULT_PING_RESPONSE_OPCODE = 201;

    @JvmOverloads
    public HAProxyPingHandler(@NotNull ChannelInboundHandler childHandler, int requestOpcode, int responseOpcode) {
        Intrinsics.checkNotNullParameter((Object)childHandler, (String)"childHandler");
        super(true);
        this.childHandler = childHandler;
        this.requestOpcode = requestOpcode;
        this.responseOpcode = responseOpcode;
        ByteBuf byteBuf = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.directBuffer((int)1, (int)1).writeByte(this.responseOpcode));
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"unreleasableBuffer(...)");
        this.response = byteBuf;
    }

    public /* synthetic */ HAProxyPingHandler(ChannelInboundHandler channelInboundHandler, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 200;
        }
        if ((n3 & 4) != 0) {
            n2 = 201;
        }
        this(channelInboundHandler, n, n2);
    }

    @Override
    @NotNull
    public ChannelInboundHandler getChildHandler() {
        return this.childHandler;
    }

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull ByteBuf msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        int readerIndex = msg.readerIndex();
        short opcode = msg.getUnsignedByte(readerIndex);
        if (opcode == this.requestOpcode) {
            msg.readerIndex(readerIndex + 1);
            ctx.writeAndFlush((Object)this.response, ctx.voidPromise());
        } else {
            ChannelPipeline pipeline = ctx.pipeline();
            pipeline.replace((ChannelHandler)this, HAProxyHandlerNames.INSTANCE.getHAPROXY_PING_HANDLER_CHILD_NAME(), (ChannelHandler)this.getChildHandler());
            ByteBuf retainedMsg = msg.retain();
            ctx.channel().eventLoop().execute(() -> HAProxyPingHandler.channelRead0$lambda$0(ctx, retainedMsg));
        }
    }

    @JvmOverloads
    public HAProxyPingHandler(@NotNull ChannelInboundHandler childHandler, int requestOpcode) {
        Intrinsics.checkNotNullParameter((Object)childHandler, (String)"childHandler");
        this(childHandler, requestOpcode, 0, 4, null);
    }

    @JvmOverloads
    public HAProxyPingHandler(@NotNull ChannelInboundHandler childHandler) {
        Intrinsics.checkNotNullParameter((Object)childHandler, (String)"childHandler");
        this(childHandler, 0, 0, 6, null);
    }

    private static final void channelRead0$lambda$0(ChannelHandlerContext $ctx, ByteBuf $retainedMsg) {
        Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
        $ctx.fireChannelRead((Object)$retainedMsg);
        $ctx.read();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jire/netty/haproxy/HAProxyPingHandler$Companion;", "", "()V", "DEFAULT_PING_REQUEST_OPCODE", "", "DEFAULT_PING_RESPONSE_OPCODE", "haproxy"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

