/*
 * Decompiled with CFR 0.152.
 */
package org.jire.netty.haproxy;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.haproxy.HAProxyCommand;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.codec.haproxy.HAProxyProtocolVersion;
import io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import io.netty.handler.timeout.IdleStateEvent;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jire.netty.haproxy.HAProxyAttribute;
import org.jire.netty.haproxy.HAProxyAttributes;
import org.jire.netty.haproxy.HAProxyHandlerNames;
import org.jire.netty.haproxy.HAProxyParentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0014B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jire/netty/haproxy/HAProxyMessageHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lio/netty/handler/codec/haproxy/HAProxyMessage;", "Lorg/jire/netty/haproxy/HAProxyParentHandler;", "childHandler", "Lio/netty/channel/ChannelInboundHandler;", "(Lio/netty/channel/ChannelInboundHandler;)V", "getChildHandler", "()Lio/netty/channel/ChannelInboundHandler;", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelRead0", "msg", "handleLocalCommand", "handleProxyCommand", "userEventTriggered", "evt", "", "Companion", "haproxy"})
@SourceDebugExtension(value={"SMAP\nHAProxyMessageHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HAProxyMessageHandler.kt\norg/jire/netty/haproxy/HAProxyMessageHandler\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,110:1\n56#2,4:111\n32#2,4:115\n104#2,4:119\n56#2,4:123\n11#3,2:127\n*S KotlinDebug\n*F\n+ 1 HAProxyMessageHandler.kt\norg/jire/netty/haproxy/HAProxyMessageHandler\n*L\n43#1:111,4\n55#1:115,4\n61#1:119,4\n86#1:123,4\n107#1:127,2\n*E\n"})
public final class HAProxyMessageHandler
extends SimpleChannelInboundHandler<HAProxyMessage>
implements HAProxyParentHandler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ChannelInboundHandler childHandler;
    @NotNull
    private static final Logger logger;

    public HAProxyMessageHandler(@NotNull ChannelInboundHandler childHandler) {
        Intrinsics.checkNotNullParameter((Object)childHandler, (String)"childHandler");
        super(true);
        this.childHandler = childHandler;
    }

    @Override
    @NotNull
    public ChannelInboundHandler getChildHandler() {
        return this.childHandler;
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.read();
        ctx.fireChannelActive();
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        ctx.fireUserEventTriggered(evt);
        if (evt instanceof IdleStateEvent) {
            Logger arg0$iv = logger;
            boolean bl = false;
            if (InlineLogger.isDebugEnabled-impl((Logger)arg0$iv)) {
                Logger logger = arg0$iv;
                boolean bl2 = false;
                logger.debug(String.valueOf("Channel has gone idle during HAProxy message handling, closing for " + ctx.channel()));
            }
            ctx.close();
        }
    }

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull HAProxyMessage msg) {
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        HAProxyCommand command = msg.command();
        Logger arg0$iv = HAProxyMessageHandler.logger;
        boolean bl = false;
        if (InlineLogger.isTraceEnabled-impl((Logger)arg0$iv)) {
            logger = arg0$iv;
            boolean bl2 = false;
            logger.trace(String.valueOf("Received HAProxy command " + command + " from " + ctx.channel()));
        }
        HAProxyCommand hAProxyCommand = command;
        switch (hAProxyCommand == null ? -1 : WhenMappings.$EnumSwitchMapping$0[hAProxyCommand.ordinal()]) {
            case 1: {
                this.handleProxyCommand(ctx, msg);
                break;
            }
            case 2: {
                this.handleLocalCommand(ctx);
                break;
            }
            default: {
                Logger arg0$iv2 = HAProxyMessageHandler.logger;
                boolean bl3 = false;
                if (InlineLogger.isWarnEnabled-impl((Logger)arg0$iv2)) {
                    logger = arg0$iv2;
                    boolean bl4 = false;
                    logger.warn(String.valueOf("Received unsupported HAProxy command " + command + " from " + ctx.channel()));
                }
                ctx.close();
            }
        }
    }

    private final void handleProxyCommand(ChannelHandlerContext ctx, HAProxyMessage msg) {
        HAProxyProtocolVersion hAProxyProtocolVersion = msg.protocolVersion();
        Intrinsics.checkNotNullExpressionValue((Object)hAProxyProtocolVersion, (String)"protocolVersion(...)");
        HAProxyProxiedProtocol hAProxyProxiedProtocol = msg.proxiedProtocol();
        Intrinsics.checkNotNullExpressionValue((Object)hAProxyProxiedProtocol, (String)"proxiedProtocol(...)");
        String string = msg.sourceAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sourceAddress(...)");
        int n = msg.sourcePort();
        String string2 = msg.destinationAddress();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"destinationAddress(...)");
        HAProxyAttribute attribute = new HAProxyAttribute(hAProxyProtocolVersion, hAProxyProxiedProtocol, string, n, string2, msg.destinationPort());
        Channel channel = ctx.channel();
        Intrinsics.checkNotNull((Object)channel);
        HAProxyAttributes.setHaproxyAttribute(channel, attribute);
        Logger arg0$iv = logger;
        boolean bl = false;
        if (InlineLogger.isDebugEnabled-impl((Logger)arg0$iv)) {
            Logger logger = arg0$iv;
            boolean bl2 = false;
            logger.debug(String.valueOf("Set HAProxy attribute " + attribute + " for channel " + channel));
        }
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.remove(HAProxyHandlerNames.INSTANCE.getHAPROXY_IDLE_STATE_HANDLER_NAME());
        pipeline.replace((ChannelHandler)this, HAProxyHandlerNames.INSTANCE.getHAPROXY_CHANNEL_INITIALIZER_CHILD_NAME(), (ChannelHandler)this.getChildHandler());
        channel.eventLoop().execute(() -> HAProxyMessageHandler.handleProxyCommand$lambda$4(ctx));
    }

    private final void handleLocalCommand(ChannelHandlerContext ctx) {
        ctx.close();
    }

    private static final void handleProxyCommand$lambda$4(ChannelHandlerContext $ctx) {
        Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
        $ctx.read();
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u0005\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u0006"}, d2={"Lorg/jire/netty/haproxy/HAProxyMessageHandler$Companion;", "", "()V", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "haproxy"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HAProxyCommand.values().length];
            try {
                nArray[HAProxyCommand.PROXY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HAProxyCommand.LOCAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

