/*
 * Decompiled with CFR 0.152.
 */
package org.jire.netty.haproxy;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.netty.handler.timeout.IdleStateEvent;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jire.netty.haproxy.HAProxyHandlerNames;
import org.jire.netty.haproxy.HAProxyMessageHandler;
import org.jire.netty.haproxy.HAProxyParentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00182\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0018B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0002H\u0014J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jire/netty/haproxy/HAProxyDetectionHandler;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lio/netty/buffer/ByteBuf;", "Lorg/jire/netty/haproxy/HAProxyParentHandler;", "childHandler", "Lio/netty/channel/ChannelInboundHandler;", "haproxyMessageHandler", "Lorg/jire/netty/haproxy/HAProxyMessageHandler;", "(Lio/netty/channel/ChannelInboundHandler;Lorg/jire/netty/haproxy/HAProxyMessageHandler;)V", "getChildHandler", "()Lio/netty/channel/ChannelInboundHandler;", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelRead0", "msg", "handleNonProxied", "channel", "Lio/netty/channel/Channel;", "handleProxied", "userEventTriggered", "evt", "", "Companion", "haproxy"})
@SourceDebugExtension(value={"SMAP\nHAProxyDetectionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HAProxyDetectionHandler.kt\norg/jire/netty/haproxy/HAProxyDetectionHandler\n+ 2 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n*L\n1#1,123:1\n56#2,4:124\n32#2,4:128\n32#2,4:132\n32#2,4:136\n11#3,2:140\n*S KotlinDebug\n*F\n+ 1 HAProxyDetectionHandler.kt\norg/jire/netty/haproxy/HAProxyDetectionHandler\n*L\n46#1:124,4\n60#1:128,4\n81#1:132,4\n103#1:136,4\n120#1:140,2\n*E\n"})
public final class HAProxyDetectionHandler
extends SimpleChannelInboundHandler<ByteBuf>
implements HAProxyParentHandler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ChannelInboundHandler childHandler;
    @NotNull
    private final HAProxyMessageHandler haproxyMessageHandler;
    private static final short FIRST_BYTE_V2 = 13;
    private static final short FIRST_BYTE_V1 = 80;
    @NotNull
    private static final Logger logger;

    public HAProxyDetectionHandler(@NotNull ChannelInboundHandler childHandler, @NotNull HAProxyMessageHandler haproxyMessageHandler) {
        Intrinsics.checkNotNullParameter((Object)childHandler, (String)"childHandler");
        Intrinsics.checkNotNullParameter((Object)haproxyMessageHandler, (String)"haproxyMessageHandler");
        super(true);
        this.childHandler = childHandler;
        this.haproxyMessageHandler = haproxyMessageHandler;
    }

    @Override
    @NotNull
    public ChannelInboundHandler getChildHandler() {
        return this.childHandler;
    }

    public void channelActive(@NotNull ChannelHandlerContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.read();
        ctx.fireChannelActive();
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
        ctx.fireUserEventTriggered(evt);
        if (evt instanceof IdleStateEvent) {
            Logger arg0$iv = logger;
            boolean bl = false;
            if (InlineLogger.isDebugEnabled-impl((Logger)arg0$iv)) {
                Logger logger = arg0$iv;
                boolean bl2 = false;
                logger.debug(String.valueOf("Channel has gone idle during HAProxy detection, closing for " + ctx.channel()));
            }
            ctx.close();
        }
    }

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull ByteBuf msg) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Channel channel = ctx.channel();
        short firstByte = msg.getUnsignedByte(0);
        Logger arg0$iv22 = logger;
        boolean bl = false;
        if (InlineLogger.isTraceEnabled-impl((Logger)arg0$iv22)) {
            Logger logger = arg0$iv22;
            boolean bl2 = false;
            logger.trace(String.valueOf("First byte from " + channel + " was " + firstByte));
        }
        short arg0$iv22 = firstByte;
        if (arg0$iv22 == 13 ? true : arg0$iv22 == 80) {
            Intrinsics.checkNotNull((Object)channel);
            this.handleProxied(ctx, channel);
        } else {
            Intrinsics.checkNotNull((Object)channel);
            this.handleNonProxied(ctx, channel);
        }
        ByteBuf retainedMsg = msg.retain();
        channel.eventLoop().execute(() -> HAProxyDetectionHandler.channelRead0$lambda$2(ctx, retainedMsg));
    }

    private final void handleProxied(ChannelHandlerContext ctx, Channel channel) {
        Logger arg0$iv = logger;
        boolean bl = false;
        if (InlineLogger.isTraceEnabled-impl((Logger)arg0$iv)) {
            Logger logger = arg0$iv;
            boolean bl2 = false;
            logger.trace(String.valueOf("HAProxy protocol detected from " + channel));
        }
        ChannelPipeline pipeline = ctx.pipeline();
        String name = ctx.name();
        pipeline.addAfter(name, HAProxyHandlerNames.INSTANCE.getHAPROXY_MESSAGE_HANDLER_NAME(), (ChannelHandler)this.haproxyMessageHandler);
        pipeline.replace(name, HAProxyHandlerNames.INSTANCE.getHAPROXY_MESSAGE_DECODER_HANDLER_NAME(), (ChannelHandler)new HAProxyMessageDecoder());
    }

    private final void handleNonProxied(ChannelHandlerContext ctx, Channel channel) {
        Logger arg0$iv = logger;
        boolean bl = false;
        if (InlineLogger.isTraceEnabled-impl((Logger)arg0$iv)) {
            Logger logger = arg0$iv;
            boolean bl2 = false;
            logger.trace(String.valueOf("HAProxy protocol not detected from " + channel));
        }
        ChannelPipeline pipeline = ctx.pipeline();
        pipeline.remove(HAProxyHandlerNames.INSTANCE.getHAPROXY_IDLE_STATE_HANDLER_NAME());
        pipeline.replace((ChannelHandler)this, HAProxyHandlerNames.INSTANCE.getHAPROXY_CHANNEL_INITIALIZER_CHILD_NAME(), (ChannelHandler)this.getChildHandler());
    }

    private static final void channelRead0$lambda$2(ChannelHandlerContext $ctx, ByteBuf $retainedMsg) {
        Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
        $ctx.fireChannelRead((Object)$retainedMsg);
        $ctx.read();
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\b\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\t"}, d2={"Lorg/jire/netty/haproxy/HAProxyDetectionHandler$Companion;", "", "()V", "FIRST_BYTE_V1", "", "FIRST_BYTE_V2", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "haproxy"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

