/*
 * Decompiled with CFR 0.152.
 */
package org.jire.netty.haproxy;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jire.netty.haproxy.HAProxyDetectionHandler;
import org.jire.netty.haproxy.HAProxyHandlerNames;
import org.jire.netty.haproxy.HAProxyIdleStateHandler;
import org.jire.netty.haproxy.HAProxyMessageHandler;
import org.jire.netty.haproxy.HAProxyMode;
import org.jire.netty.haproxy.HAProxyParentHandler;

@ChannelHandler.Sharable
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B-\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0002H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jire/netty/haproxy/HAProxyChannelInitializer;", "Lio/netty/channel/ChannelInitializer;", "Lio/netty/channel/Channel;", "Lorg/jire/netty/haproxy/HAProxyParentHandler;", "childHandler", "Lio/netty/channel/ChannelInboundHandler;", "mode", "Lorg/jire/netty/haproxy/HAProxyMode;", "idleTimeout", "", "idleTimeoutUnit", "Ljava/util/concurrent/TimeUnit;", "(Lio/netty/channel/ChannelInboundHandler;Lorg/jire/netty/haproxy/HAProxyMode;JLjava/util/concurrent/TimeUnit;)V", "getChildHandler", "()Lio/netty/channel/ChannelInboundHandler;", "detectionHandler", "Lorg/jire/netty/haproxy/HAProxyDetectionHandler;", "messageHandler", "Lorg/jire/netty/haproxy/HAProxyMessageHandler;", "addHAProxyHandlers", "", "pipeline", "Lio/netty/channel/ChannelPipeline;", "addIdleStateHandler", "initChannel", "ch", "haproxy"})
public final class HAProxyChannelInitializer
extends ChannelInitializer<Channel>
implements HAProxyParentHandler {
    @NotNull
    private final ChannelInboundHandler childHandler;
    @NotNull
    private final HAProxyMode mode;
    private final long idleTimeout;
    @NotNull
    private final TimeUnit idleTimeoutUnit;
    @NotNull
    private final HAProxyMessageHandler messageHandler;
    @NotNull
    private final HAProxyDetectionHandler detectionHandler;

    @JvmOverloads
    public HAProxyChannelInitializer(@NotNull ChannelInboundHandler childHandler, @NotNull HAProxyMode mode, long idleTimeout, @NotNull TimeUnit idleTimeoutUnit) {
        Intrinsics.checkNotNullParameter((Object)childHandler, (String)"childHandler");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)((Object)idleTimeoutUnit), (String)"idleTimeoutUnit");
        this.childHandler = childHandler;
        this.mode = mode;
        this.idleTimeout = idleTimeout;
        this.idleTimeoutUnit = idleTimeoutUnit;
        this.messageHandler = new HAProxyMessageHandler(this.getChildHandler());
        this.detectionHandler = new HAProxyDetectionHandler(this.getChildHandler(), this.messageHandler);
    }

    public /* synthetic */ HAProxyChannelInitializer(ChannelInboundHandler channelInboundHandler, HAProxyMode hAProxyMode, long l, TimeUnit timeUnit, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            hAProxyMode = HAProxyMode.AUTO;
        }
        if ((n & 4) != 0) {
            l = 60L;
        }
        if ((n & 8) != 0) {
            timeUnit = HAProxyIdleStateHandler.Companion.getDEFAULT_IDLE_TIMEOUT_UNIT();
        }
        this(channelInboundHandler, hAProxyMode, l, timeUnit);
    }

    @Override
    @NotNull
    public ChannelInboundHandler getChildHandler() {
        return this.childHandler;
    }

    protected void initChannel(@NotNull Channel ch) {
        Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
        ChannelPipeline pipeline = ch.pipeline();
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 1: {
                Intrinsics.checkNotNull((Object)pipeline);
                this.addIdleStateHandler(pipeline);
                pipeline.addLast(HAProxyHandlerNames.INSTANCE.getHAPROXY_DETECTION_HANDLER_NAME(), (ChannelHandler)this.detectionHandler);
                break;
            }
            case 2: {
                Intrinsics.checkNotNull((Object)pipeline);
                this.addIdleStateHandler(pipeline);
                this.addHAProxyHandlers(pipeline);
                break;
            }
            case 3: {
                pipeline.replace((ChannelHandler)this, HAProxyHandlerNames.INSTANCE.getHAPROXY_CHANNEL_INITIALIZER_CHILD_NAME(), (ChannelHandler)this.getChildHandler());
            }
        }
    }

    public final void addIdleStateHandler(@NotNull ChannelPipeline pipeline) {
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        pipeline.addLast(HAProxyHandlerNames.INSTANCE.getHAPROXY_IDLE_STATE_HANDLER_NAME(), (ChannelHandler)new HAProxyIdleStateHandler(this.idleTimeout, this.idleTimeoutUnit));
    }

    public final void addHAProxyHandlers(@NotNull ChannelPipeline pipeline) {
        Intrinsics.checkNotNullParameter((Object)pipeline, (String)"pipeline");
        pipeline.addLast(HAProxyHandlerNames.INSTANCE.getHAPROXY_MESSAGE_DECODER_HANDLER_NAME(), (ChannelHandler)new HAProxyMessageDecoder());
        pipeline.addLast(HAProxyHandlerNames.INSTANCE.getHAPROXY_MESSAGE_HANDLER_NAME(), (ChannelHandler)this.messageHandler);
    }

    @JvmOverloads
    public HAProxyChannelInitializer(@NotNull ChannelInboundHandler childHandler, @NotNull HAProxyMode mode, long idleTimeout) {
        Intrinsics.checkNotNullParameter((Object)childHandler, (String)"childHandler");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this(childHandler, mode, idleTimeout, null, 8, null);
    }

    @JvmOverloads
    public HAProxyChannelInitializer(@NotNull ChannelInboundHandler childHandler, @NotNull HAProxyMode mode) {
        Intrinsics.checkNotNullParameter((Object)childHandler, (String)"childHandler");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        this(childHandler, mode, 0L, null, 12, null);
    }

    @JvmOverloads
    public HAProxyChannelInitializer(@NotNull ChannelInboundHandler childHandler) {
        Intrinsics.checkNotNullParameter((Object)childHandler, (String)"childHandler");
        this(childHandler, null, 0L, null, 14, null);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HAProxyMode.values().length];
            try {
                nArray[HAProxyMode.AUTO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HAProxyMode.ON.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[HAProxyMode.OFF.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

