/*
 * Decompiled with CFR 0.152.
 */
package org.jire.netty.haproxy;

import io.netty.handler.codec.haproxy.HAProxyProtocolVersion;
import io.netty.handler.codec.haproxy.HAProxyProxiedProtocol;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.ReferenceCounted;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\tH\u00c6\u0003JE\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\tH\u00c6\u0001J\b\u0010$\u001a\u00020%H\u0014J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u00d6\u0003J\t\u0010*\u001a\u00020\tH\u00d6\u0001J\t\u0010+\u001a\u00020\u0007H\u00d6\u0001J\u0012\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010)H\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006/"}, d2={"Lorg/jire/netty/haproxy/HAProxyAttribute;", "Lio/netty/util/AbstractReferenceCounted;", "version", "Lio/netty/handler/codec/haproxy/HAProxyProtocolVersion;", "protocol", "Lio/netty/handler/codec/haproxy/HAProxyProxiedProtocol;", "sourceHost", "", "sourcePort", "", "destinationHost", "destinationPort", "(Lio/netty/handler/codec/haproxy/HAProxyProtocolVersion;Lio/netty/handler/codec/haproxy/HAProxyProxiedProtocol;Ljava/lang/String;ILjava/lang/String;I)V", "destinationAddress", "Ljava/net/SocketAddress;", "getDestinationAddress", "()Ljava/net/SocketAddress;", "getDestinationHost", "()Ljava/lang/String;", "getDestinationPort", "()I", "getProtocol", "()Lio/netty/handler/codec/haproxy/HAProxyProxiedProtocol;", "sourceAddress", "getSourceAddress", "getSourceHost", "getSourcePort", "getVersion", "()Lio/netty/handler/codec/haproxy/HAProxyProtocolVersion;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "deallocate", "", "equals", "", "other", "", "hashCode", "toString", "touch", "Lio/netty/util/ReferenceCounted;", "hint", "haproxy"})
public final class HAProxyAttribute
extends AbstractReferenceCounted {
    @NotNull
    private final HAProxyProtocolVersion version;
    @NotNull
    private final HAProxyProxiedProtocol protocol;
    @NotNull
    private final String sourceHost;
    private final int sourcePort;
    @NotNull
    private final String destinationHost;
    private final int destinationPort;
    @NotNull
    private final SocketAddress sourceAddress;
    @NotNull
    private final SocketAddress destinationAddress;

    public HAProxyAttribute(@NotNull HAProxyProtocolVersion version, @NotNull HAProxyProxiedProtocol protocol, @NotNull String sourceHost, int sourcePort, @NotNull String destinationHost, int destinationPort) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)sourceHost, (String)"sourceHost");
        Intrinsics.checkNotNullParameter((Object)destinationHost, (String)"destinationHost");
        this.version = version;
        this.protocol = protocol;
        this.sourceHost = sourceHost;
        this.sourcePort = sourcePort;
        this.destinationHost = destinationHost;
        this.destinationPort = destinationPort;
        InetSocketAddress inetSocketAddress = InetSocketAddress.createUnresolved(this.sourceHost, this.sourcePort);
        Intrinsics.checkNotNullExpressionValue((Object)inetSocketAddress, (String)"createUnresolved(...)");
        this.sourceAddress = inetSocketAddress;
        InetSocketAddress inetSocketAddress2 = InetSocketAddress.createUnresolved(this.destinationHost, this.destinationPort);
        Intrinsics.checkNotNullExpressionValue((Object)inetSocketAddress2, (String)"createUnresolved(...)");
        this.destinationAddress = inetSocketAddress2;
    }

    @NotNull
    public final HAProxyProtocolVersion getVersion() {
        return this.version;
    }

    @NotNull
    public final HAProxyProxiedProtocol getProtocol() {
        return this.protocol;
    }

    @NotNull
    public final String getSourceHost() {
        return this.sourceHost;
    }

    public final int getSourcePort() {
        return this.sourcePort;
    }

    @NotNull
    public final String getDestinationHost() {
        return this.destinationHost;
    }

    public final int getDestinationPort() {
        return this.destinationPort;
    }

    @NotNull
    public final SocketAddress getSourceAddress() {
        return this.sourceAddress;
    }

    @NotNull
    public final SocketAddress getDestinationAddress() {
        return this.destinationAddress;
    }

    @NotNull
    public ReferenceCounted touch(@Nullable Object hint) {
        return (ReferenceCounted)this;
    }

    protected void deallocate() {
    }

    @NotNull
    public final HAProxyProtocolVersion component1() {
        return this.version;
    }

    @NotNull
    public final HAProxyProxiedProtocol component2() {
        return this.protocol;
    }

    @NotNull
    public final String component3() {
        return this.sourceHost;
    }

    public final int component4() {
        return this.sourcePort;
    }

    @NotNull
    public final String component5() {
        return this.destinationHost;
    }

    public final int component6() {
        return this.destinationPort;
    }

    @NotNull
    public final HAProxyAttribute copy(@NotNull HAProxyProtocolVersion version, @NotNull HAProxyProxiedProtocol protocol, @NotNull String sourceHost, int sourcePort, @NotNull String destinationHost, int destinationPort) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)sourceHost, (String)"sourceHost");
        Intrinsics.checkNotNullParameter((Object)destinationHost, (String)"destinationHost");
        return new HAProxyAttribute(version, protocol, sourceHost, sourcePort, destinationHost, destinationPort);
    }

    public static /* synthetic */ HAProxyAttribute copy$default(HAProxyAttribute hAProxyAttribute, HAProxyProtocolVersion hAProxyProtocolVersion, HAProxyProxiedProtocol hAProxyProxiedProtocol, String string, int n, String string2, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            hAProxyProtocolVersion = hAProxyAttribute.version;
        }
        if ((n3 & 2) != 0) {
            hAProxyProxiedProtocol = hAProxyAttribute.protocol;
        }
        if ((n3 & 4) != 0) {
            string = hAProxyAttribute.sourceHost;
        }
        if ((n3 & 8) != 0) {
            n = hAProxyAttribute.sourcePort;
        }
        if ((n3 & 0x10) != 0) {
            string2 = hAProxyAttribute.destinationHost;
        }
        if ((n3 & 0x20) != 0) {
            n2 = hAProxyAttribute.destinationPort;
        }
        return hAProxyAttribute.copy(hAProxyProtocolVersion, hAProxyProxiedProtocol, string, n, string2, n2);
    }

    @NotNull
    public String toString() {
        return "HAProxyAttribute(version=" + this.version + ", protocol=" + this.protocol + ", sourceHost=" + this.sourceHost + ", sourcePort=" + this.sourcePort + ", destinationHost=" + this.destinationHost + ", destinationPort=" + this.destinationPort + ")";
    }

    public int hashCode() {
        int result = this.version.hashCode();
        result = result * 31 + this.protocol.hashCode();
        result = result * 31 + this.sourceHost.hashCode();
        result = result * 31 + Integer.hashCode(this.sourcePort);
        result = result * 31 + this.destinationHost.hashCode();
        result = result * 31 + Integer.hashCode(this.destinationPort);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HAProxyAttribute)) {
            return false;
        }
        HAProxyAttribute hAProxyAttribute = (HAProxyAttribute)((Object)other);
        if (this.version != hAProxyAttribute.version) {
            return false;
        }
        if (this.protocol != hAProxyAttribute.protocol) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sourceHost, (Object)hAProxyAttribute.sourceHost)) {
            return false;
        }
        if (this.sourcePort != hAProxyAttribute.sourcePort) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.destinationHost, (Object)hAProxyAttribute.destinationHost)) {
            return false;
        }
        return this.destinationPort == hAProxyAttribute.destinationPort;
    }
}

