/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.compression;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\tH\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u000bH\u00d6\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnet/rsprot/compression/Base37;", "", "()V", "ALPHABET", "", "BASE_37", "", "MAXIMUM_POSSIBLE_12_CHARACTER_VALUE", "NBSP", "", "decode", "", "encoded", "decodeWithCase", "encode", "charSequence", "", "equals", "", "other", "hashCode", "toString", "compression"})
@SourceDebugExtension(value={"SMAP\nBase37.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base37.kt\nnet/rsprot/compression/Base37\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,187:1\n151#2,6:188\n*S KotlinDebug\n*F\n+ 1 Base37.kt\nnet/rsprot/compression/Base37\n*L\n67#1:188,6\n*E\n"})
public final class Base37 {
    @NotNull
    public static final Base37 INSTANCE = new Base37();
    private static final long BASE_37 = 37L;
    private static final long MAXIMUM_POSSIBLE_12_CHARACTER_VALUE = 6582952005840035280L;
    private static final int NBSP = 160;
    @NotNull
    private static final char[] ALPHABET;

    private Base37() {
    }

    public final long encode(@NotNull CharSequence charSequence) {
        int indexOfInvalidCharacter;
        block7: {
            int n;
            Intrinsics.checkNotNullParameter((Object)charSequence, (String)"charSequence");
            if (!(charSequence.length() <= 12)) {
                boolean $i$a$-require-Base37$encode$32 = false;
                String $i$a$-require-Base37$encode$32 = "Char sequence length must be 12 characters or less.";
                throw new IllegalArgumentException($i$a$-require-Base37$encode$32.toString());
            }
            CharSequence $this$indexOfFirst$iv = charSequence;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(!ArraysKt.contains((char[])ALPHABET, (char)it))) continue;
                n = index$iv;
                break block7;
            }
            n = indexOfInvalidCharacter = -1;
        }
        if (!(indexOfInvalidCharacter == -1)) {
            boolean bl = false;
            String string = "Invalid character in charSequence at index " + indexOfInvalidCharacter + ": " + charSequence.charAt(indexOfInvalidCharacter);
            throw new IllegalArgumentException(string.toString());
        }
        long encoded = 0L;
        for (int i = 0; i < charSequence.length(); ++i) {
            char element = charSequence.charAt(i);
            encoded *= 37L;
            char c = element;
            boolean bl = 'A' <= c ? c < '[' : false;
            if (bl) {
                encoded += (long)(element + '\u0001' - 65);
                continue;
            }
            boolean bl2 = 'a' <= c ? c < '{' : false;
            if (bl2) {
                encoded += (long)(element + '\u0001' - 97);
                continue;
            }
            boolean bl3 = '0' <= c ? c < ':' : false;
            if (!bl3) continue;
            encoded += (long)(element + 27 - 48);
        }
        while (encoded % 37L == 0L && encoded != 0L) {
            encoded /= 37L;
        }
        return encoded;
    }

    @NotNull
    public final String decode(long encoded) {
        if (encoded == 0L) {
            return "";
        }
        if (!(0L <= encoded ? encoded < 6582952005840035281L : false)) {
            boolean $i$a$-require-Base37$decode$32 = false;
            String $i$a$-require-Base37$decode$32 = "Invalid encoded value: " + encoded;
            throw new IllegalArgumentException($i$a$-require-Base37$decode$32.toString());
        }
        if (!(encoded % 37L != 0L)) {
            boolean $i$a$-require-Base37$decode$42 = false;
            String $i$a$-require-Base37$decode$42 = "Encoded value not in base-37: " + encoded;
            throw new IllegalArgumentException($i$a$-require-Base37$decode$42.toString());
        }
        int length = 0;
        for (long lengthCounter = encoded; lengthCounter != 0L; lengthCounter /= 37L) {
            ++length;
        }
        StringBuilder builder = new StringBuilder(length);
        long rem = encoded;
        while (rem != 0L) {
            long cur = rem;
            builder.append(ALPHABET[(int)(cur - (rem /= 37L) * 37L)]);
        }
        String string = builder.reverse().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String decodeWithCase(long encoded) {
        if (encoded == 0L) {
            return "";
        }
        if (!(0L <= encoded ? encoded < 6582952005840035281L : false)) {
            boolean $i$a$-require-Base37$decodeWithCase$32 = false;
            String $i$a$-require-Base37$decodeWithCase$32 = "Invalid encoded value: " + encoded;
            throw new IllegalArgumentException($i$a$-require-Base37$decodeWithCase$32.toString());
        }
        if (!(encoded % 37L != 0L)) {
            boolean $i$a$-require-Base37$decodeWithCase$42 = false;
            String $i$a$-require-Base37$decodeWithCase$42 = "Encoded value not in base-37: " + encoded;
            throw new IllegalArgumentException($i$a$-require-Base37$decodeWithCase$42.toString());
        }
        int length = 0;
        for (long lengthCounter = encoded; lengthCounter != 0L; lengthCounter /= 37L) {
            ++length;
        }
        StringBuilder builder = new StringBuilder(length);
        long rem = encoded;
        while (rem != 0L) {
            long var6 = rem;
            int n = ALPHABET[(int)(var6 - (rem /= 37L) * 37L)];
            if (n == 95) {
                int lastIndex = builder.length() - 1;
                builder.setCharAt(lastIndex, Character.toUpperCase(builder.charAt(lastIndex)));
                n = 160;
            }
            builder.append((char)n);
        }
        builder.reverse();
        builder.setCharAt(0, Character.toUpperCase(builder.charAt(0)));
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public String toString() {
        return "Base37";
    }

    public int hashCode() {
        return 1435630610;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Base37)) {
            return false;
        }
        Base37 cfr_ignored_0 = (Base37)other;
        return true;
    }

    static {
        char[] cArray = new char[]{'_', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        ALPHABET = cArray;
    }
}

