/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.buffer.extensions;

import io.netty.buffer.ByteBuf;
import io.netty.util.ByteProcessor;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.rsprot.buffer.JagByteBuf;
import net.rsprot.buffer.util.charset.Cp1252Charset;
import net.rsprot.crypto.crc.CyclicRedundancyCheck;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000Z\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001d\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b)\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0002\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0003\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u000b\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\f\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0014\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0015\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0017\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0018\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u001c\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u001d\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u001e\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\u001f\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010 \u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010!\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010\"\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010#\u001a\u00020$*\u00020\u0003\u001a\n\u0010%\u001a\u00020&*\u00020\u0003\u001a\n\u0010'\u001a\u00020(*\u00020\u0003\u001a\n\u0010)\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010*\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010+\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010,\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010-\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010.\u001a\u00020\u0001*\u00020\u0003\u001a\n\u0010/\u001a\u00020\u0001*\u00020\u0003\u001a\n\u00100\u001a\u00020\u0001*\u00020\u0003\u001a\n\u00101\u001a\u00020\u0001*\u00020\u0003\u001a\n\u00102\u001a\u00020\u0006*\u00020\u0003\u001a&\u00103\u001a\u000204*\u00020\u00032\u0006\u00105\u001a\u00020\u00032\b\b\u0002\u00106\u001a\u00020\u00012\b\b\u0002\u00107\u001a\u00020\u0001\u001a&\u00103\u001a\u000204*\u00020\u00032\u0006\u00105\u001a\u0002082\b\b\u0002\u00106\u001a\u00020\u00012\b\b\u0002\u00107\u001a\u00020\u0001\u001a&\u00109\u001a\u000204*\u00020\u00032\u0006\u00105\u001a\u00020\u00032\b\b\u0002\u00106\u001a\u00020\u00012\b\b\u0002\u00107\u001a\u00020\u0001\u001a&\u00109\u001a\u000204*\u00020\u00032\u0006\u00105\u001a\u0002082\b\b\u0002\u00106\u001a\u00020\u00012\b\b\u0002\u00107\u001a\u00020\u0001\u001a&\u0010:\u001a\u000204*\u00020\u00032\u0006\u00105\u001a\u00020\u00032\b\b\u0002\u00106\u001a\u00020\u00012\b\b\u0002\u00107\u001a\u00020\u0001\u001a&\u0010:\u001a\u000204*\u00020\u00032\u0006\u00105\u001a\u0002082\b\b\u0002\u00106\u001a\u00020\u00012\b\b\u0002\u00107\u001a\u00020\u0001\u001a&\u0010;\u001a\u000204*\u00020\u00032\u0006\u00105\u001a\u00020\u00032\b\b\u0002\u00106\u001a\u00020\u00012\b\b\u0002\u00107\u001a\u00020\u0001\u001a&\u0010;\u001a\u000204*\u00020\u00032\u0006\u00105\u001a\u0002082\b\b\u0002\u00106\u001a\u00020\u00012\b\b\u0002\u00107\u001a\u00020\u0001\u001a\n\u0010<\u001a\u00020=*\u00020\u0003\u001a\n\u0010>\u001a\u00020=*\u00020\u0003\u001a\f\u0010?\u001a\u0004\u0018\u00010=*\u00020\u0003\u001a\u0012\u0010@\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010B\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010C\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010D\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010E\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010F\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010G\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010H\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010I\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010J\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010K\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010L\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010M\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010N\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010O\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010P\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010Q\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020$\u001a\u0012\u0010R\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020&\u001a\u0012\u0010S\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020(\u001a\u0012\u0010T\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010U\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010V\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010W\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010X\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010Y\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010Z\u001a\u00020\u0003*\u00020\u00032\u0006\u0010[\u001a\u00020\u0001\u001a\u0012\u0010\\\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010]\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0001\u001a\u0012\u0010^\u001a\u00020\u0003*\u00020\u00032\u0006\u0010A\u001a\u00020\u0006\u001a&\u0010_\u001a\u00020\u0003*\u00020\u00032\u0006\u0010`\u001a\u00020\u00032\b\b\u0002\u00106\u001a\u00020\u00012\b\b\u0002\u00107\u001a\u00020\u0001\u001a&\u0010_\u001a\u00020\u0003*\u00020\u00032\u0006\u0010`\u001a\u0002082\b\b\u0002\u00106\u001a\u00020\u00012\b\b\u0002\u00107\u001a\u00020\u0001\u001a&\u0010a\u001a\u00020\u0003*\u00020\u00032\u0006\u0010b\u001a\u00020\u00032\b\b\u0002\u00106\u001a\u00020\u00012\b\b\u0002\u00107\u001a\u00020\u0001\u001a&\u0010a\u001a\u00020\u0003*\u00020\u00032\u0006\u0010b\u001a\u0002082\b\b\u0002\u00106\u001a\u00020\u00012\b\b\u0002\u00107\u001a\u00020\u0001\u001a&\u0010c\u001a\u00020\u0003*\u00020\u00032\u0006\u0010b\u001a\u00020\u00032\b\b\u0002\u00106\u001a\u00020\u00012\b\b\u0002\u00107\u001a\u00020\u0001\u001a&\u0010c\u001a\u00020\u0003*\u00020\u00032\u0006\u0010b\u001a\u0002082\b\b\u0002\u00106\u001a\u00020\u00012\b\b\u0002\u00107\u001a\u00020\u0001\u001a&\u0010d\u001a\u00020\u0003*\u00020\u00032\u0006\u0010b\u001a\u00020\u00032\b\b\u0002\u00106\u001a\u00020\u00012\b\b\u0002\u00107\u001a\u00020\u0001\u001a&\u0010d\u001a\u00020\u0003*\u00020\u00032\u0006\u0010b\u001a\u0002082\b\b\u0002\u00106\u001a\u00020\u00012\b\b\u0002\u00107\u001a\u00020\u0001\u001a\u001c\u0010e\u001a\u00020\u0003*\u00020\u00032\u0006\u0010f\u001a\u00020g2\b\b\u0002\u0010h\u001a\u00020i\u001a\u0012\u0010j\u001a\u00020\u0003*\u00020\u00032\u0006\u0010f\u001a\u00020g\u001a\u001e\u0010k\u001a\u00020\u0003*\u00020\u00032\b\u0010f\u001a\u0004\u0018\u00010g2\b\b\u0002\u0010h\u001a\u00020i\u001a\u0016\u0010l\u001a\u00020=*\u00020\u00032\b\b\u0002\u0010h\u001a\u00020iH\u0002\u001a\u000f\u0010m\u001a\u00020n*\u00020\u0003\u00a2\u0006\u0002\u0010o\u001a\u001e\u0010p\u001a\u00020\u0003*\u00020\u00032\u0006\u0010f\u001a\u00020g2\b\b\u0002\u0010h\u001a\u00020iH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006q"}, d2={"HALF_UBYTE", "", "addCRC32", "Lio/netty/buffer/ByteBuf;", "startIndex", "checkCRC32", "", "g1", "g1Alt1", "g1Alt2", "g1Alt3", "g1s", "g1sAlt1", "g1sAlt2", "g1sAlt3", "g2", "g2Alt1", "g2Alt2", "g2Alt3", "g2s", "g2sAlt1", "g2sAlt2", "g2sAlt3", "g3", "g3Alt1", "g3Alt2", "g3Alt3", "g3s", "g3sAlt1", "g3sAlt2", "g3sAlt3", "g4", "g4Alt1", "g4Alt2", "g4Alt3", "g4f", "", "g8", "", "g8d", "", "gSmart1or2", "gSmart1or2extended", "gSmart1or2null", "gSmart1or2s", "gSmart2or4", "gSmart2or4null", "gVarInt", "gVarInt2", "gVarInt2s", "gboolean", "gdata", "", "dest", "offset", "length", "", "gdataAlt1", "gdataAlt2", "gdataAlt3", "gjstr", "", "gjstr2", "gjstrnull", "p1", "value", "p1Alt1", "p1Alt2", "p1Alt3", "p2", "p2Alt1", "p2Alt2", "p2Alt3", "p3", "p3Alt1", "p3Alt2", "p3Alt3", "p4", "p4Alt1", "p4Alt2", "p4Alt3", "p4f", "p8", "p8d", "pSmart1or2", "pSmart1or2extended", "pSmart1or2null", "pSmart1or2s", "pSmart2or4", "pSmart2or4null", "pVarInt", "v", "pVarInt2", "pVarInt2s", "pboolean", "pdata", "src", "pdataAlt1", "data", "pdataAlt2", "pdataAlt3", "pjstr", "s", "", "charset", "Ljava/nio/charset/Charset;", "pjstr2", "pjstrnull", "readString", "toJagByteBuf", "Lnet/rsprot/buffer/JagByteBuf;", "(Lio/netty/buffer/ByteBuf;)Lio/netty/buffer/ByteBuf;", "writeString", "buffer"})
public final class JagexByteBufExtensionsKt {
    private static final int HALF_UBYTE = 128;

    public static final int g1(@NotNull ByteBuf $this$g1) {
        Intrinsics.checkNotNullParameter((Object)$this$g1, (String)"<this>");
        return $this$g1.readUnsignedByte();
    }

    public static final int g1s(@NotNull ByteBuf $this$g1s) {
        Intrinsics.checkNotNullParameter((Object)$this$g1s, (String)"<this>");
        return $this$g1s.readByte();
    }

    @NotNull
    public static final ByteBuf p1(@NotNull ByteBuf $this$p1, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$p1, (String)"<this>");
        ByteBuf byteBuf = $this$p1.writeByte(value);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"writeByte(...)");
        return byteBuf;
    }

    public static final int g1Alt1(@NotNull ByteBuf $this$g1Alt1) {
        Intrinsics.checkNotNullParameter((Object)$this$g1Alt1, (String)"<this>");
        return $this$g1Alt1.readUnsignedByte() - 128 & 0xFF;
    }

    public static final int g1sAlt1(@NotNull ByteBuf $this$g1sAlt1) {
        Intrinsics.checkNotNullParameter((Object)$this$g1sAlt1, (String)"<this>");
        return (byte)($this$g1sAlt1.readUnsignedByte() - 128);
    }

    @NotNull
    public static final ByteBuf p1Alt1(@NotNull ByteBuf $this$p1Alt1, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$p1Alt1, (String)"<this>");
        ByteBuf byteBuf = $this$p1Alt1.writeByte(value + 128);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"writeByte(...)");
        return byteBuf;
    }

    public static final int g1Alt2(@NotNull ByteBuf $this$g1Alt2) {
        Intrinsics.checkNotNullParameter((Object)$this$g1Alt2, (String)"<this>");
        return -$this$g1Alt2.readByte() & 0xFF;
    }

    public static final int g1sAlt2(@NotNull ByteBuf $this$g1sAlt2) {
        Intrinsics.checkNotNullParameter((Object)$this$g1sAlt2, (String)"<this>");
        return -$this$g1sAlt2.readByte();
    }

    @NotNull
    public static final ByteBuf p1Alt2(@NotNull ByteBuf $this$p1Alt2, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$p1Alt2, (String)"<this>");
        ByteBuf byteBuf = $this$p1Alt2.writeByte(-value);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"writeByte(...)");
        return byteBuf;
    }

    public static final int g1Alt3(@NotNull ByteBuf $this$g1Alt3) {
        Intrinsics.checkNotNullParameter((Object)$this$g1Alt3, (String)"<this>");
        return 128 - $this$g1Alt3.readByte() & 0xFF;
    }

    public static final int g1sAlt3(@NotNull ByteBuf $this$g1sAlt3) {
        Intrinsics.checkNotNullParameter((Object)$this$g1sAlt3, (String)"<this>");
        return (byte)(128 - $this$g1sAlt3.readByte());
    }

    @NotNull
    public static final ByteBuf p1Alt3(@NotNull ByteBuf $this$p1Alt3, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$p1Alt3, (String)"<this>");
        ByteBuf byteBuf = $this$p1Alt3.writeByte(128 - value);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"writeByte(...)");
        return byteBuf;
    }

    public static final int g2(@NotNull ByteBuf $this$g2) {
        Intrinsics.checkNotNullParameter((Object)$this$g2, (String)"<this>");
        return $this$g2.readUnsignedShort();
    }

    public static final int g2s(@NotNull ByteBuf $this$g2s) {
        Intrinsics.checkNotNullParameter((Object)$this$g2s, (String)"<this>");
        return $this$g2s.readShort();
    }

    @NotNull
    public static final ByteBuf p2(@NotNull ByteBuf $this$p2, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$p2, (String)"<this>");
        ByteBuf byteBuf = $this$p2.writeShort(value);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"writeShort(...)");
        return byteBuf;
    }

    public static final int g2Alt1(@NotNull ByteBuf $this$g2Alt1) {
        Intrinsics.checkNotNullParameter((Object)$this$g2Alt1, (String)"<this>");
        return $this$g2Alt1.readUnsignedShortLE();
    }

    public static final int g2sAlt1(@NotNull ByteBuf $this$g2sAlt1) {
        Intrinsics.checkNotNullParameter((Object)$this$g2sAlt1, (String)"<this>");
        return $this$g2sAlt1.readShortLE();
    }

    @NotNull
    public static final ByteBuf p2Alt1(@NotNull ByteBuf $this$p2Alt1, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$p2Alt1, (String)"<this>");
        $this$p2Alt1.writeByte(value);
        $this$p2Alt1.writeByte(value >> 8);
        return $this$p2Alt1;
    }

    public static final int g2Alt2(@NotNull ByteBuf $this$g2Alt2) {
        Intrinsics.checkNotNullParameter((Object)$this$g2Alt2, (String)"<this>");
        int n = $this$g2Alt2.readUnsignedShort();
        return n & 0xFF00 | (n & 0xFF) - 128 & 0xFF;
    }

    public static final int g2sAlt2(@NotNull ByteBuf $this$g2sAlt2) {
        Intrinsics.checkNotNullParameter((Object)$this$g2sAlt2, (String)"<this>");
        int n = $this$g2sAlt2.readUnsignedShort();
        int value = n & 0xFF00 | (n & 0xFF) - 128 & 0xFF;
        return value > Short.MAX_VALUE ? value - 65536 : value;
    }

    @NotNull
    public static final ByteBuf p2Alt2(@NotNull ByteBuf $this$p2Alt2, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$p2Alt2, (String)"<this>");
        $this$p2Alt2.writeByte(value >> 8);
        $this$p2Alt2.writeByte(value + 128);
        return $this$p2Alt2;
    }

    public static final int g2Alt3(@NotNull ByteBuf $this$g2Alt3) {
        Intrinsics.checkNotNullParameter((Object)$this$g2Alt3, (String)"<this>");
        int n = $this$g2Alt3.readUnsignedShort();
        return (n >>> 8) - 128 & 0xFF | (n & 0xFF) << 8;
    }

    public static final int g2sAlt3(@NotNull ByteBuf $this$g2sAlt3) {
        Intrinsics.checkNotNullParameter((Object)$this$g2sAlt3, (String)"<this>");
        int n = $this$g2sAlt3.readUnsignedShort();
        int value = (n >>> 8) - 128 & 0xFF | (n & 0xFF) << 8;
        return value > Short.MAX_VALUE ? value - 65536 : value;
    }

    @NotNull
    public static final ByteBuf p2Alt3(@NotNull ByteBuf $this$p2Alt3, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$p2Alt3, (String)"<this>");
        $this$p2Alt3.writeByte(value + 128);
        $this$p2Alt3.writeByte(value >> 8);
        return $this$p2Alt3;
    }

    public static final int g3(@NotNull ByteBuf $this$g3) {
        Intrinsics.checkNotNullParameter((Object)$this$g3, (String)"<this>");
        return $this$g3.readUnsignedMedium();
    }

    public static final int g3s(@NotNull ByteBuf $this$g3s) {
        Intrinsics.checkNotNullParameter((Object)$this$g3s, (String)"<this>");
        return $this$g3s.readMedium();
    }

    @NotNull
    public static final ByteBuf p3(@NotNull ByteBuf $this$p3, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$p3, (String)"<this>");
        ByteBuf byteBuf = $this$p3.writeMedium(value);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"writeMedium(...)");
        return byteBuf;
    }

    public static final int g3Alt1(@NotNull ByteBuf $this$g3Alt1) {
        Intrinsics.checkNotNullParameter((Object)$this$g3Alt1, (String)"<this>");
        return $this$g3Alt1.readUnsignedMediumLE();
    }

    public static final int g3sAlt1(@NotNull ByteBuf $this$g3sAlt1) {
        Intrinsics.checkNotNullParameter((Object)$this$g3sAlt1, (String)"<this>");
        return $this$g3sAlt1.readMediumLE();
    }

    @NotNull
    public static final ByteBuf p3Alt1(@NotNull ByteBuf $this$p3Alt1, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$p3Alt1, (String)"<this>");
        ByteBuf byteBuf = $this$p3Alt1.writeMediumLE(value);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"writeMediumLE(...)");
        return byteBuf;
    }

    public static final int g3Alt2(@NotNull ByteBuf $this$g3Alt2) {
        Intrinsics.checkNotNullParameter((Object)$this$g3Alt2, (String)"<this>");
        int medium = $this$g3Alt2.readUnsignedMedium();
        return (medium & 0xFF) << 8 | medium >>> 8 & 0xFF | (medium >>> 16 & 0xFF) << 16;
    }

    public static final int g3sAlt2(@NotNull ByteBuf $this$g3sAlt2) {
        Intrinsics.checkNotNullParameter((Object)$this$g3sAlt2, (String)"<this>");
        int medium = $this$g3sAlt2.readUnsignedMedium();
        int result = (medium & 0xFF) << 8 | medium >>> 8 & 0xFF | (medium >>> 16 & 0xFF) << 16;
        return result > 0x7FFFFF ? result - 0x1000000 : result;
    }

    @NotNull
    public static final ByteBuf p3Alt2(@NotNull ByteBuf $this$p3Alt2, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$p3Alt2, (String)"<this>");
        $this$p3Alt2.writeByte(value >> 16);
        $this$p3Alt2.writeByte(value);
        $this$p3Alt2.writeByte(value >> 8);
        return $this$p3Alt2;
    }

    public static final int g3Alt3(@NotNull ByteBuf $this$g3Alt3) {
        Intrinsics.checkNotNullParameter((Object)$this$g3Alt3, (String)"<this>");
        int medium = $this$g3Alt3.readUnsignedMedium();
        return medium & 0xFF | (medium >>> 8 & 0xFF) << 16 | (medium >>> 16 & 0xFF) << 8;
    }

    public static final int g3sAlt3(@NotNull ByteBuf $this$g3sAlt3) {
        Intrinsics.checkNotNullParameter((Object)$this$g3sAlt3, (String)"<this>");
        int medium = $this$g3sAlt3.readUnsignedMedium();
        int result = medium & 0xFF | (medium >>> 8 & 0xFF) << 16 | (medium >>> 16 & 0xFF) << 8;
        return result > 0x7FFFFF ? result - 0x1000000 : result;
    }

    @NotNull
    public static final ByteBuf p3Alt3(@NotNull ByteBuf $this$p3Alt3, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$p3Alt3, (String)"<this>");
        $this$p3Alt3.writeByte(value >> 8);
        $this$p3Alt3.writeByte(value >> 16);
        $this$p3Alt3.writeByte(value);
        return $this$p3Alt3;
    }

    public static final int g4(@NotNull ByteBuf $this$g4) {
        Intrinsics.checkNotNullParameter((Object)$this$g4, (String)"<this>");
        return $this$g4.readInt();
    }

    @NotNull
    public static final ByteBuf p4(@NotNull ByteBuf $this$p4, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$p4, (String)"<this>");
        ByteBuf byteBuf = $this$p4.writeInt(value);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"writeInt(...)");
        return byteBuf;
    }

    public static final int g4Alt1(@NotNull ByteBuf $this$g4Alt1) {
        Intrinsics.checkNotNullParameter((Object)$this$g4Alt1, (String)"<this>");
        return $this$g4Alt1.readIntLE();
    }

    @NotNull
    public static final ByteBuf p4Alt1(@NotNull ByteBuf $this$p4Alt1, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$p4Alt1, (String)"<this>");
        ByteBuf byteBuf = $this$p4Alt1.writeIntLE(value);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"writeIntLE(...)");
        return byteBuf;
    }

    public static final int g4Alt2(@NotNull ByteBuf $this$g4Alt2) {
        Intrinsics.checkNotNullParameter((Object)$this$g4Alt2, (String)"<this>");
        int value = 0;
        value |= JagexByteBufExtensionsKt.g1($this$g4Alt2) << 8;
        value |= JagexByteBufExtensionsKt.g1($this$g4Alt2);
        value |= JagexByteBufExtensionsKt.g1($this$g4Alt2) << 24;
        return value |= JagexByteBufExtensionsKt.g1($this$g4Alt2) << 16;
    }

    @NotNull
    public static final ByteBuf p4Alt2(@NotNull ByteBuf $this$p4Alt2, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$p4Alt2, (String)"<this>");
        $this$p4Alt2.writeByte(value >> 8);
        $this$p4Alt2.writeByte(value);
        $this$p4Alt2.writeByte(value >> 24);
        $this$p4Alt2.writeByte(value >> 16);
        return $this$p4Alt2;
    }

    public static final int g4Alt3(@NotNull ByteBuf $this$g4Alt3) {
        Intrinsics.checkNotNullParameter((Object)$this$g4Alt3, (String)"<this>");
        int value = 0;
        value |= JagexByteBufExtensionsKt.g1($this$g4Alt3) << 16;
        value |= JagexByteBufExtensionsKt.g1($this$g4Alt3) << 24;
        value |= JagexByteBufExtensionsKt.g1($this$g4Alt3);
        return value |= JagexByteBufExtensionsKt.g1($this$g4Alt3) << 8;
    }

    @NotNull
    public static final ByteBuf p4Alt3(@NotNull ByteBuf $this$p4Alt3, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$p4Alt3, (String)"<this>");
        $this$p4Alt3.writeByte(value >> 16);
        $this$p4Alt3.writeByte(value >> 24);
        $this$p4Alt3.writeByte(value);
        $this$p4Alt3.writeByte(value >> 8);
        return $this$p4Alt3;
    }

    public static final long g8(@NotNull ByteBuf $this$g8) {
        Intrinsics.checkNotNullParameter((Object)$this$g8, (String)"<this>");
        return $this$g8.readLong();
    }

    @NotNull
    public static final ByteBuf p8(@NotNull ByteBuf $this$p8, long value) {
        Intrinsics.checkNotNullParameter((Object)$this$p8, (String)"<this>");
        ByteBuf byteBuf = $this$p8.writeLong(value);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"writeLong(...)");
        return byteBuf;
    }

    public static final float g4f(@NotNull ByteBuf $this$g4f) {
        Intrinsics.checkNotNullParameter((Object)$this$g4f, (String)"<this>");
        return $this$g4f.readFloat();
    }

    @NotNull
    public static final ByteBuf p4f(@NotNull ByteBuf $this$p4f, float value) {
        Intrinsics.checkNotNullParameter((Object)$this$p4f, (String)"<this>");
        ByteBuf byteBuf = $this$p4f.writeFloat(value);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"writeFloat(...)");
        return byteBuf;
    }

    public static final double g8d(@NotNull ByteBuf $this$g8d) {
        Intrinsics.checkNotNullParameter((Object)$this$g8d, (String)"<this>");
        return $this$g8d.readDouble();
    }

    @NotNull
    public static final ByteBuf p8d(@NotNull ByteBuf $this$p8d, double value) {
        Intrinsics.checkNotNullParameter((Object)$this$p8d, (String)"<this>");
        ByteBuf byteBuf = $this$p8d.writeDouble(value);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"writeDouble(...)");
        return byteBuf;
    }

    public static final boolean gboolean(@NotNull ByteBuf $this$gboolean) {
        Intrinsics.checkNotNullParameter((Object)$this$gboolean, (String)"<this>");
        return (JagexByteBufExtensionsKt.g1($this$gboolean) & 1) != 0;
    }

    @NotNull
    public static final ByteBuf pboolean(@NotNull ByteBuf $this$pboolean, boolean value) {
        Intrinsics.checkNotNullParameter((Object)$this$pboolean, (String)"<this>");
        ByteBuf byteBuf = $this$pboolean.writeByte(value ? 1 : 0);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"writeByte(...)");
        return byteBuf;
    }

    @Nullable
    public static final String gjstrnull(@NotNull ByteBuf $this$gjstrnull) {
        Intrinsics.checkNotNullParameter((Object)$this$gjstrnull, (String)"<this>");
        if ($this$gjstrnull.getByte($this$gjstrnull.readerIndex()) == 0) {
            $this$gjstrnull.readerIndex($this$gjstrnull.readerIndex() + 1);
            return null;
        }
        return JagexByteBufExtensionsKt.gjstr($this$gjstrnull);
    }

    @NotNull
    public static final String gjstr(@NotNull ByteBuf $this$gjstr) {
        Intrinsics.checkNotNullParameter((Object)$this$gjstr, (String)"<this>");
        return JagexByteBufExtensionsKt.readString$default($this$gjstr, null, 1, null);
    }

    @NotNull
    public static final ByteBuf pjstr(@NotNull ByteBuf $this$pjstr, @NotNull CharSequence s, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$pjstr, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        $this$pjstr.writeCharSequence(s, charset);
        $this$pjstr.writeByte(0);
        return $this$pjstr;
    }

    public static /* synthetic */ ByteBuf pjstr$default(ByteBuf byteBuf, CharSequence charSequence, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Cp1252Charset.INSTANCE;
        }
        return JagexByteBufExtensionsKt.pjstr(byteBuf, charSequence, charset);
    }

    @NotNull
    public static final ByteBuf pjstrnull(@NotNull ByteBuf $this$pjstrnull, @Nullable CharSequence s, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$pjstrnull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        if (s != null) {
            $this$pjstrnull.writeCharSequence(s, charset);
        }
        $this$pjstrnull.writeByte(0);
        return $this$pjstrnull;
    }

    public static /* synthetic */ ByteBuf pjstrnull$default(ByteBuf byteBuf, CharSequence charSequence, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Cp1252Charset.INSTANCE;
        }
        return JagexByteBufExtensionsKt.pjstrnull(byteBuf, charSequence, charset);
    }

    @NotNull
    public static final String gjstr2(@NotNull ByteBuf $this$gjstr2) {
        Intrinsics.checkNotNullParameter((Object)$this$gjstr2, (String)"<this>");
        if ($this$gjstr2.readByte() != 0) {
            throw new IllegalStateException("Expected byte to be 0 in position 0");
        }
        return JagexByteBufExtensionsKt.gjstr($this$gjstr2);
    }

    @NotNull
    public static final ByteBuf pjstr2(@NotNull ByteBuf $this$pjstr2, @NotNull CharSequence s) {
        Intrinsics.checkNotNullParameter((Object)$this$pjstr2, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        $this$pjstr2.writeByte(0);
        JagexByteBufExtensionsKt.writeString$default($this$pjstr2, s, null, 2, null);
        return $this$pjstr2;
    }

    private static final ByteBuf writeString(ByteBuf $this$writeString, CharSequence s, Charset charset) {
        $this$writeString.writeCharSequence(s, charset);
        $this$writeString.writeByte(0);
        return $this$writeString;
    }

    static /* synthetic */ ByteBuf writeString$default(ByteBuf byteBuf, CharSequence charSequence, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Cp1252Charset.INSTANCE;
        }
        return JagexByteBufExtensionsKt.writeString(byteBuf, charSequence, charset);
    }

    private static final String readString(ByteBuf $this$readString, Charset charset) {
        int start = $this$readString.readerIndex();
        int end = $this$readString.forEachByte(ByteProcessor.FIND_NUL);
        if (!(end != -1)) {
            boolean bl = false;
            String string = "Unterminated string";
            throw new IllegalArgumentException(string.toString());
        }
        String s = $this$readString.toString(start, end - start, charset);
        $this$readString.readerIndex(end + 1);
        Intrinsics.checkNotNull((Object)s);
        return s;
    }

    static /* synthetic */ String readString$default(ByteBuf byteBuf, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Cp1252Charset.INSTANCE;
        }
        return JagexByteBufExtensionsKt.readString(byteBuf, charset);
    }

    public static final int gSmart1or2s(@NotNull ByteBuf $this$gSmart1or2s) {
        Intrinsics.checkNotNullParameter((Object)$this$gSmart1or2s, (String)"<this>");
        short peek = $this$gSmart1or2s.getUnsignedByte($this$gSmart1or2s.readerIndex());
        return peek < 128 ? JagexByteBufExtensionsKt.g1($this$gSmart1or2s) - 64 : JagexByteBufExtensionsKt.g2($this$gSmart1or2s) - 49152;
    }

    @NotNull
    public static final ByteBuf pSmart1or2s(@NotNull ByteBuf $this$pSmart1or2s, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$pSmart1or2s, (String)"<this>");
        int n = value;
        boolean bl = -64 <= n ? n < 64 : false;
        if (bl) {
            $this$pSmart1or2s.writeByte(value + 64);
        } else {
            boolean bl2 = -16384 <= n ? n < 16384 : false;
            if (bl2) {
                $this$pSmart1or2s.writeShort(0x8000 | value + 16384);
            } else {
                throw new IllegalArgumentException("Smart1or2s value out of range: " + value);
            }
        }
        return $this$pSmart1or2s;
    }

    public static final int gSmart1or2(@NotNull ByteBuf $this$gSmart1or2) {
        Intrinsics.checkNotNullParameter((Object)$this$gSmart1or2, (String)"<this>");
        short peek = $this$gSmart1or2.getUnsignedByte($this$gSmart1or2.readerIndex());
        return peek < 128 ? JagexByteBufExtensionsKt.g1($this$gSmart1or2) : JagexByteBufExtensionsKt.g2($this$gSmart1or2) - 32768;
    }

    @NotNull
    public static final ByteBuf pSmart1or2(@NotNull ByteBuf $this$pSmart1or2, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$pSmart1or2, (String)"<this>");
        int n = value;
        boolean bl = 0 <= n ? n < 128 : false;
        if (bl) {
            $this$pSmart1or2.writeByte(value);
        } else {
            boolean bl2 = 0 <= n ? n < 32768 : false;
            if (bl2) {
                $this$pSmart1or2.writeShort(0x8000 | value);
            } else {
                throw new IllegalArgumentException("Smart1or2 value out of range: " + value);
            }
        }
        return $this$pSmart1or2;
    }

    public static final int gSmart1or2null(@NotNull ByteBuf $this$gSmart1or2null) {
        Intrinsics.checkNotNullParameter((Object)$this$gSmart1or2null, (String)"<this>");
        short peek = $this$gSmart1or2null.getUnsignedByte($this$gSmart1or2null.readerIndex());
        return peek < 128 ? JagexByteBufExtensionsKt.g1($this$gSmart1or2null) - 1 : JagexByteBufExtensionsKt.g2($this$gSmart1or2null) - 32769;
    }

    @NotNull
    public static final ByteBuf pSmart1or2null(@NotNull ByteBuf $this$pSmart1or2null, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$pSmart1or2null, (String)"<this>");
        int n = value;
        boolean bl = -1 <= n ? n < 127 : false;
        if (bl) {
            $this$pSmart1or2null.writeByte(value + 1);
        } else {
            boolean bl2 = -1 <= n ? n < Short.MAX_VALUE : false;
            if (bl2) {
                $this$pSmart1or2null.writeShort(0x8000 | value + 1);
            } else {
                throw new IllegalArgumentException("Smart1or2null value out of range: " + value);
            }
        }
        return $this$pSmart1or2null;
    }

    public static final int gSmart1or2extended(@NotNull ByteBuf $this$gSmart1or2extended) {
        Intrinsics.checkNotNullParameter((Object)$this$gSmart1or2extended, (String)"<this>");
        int total = 0;
        int num = JagexByteBufExtensionsKt.gSmart1or2($this$gSmart1or2extended);
        while (num == Short.MAX_VALUE) {
            total += Short.MAX_VALUE;
            num = JagexByteBufExtensionsKt.gSmart1or2($this$gSmart1or2extended);
        }
        return total += num;
    }

    @NotNull
    public static final ByteBuf pSmart1or2extended(@NotNull ByteBuf $this$pSmart1or2extended, int value) {
        int remaining;
        Intrinsics.checkNotNullParameter((Object)$this$pSmart1or2extended, (String)"<this>");
        for (remaining = value; remaining >= Short.MAX_VALUE; remaining -= Short.MAX_VALUE) {
            JagexByteBufExtensionsKt.pSmart1or2($this$pSmart1or2extended, Short.MAX_VALUE);
        }
        JagexByteBufExtensionsKt.pSmart1or2($this$pSmart1or2extended, remaining);
        return $this$pSmart1or2extended;
    }

    public static final int gSmart2or4(@NotNull ByteBuf $this$gSmart2or4) {
        Intrinsics.checkNotNullParameter((Object)$this$gSmart2or4, (String)"<this>");
        byte peek = $this$gSmart2or4.getByte($this$gSmart2or4.readerIndex());
        return peek < 0 ? JagexByteBufExtensionsKt.g4($this$gSmart2or4) & Integer.MAX_VALUE : JagexByteBufExtensionsKt.g2($this$gSmart2or4);
    }

    @NotNull
    public static final ByteBuf pSmart2or4(@NotNull ByteBuf $this$pSmart2or4, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$pSmart2or4, (String)"<this>");
        int n = value;
        boolean bl = 0 <= n ? n < 32768 : false;
        if (bl) {
            $this$pSmart2or4.writeShort(value);
        } else {
            boolean bl2 = 0 <= n ? n <= Integer.MAX_VALUE : false;
            if (bl2) {
                $this$pSmart2or4.writeInt(Integer.MIN_VALUE | value);
            } else {
                throw new IllegalArgumentException("Smart2or4 value out of range: " + value);
            }
        }
        return $this$pSmart2or4;
    }

    /*
     * WARNING - void declaration
     */
    public static final int gSmart2or4null(@NotNull ByteBuf $this$gSmart2or4null) {
        void var2_2;
        int num;
        Intrinsics.checkNotNullParameter((Object)$this$gSmart2or4null, (String)"<this>");
        byte peek = $this$gSmart2or4null.getByte($this$gSmart2or4null.readerIndex());
        return peek < 0 ? JagexByteBufExtensionsKt.g4($this$gSmart2or4null) & Integer.MAX_VALUE : ((num = JagexByteBufExtensionsKt.g2($this$gSmart2or4null)) == Short.MAX_VALUE ? -1 : var2_2);
    }

    @NotNull
    public static final ByteBuf pSmart2or4null(@NotNull ByteBuf $this$pSmart2or4null, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$pSmart2or4null, (String)"<this>");
        if (!(-1 <= value ? value < Integer.MAX_VALUE : false)) {
            throw new IllegalArgumentException("Smart2or4null value out of range: " + value);
        }
        if (value == -1) {
            $this$pSmart2or4null.writeShort(Short.MAX_VALUE);
        } else if (value < Short.MAX_VALUE) {
            $this$pSmart2or4null.writeShort(value);
        } else {
            $this$pSmart2or4null.writeInt(value);
            byte writtenValue = $this$pSmart2or4null.getByte($this$pSmart2or4null.writerIndex() - 4);
            $this$pSmart2or4null.setByte($this$pSmart2or4null.writerIndex() - 4, writtenValue + 128);
        }
        return $this$pSmart2or4null;
    }

    public static final int gVarInt(@NotNull ByteBuf $this$gVarInt) {
        Intrinsics.checkNotNullParameter((Object)$this$gVarInt, (String)"<this>");
        int value = 0;
        short s = 0;
        do {
            s = $this$gVarInt.readUnsignedByte();
            value = value << 7 | s & 0x7F;
        } while ((s & 0x80) != 0);
        return value;
    }

    @NotNull
    public static final ByteBuf pVarInt(@NotNull ByteBuf $this$pVarInt, int v) {
        Intrinsics.checkNotNullParameter((Object)$this$pVarInt, (String)"<this>");
        if ((v & 0xFFFFFF80) != 0) {
            if ((v & 0xFFFFC000) != 0) {
                if ((v & 0xFFE00000) != 0) {
                    if ((v & 0xF0000000) != 0) {
                        $this$pVarInt.writeByte(v >>> 28 & 0x7F | 0x80);
                    }
                    $this$pVarInt.writeByte(v >>> 21 & 0x7F | 0x80);
                }
                $this$pVarInt.writeByte(v >>> 14 & 0x7F | 0x80);
            }
            $this$pVarInt.writeByte(v >>> 7 & 0x7F | 0x80);
        }
        $this$pVarInt.writeByte(v & 0x7F);
        return $this$pVarInt;
    }

    public static final int gVarInt2(@NotNull ByteBuf $this$gVarInt2) {
        int temp;
        Intrinsics.checkNotNullParameter((Object)$this$gVarInt2, (String)"<this>");
        int value = 0;
        int bits = 0;
        do {
            temp = JagexByteBufExtensionsKt.g1($this$gVarInt2);
            value |= (temp & 0x7F) << bits;
            bits += 7;
        } while (temp > 127);
        return value;
    }

    public static final int gVarInt2s(@NotNull ByteBuf $this$gVarInt2s) {
        Intrinsics.checkNotNullParameter((Object)$this$gVarInt2s, (String)"<this>");
        int unsigned = JagexByteBufExtensionsKt.gVarInt2($this$gVarInt2s);
        return unsigned >>> 1 ^ -(unsigned & 1);
    }

    @NotNull
    public static final ByteBuf pVarInt2(@NotNull ByteBuf $this$pVarInt2, int value) {
        int remaining;
        Intrinsics.checkNotNullParameter((Object)$this$pVarInt2, (String)"<this>");
        for (remaining = value; remaining < 0 || remaining > 127; remaining >>>= 7) {
            JagexByteBufExtensionsKt.p1($this$pVarInt2, 0x80 | remaining & 0x7F);
        }
        JagexByteBufExtensionsKt.p1($this$pVarInt2, remaining);
        return $this$pVarInt2;
    }

    @NotNull
    public static final ByteBuf pVarInt2s(@NotNull ByteBuf $this$pVarInt2s, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$pVarInt2s, (String)"<this>");
        int signed = value << 1 ^ value >> 31;
        JagexByteBufExtensionsKt.pVarInt2($this$pVarInt2s, signed);
        return $this$pVarInt2s;
    }

    public static final void gdata(@NotNull ByteBuf $this$gdata, @NotNull byte[] dest, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$gdata, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            dest[i] = $this$gdata.readByte();
        }
    }

    public static /* synthetic */ void gdata$default(ByteBuf byteBuf, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        JagexByteBufExtensionsKt.gdata(byteBuf, byArray, n, n2);
    }

    public static final void gdata(@NotNull ByteBuf $this$gdata, @NotNull ByteBuf dest, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$gdata, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        dest.writeBytes($this$gdata, offset, length);
    }

    public static /* synthetic */ void gdata$default(ByteBuf byteBuf, ByteBuf byteBuf2, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = byteBuf.readerIndex();
        }
        if ((n3 & 4) != 0) {
            n2 = byteBuf.readableBytes();
        }
        JagexByteBufExtensionsKt.gdata(byteBuf, byteBuf2, n, n2);
    }

    @NotNull
    public static final ByteBuf pdata(@NotNull ByteBuf $this$pdata, @NotNull byte[] src, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$pdata, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        int n = length + offset;
        for (int i = offset; i < n; ++i) {
            $this$pdata.writeByte((int)src[i]);
        }
        return $this$pdata;
    }

    public static /* synthetic */ ByteBuf pdata$default(ByteBuf byteBuf, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return JagexByteBufExtensionsKt.pdata(byteBuf, byArray, n, n2);
    }

    @NotNull
    public static final ByteBuf pdata(@NotNull ByteBuf $this$pdata, @NotNull ByteBuf src, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$pdata, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        int n = length + offset;
        for (int i = offset; i < n; ++i) {
            $this$pdata.writeByte((int)src.getByte(i));
        }
        return $this$pdata;
    }

    public static /* synthetic */ ByteBuf pdata$default(ByteBuf byteBuf, ByteBuf byteBuf2, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = byteBuf2.readerIndex();
        }
        if ((n3 & 4) != 0) {
            n2 = byteBuf2.readableBytes();
        }
        return JagexByteBufExtensionsKt.pdata(byteBuf, byteBuf2, n, n2);
    }

    public static final void gdataAlt1(@NotNull ByteBuf $this$gdataAlt1, @NotNull byte[] dest, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$gdataAlt1, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int i = offset + length - 1;
        if (offset <= i) {
            while (true) {
                dest[i] = $this$gdataAlt1.readByte();
                if (i == offset) break;
                --i;
            }
        }
    }

    public static /* synthetic */ void gdataAlt1$default(ByteBuf byteBuf, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        JagexByteBufExtensionsKt.gdataAlt1(byteBuf, byArray, n, n2);
    }

    public static final void gdataAlt1(@NotNull ByteBuf $this$gdataAlt1, @NotNull ByteBuf dest, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$gdataAlt1, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int i = offset + length - 1;
        if (offset <= i) {
            while (true) {
                dest.writeByte((int)$this$gdataAlt1.readByte());
                if (i == offset) break;
                --i;
            }
        }
    }

    public static /* synthetic */ void gdataAlt1$default(ByteBuf byteBuf, ByteBuf byteBuf2, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = byteBuf.readerIndex();
        }
        if ((n3 & 4) != 0) {
            n2 = byteBuf.readableBytes();
        }
        JagexByteBufExtensionsKt.gdataAlt1(byteBuf, byteBuf2, n, n2);
    }

    @NotNull
    public static final ByteBuf pdataAlt1(@NotNull ByteBuf $this$pdataAlt1, @NotNull byte[] data, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$pdataAlt1, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int i = offset + length - 1;
        if (offset <= i) {
            while (true) {
                $this$pdataAlt1.writeByte((int)data[i]);
                if (i == offset) break;
                --i;
            }
        }
        return $this$pdataAlt1;
    }

    public static /* synthetic */ ByteBuf pdataAlt1$default(ByteBuf byteBuf, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return JagexByteBufExtensionsKt.pdataAlt1(byteBuf, byArray, n, n2);
    }

    @NotNull
    public static final ByteBuf pdataAlt1(@NotNull ByteBuf $this$pdataAlt1, @NotNull ByteBuf data, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$pdataAlt1, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int i = offset + length - 1;
        if (offset <= i) {
            while (true) {
                $this$pdataAlt1.writeByte((int)data.getByte(i));
                if (i == offset) break;
                --i;
            }
        }
        return $this$pdataAlt1;
    }

    public static /* synthetic */ ByteBuf pdataAlt1$default(ByteBuf byteBuf, ByteBuf byteBuf2, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = byteBuf2.readerIndex();
        }
        if ((n3 & 4) != 0) {
            n2 = byteBuf2.readableBytes();
        }
        return JagexByteBufExtensionsKt.pdataAlt1(byteBuf, byteBuf2, n, n2);
    }

    public static final void gdataAlt2(@NotNull ByteBuf $this$gdataAlt2, @NotNull byte[] dest, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$gdataAlt2, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            dest[i] = (byte)($this$gdataAlt2.readUnsignedByte() - 128);
        }
    }

    public static /* synthetic */ void gdataAlt2$default(ByteBuf byteBuf, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        JagexByteBufExtensionsKt.gdataAlt2(byteBuf, byArray, n, n2);
    }

    public static final void gdataAlt2(@NotNull ByteBuf $this$gdataAlt2, @NotNull ByteBuf dest, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$gdataAlt2, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            dest.writeByte($this$gdataAlt2.readUnsignedByte() - 128);
        }
    }

    public static /* synthetic */ void gdataAlt2$default(ByteBuf byteBuf, ByteBuf byteBuf2, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = byteBuf.readerIndex();
        }
        if ((n3 & 4) != 0) {
            n2 = byteBuf.readableBytes();
        }
        JagexByteBufExtensionsKt.gdataAlt2(byteBuf, byteBuf2, n, n2);
    }

    @NotNull
    public static final ByteBuf pdataAlt2(@NotNull ByteBuf $this$pdataAlt2, @NotNull byte[] data, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$pdataAlt2, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            $this$pdataAlt2.writeByte(data[i] + 128);
        }
        return $this$pdataAlt2;
    }

    public static /* synthetic */ ByteBuf pdataAlt2$default(ByteBuf byteBuf, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return JagexByteBufExtensionsKt.pdataAlt2(byteBuf, byArray, n, n2);
    }

    @NotNull
    public static final ByteBuf pdataAlt2(@NotNull ByteBuf $this$pdataAlt2, @NotNull ByteBuf data, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$pdataAlt2, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            $this$pdataAlt2.writeByte(data.getByte(i) + 128);
        }
        return $this$pdataAlt2;
    }

    public static /* synthetic */ ByteBuf pdataAlt2$default(ByteBuf byteBuf, ByteBuf byteBuf2, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = byteBuf2.readerIndex();
        }
        if ((n3 & 4) != 0) {
            n2 = byteBuf2.readableBytes();
        }
        return JagexByteBufExtensionsKt.pdataAlt2(byteBuf, byteBuf2, n, n2);
    }

    public static final void gdataAlt3(@NotNull ByteBuf $this$gdataAlt3, @NotNull byte[] dest, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$gdataAlt3, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int i = offset + length - 1;
        if (offset <= i) {
            while (true) {
                dest[i] = (byte)($this$gdataAlt3.readUnsignedByte() - 128);
                if (i == offset) break;
                --i;
            }
        }
    }

    public static /* synthetic */ void gdataAlt3$default(ByteBuf byteBuf, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        JagexByteBufExtensionsKt.gdataAlt3(byteBuf, byArray, n, n2);
    }

    public static final void gdataAlt3(@NotNull ByteBuf $this$gdataAlt3, @NotNull ByteBuf dest, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$gdataAlt3, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        int i = offset + length - 1;
        if (offset <= i) {
            while (true) {
                dest.writeByte($this$gdataAlt3.readUnsignedByte() - 128);
                if (i == offset) break;
                --i;
            }
        }
    }

    public static /* synthetic */ void gdataAlt3$default(ByteBuf byteBuf, ByteBuf byteBuf2, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = byteBuf.readerIndex();
        }
        if ((n3 & 4) != 0) {
            n2 = byteBuf.readableBytes();
        }
        JagexByteBufExtensionsKt.gdataAlt3(byteBuf, byteBuf2, n, n2);
    }

    @NotNull
    public static final ByteBuf pdataAlt3(@NotNull ByteBuf $this$pdataAlt3, @NotNull byte[] data, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$pdataAlt3, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int i = offset + length - 1;
        if (offset <= i) {
            while (true) {
                $this$pdataAlt3.writeByte(data[i] + 128);
                if (i == offset) break;
                --i;
            }
        }
        return $this$pdataAlt3;
    }

    public static /* synthetic */ ByteBuf pdataAlt3$default(ByteBuf byteBuf, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return JagexByteBufExtensionsKt.pdataAlt3(byteBuf, byArray, n, n2);
    }

    @NotNull
    public static final ByteBuf pdataAlt3(@NotNull ByteBuf $this$pdataAlt3, @NotNull ByteBuf data, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)$this$pdataAlt3, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        int i = offset + length - 1;
        if (offset <= i) {
            while (true) {
                $this$pdataAlt3.writeByte(data.getByte(i) + 128);
                if (i == offset) break;
                --i;
            }
        }
        return $this$pdataAlt3;
    }

    public static /* synthetic */ ByteBuf pdataAlt3$default(ByteBuf byteBuf, ByteBuf byteBuf2, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = byteBuf2.readerIndex();
        }
        if ((n3 & 4) != 0) {
            n2 = byteBuf2.readableBytes();
        }
        return JagexByteBufExtensionsKt.pdataAlt3(byteBuf, byteBuf2, n, n2);
    }

    @NotNull
    public static final ByteBuf toJagByteBuf(@NotNull ByteBuf $this$toJagByteBuf) {
        Intrinsics.checkNotNullParameter((Object)$this$toJagByteBuf, (String)"<this>");
        return JagByteBuf.constructor-impl($this$toJagByteBuf);
    }

    public static final int addCRC32(@NotNull ByteBuf $this$addCRC32, int startIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$addCRC32, (String)"<this>");
        int checksum = CyclicRedundancyCheck.INSTANCE.computeCrc32($this$addCRC32, startIndex, $this$addCRC32.writerIndex());
        JagexByteBufExtensionsKt.p4($this$addCRC32, checksum);
        return checksum;
    }

    public static final boolean checkCRC32(@NotNull ByteBuf $this$checkCRC32) {
        Intrinsics.checkNotNullParameter((Object)$this$checkCRC32, (String)"<this>");
        int length = $this$checkCRC32.readerIndex();
        $this$checkCRC32.readerIndex(length - 4);
        int checksum = CyclicRedundancyCheck.INSTANCE.computeCrc32($this$checkCRC32, 0, length - 4);
        return checksum == JagexByteBufExtensionsKt.g4($this$checkCRC32);
    }
}

