/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.buffer.bitbuffer;

import com.github.michaelbull.logging.InlineLogger;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.SystemPropertyUtil;
import java.lang.invoke.MethodHandles;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.buffer.bitbuffer.UnsafeLongBackedBitBuf;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 %2\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\bH\u0084\bJ\u0006\u0010\u0012\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\bJ\u0006\u0010\u0014\u001a\u00020\u0000J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH&J\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\bJ\u0006\u0010\u001b\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\bJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010 \u001a\u00020\bH&J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\"H&J\u0006\u0010#\u001a\u00020\bJ\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\bJ\u0006\u0010\r\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010$\u001a\u00020\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\f\u00a8\u0006\u0002"}, d2={"Lnet/rsprot/buffer/bitbuffer/BitBuf;", "Ljava/lang/AutoCloseable;", "buffer", "Lio/netty/buffer/ByteBuf;", "(Lio/netty/buffer/ByteBuf;)V", "getBuffer", "()Lio/netty/buffer/ByteBuf;", "readerIndex", "", "getReaderIndex", "()I", "setReaderIndex", "(I)V", "writerIndex", "getWriterIndex", "setWriterIndex", "bitmask", "pos", "capacity", "bitCount", "clear", "close", "", "gBits", "count", "isReadable", "", "isWritable", "len", "maxCapacity", "", "pBits", "value", "src", "Lnet/rsprot/buffer/bitbuffer/UnsafeLongBackedBitBuf;", "readableBits", "index", "Companion"})
@SourceDebugExtension(value={"SMAP\nBitBuf.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitBuf.kt\nnet/rsprot/buffer/bitbuffer/BitBuf\n+ 2 BitBuf.kt\nnet/rsprot/buffer/bitbuffer/BitBuf$Companion\n+ 3 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLoggerKt\n+ 4 InlineLogger.kt\ncom/github/michaelbull/logging/InlineLogger\n*L\n1#1,151:1\n127#2,14:152\n127#2,14:166\n11#3,2:180\n56#4,4:182\n*S KotlinDebug\n*F\n+ 1 BitBuf.kt\nnet/rsprot/buffer/bitbuffer/BitBuf\n*L\n46#1:152,14\n59#1:166,14\n112#1:180,2\n120#1:182,4\n*E\n"})
public abstract class BitBuf
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ByteBuf buffer;
    private int writerIndex;
    private int readerIndex;
    public static final int LOG_BITS_PER_BYTE = 3;
    public static final int BYTE_SIZE_BITS = 8;
    public static final int MASK_BITS_PER_BYTE = 7;
    public static final int MAX_BITS = 32;
    @NotNull
    private static final Logger logger;
    private static final boolean errorChecking;

    public BitBuf(@NotNull ByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.buffer = buffer;
        this.writerIndex = this.buffer.writerIndex() << 3;
        this.readerIndex = this.buffer.readerIndex() << 3;
    }

    @NotNull
    protected final ByteBuf getBuffer() {
        return this.buffer;
    }

    protected final int getWriterIndex() {
        return this.writerIndex;
    }

    protected final void setWriterIndex(int n) {
        this.writerIndex = n;
    }

    protected final int getReaderIndex() {
        return this.readerIndex;
    }

    protected final void setReaderIndex(int n) {
        this.readerIndex = n;
    }

    protected final int bitmask(int pos) {
        boolean $i$f$bitmask = false;
        return (1 << pos) - 1;
    }

    public abstract void pBits(int var1, int var2);

    public abstract void pBits(@NotNull UnsafeLongBackedBitBuf var1);

    public abstract int gBits(int var1);

    public final int capacity() {
        return this.buffer.capacity() << 3;
    }

    @NotNull
    public final BitBuf capacity(int bitCount) {
        this.buffer.capacity(bitCount + 7 >>> 3);
        return this;
    }

    public final long maxCapacity() {
        return (long)this.buffer.maxCapacity() << 3;
    }

    public final boolean isReadable() {
        return this.readerIndex < this.writerIndex;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isReadable(int count) {
        void this_$iv;
        Companion companion = Companion;
        boolean value$iv = count >= 0;
        boolean $i$f$req = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$req2 = false;
        if (this_$iv$iv.getErrorChecking() && !value$iv) {
            boolean bl = false;
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.readerIndex + count <= this.writerIndex;
    }

    public final int readableBits() {
        return this.writerIndex - this.readerIndex;
    }

    public final boolean isWritable() {
        return this.writerIndex < this.capacity();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isWritable(int len) {
        void this_$iv;
        Companion companion = Companion;
        boolean value$iv = len >= 0;
        boolean $i$f$req = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$req2 = false;
        if (this_$iv$iv.getErrorChecking() && !value$iv) {
            boolean bl = false;
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return this.writerIndex + len <= this.capacity();
    }

    public final int readerIndex() {
        return this.readerIndex;
    }

    @NotNull
    public final BitBuf readerIndex(int index) {
        if (errorChecking && (index < 0 || index > this.writerIndex)) {
            throw new IndexOutOfBoundsException();
        }
        this.readerIndex = index;
        return this;
    }

    public final int writerIndex() {
        return this.writerIndex;
    }

    @NotNull
    public final BitBuf writerIndex(int index) {
        if (errorChecking && (index < this.readerIndex || index > this.capacity())) {
            throw new IndexOutOfBoundsException();
        }
        this.writerIndex = index;
        return this;
    }

    @NotNull
    public final BitBuf clear() {
        this.readerIndex = 0;
        this.writerIndex = 0;
        return this;
    }

    @Override
    public void close() {
        int bits = (this.writerIndex + 7 & 0xFFFFFFF8) - this.writerIndex;
        if (bits != 0) {
            this.pBits(bits, 0);
        }
        this.readerIndex = this.readerIndex + 7 & 0xFFFFFFF8;
        this.buffer.writerIndex(this.writerIndex >>> 3);
        this.buffer.readerIndex(this.readerIndex >>> 3);
    }

    @JvmStatic
    protected static final void req(boolean value) {
        Companion.req(value);
    }

    @JvmStatic
    protected static final void req(boolean value, @NotNull Function0<? extends Object> lazyMessage) {
        Companion.req(value, lazyMessage);
    }

    static {
        boolean $i$f$InlineLogger = false;
        Logger delegate$iv = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        Intrinsics.checkNotNull((Object)delegate$iv);
        logger = InlineLogger.constructor-impl((Logger)delegate$iv);
        errorChecking = SystemPropertyUtil.getBoolean((String)"net.rsprot.buffer.bitbufferErrorChecking", (boolean)true);
        Logger arg0$iv = logger;
        boolean bl = false;
        if (InlineLogger.isDebugEnabled-impl((Logger)arg0$iv)) {
            Logger logger = arg0$iv;
            boolean bl2 = false;
            logger.debug(String.valueOf("-Dnet.rsprot.buffer.bitbufferErrorChecking: " + errorChecking));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\tH\u0085\bJ$\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u000e\b\u0004\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0013H\u0085\b\u00f8\u0001\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u00020\rX\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\u000e\u0082\u0002\u0012\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\n\u0005\b\u009920\u0001\u00a8\u0006\u0014"}, d2={"Lnet/rsprot/buffer/bitbuffer/BitBuf$Companion;", "", "()V", "BYTE_SIZE_BITS", "", "LOG_BITS_PER_BYTE", "MASK_BITS_PER_BYTE", "MAX_BITS", "errorChecking", "", "getErrorChecking", "()Z", "logger", "Lcom/github/michaelbull/logging/InlineLogger;", "Lorg/slf4j/Logger;", "req", "", "value", "lazyMessage", "Lkotlin/Function0;", "buffer"})
    @SourceDebugExtension(value={"SMAP\nBitBuf.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitBuf.kt\nnet/rsprot/buffer/bitbuffer/BitBuf$Companion\n*L\n1#1,151:1\n137#1,4:152\n*S KotlinDebug\n*F\n+ 1 BitBuf.kt\nnet/rsprot/buffer/bitbuffer/BitBuf$Companion\n*L\n127#1:152,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getErrorChecking() {
            return errorChecking;
        }

        @JvmStatic
        protected final void req(boolean value) {
            boolean $i$f$req = false;
            Companion this_$iv = this;
            boolean $i$f$req2 = false;
            if (this_$iv.getErrorChecking() && !value) {
                boolean bl = false;
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @JvmStatic
        protected final void req(boolean value, @NotNull Function0<? extends Object> lazyMessage) {
            Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
            boolean $i$f$req = false;
            if (this.getErrorChecking() && !value) {
                Object object = lazyMessage.invoke();
                throw new IllegalArgumentException(object.toString());
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

