/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.buffer.bitbuffer;

import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.buffer.bitbuffer.BitBuf;
import net.rsprot.buffer.bitbuffer.UnsafeLongBackedBitBuf;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000eH\u0002\u00a8\u0006\u0002"}, d2={"Lnet/rsprot/buffer/bitbuffer/WrappedBitBuf;", "Lnet/rsprot/buffer/bitbuffer/BitBuf;", "buffer", "Lio/netty/buffer/ByteBuf;", "(Lio/netty/buffer/ByteBuf;)V", "gBits", "", "count", "pBits", "", "value", "src", "Lnet/rsprot/buffer/bitbuffer/UnsafeLongBackedBitBuf;", "pBitsUnsafe", ""})
@SourceDebugExtension(value={"SMAP\nWrappedBitBuf.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WrappedBitBuf.kt\nnet/rsprot/buffer/bitbuffer/WrappedBitBuf\n+ 2 BitBuf.kt\nnet/rsprot/buffer/bitbuffer/BitBuf$Companion\n+ 3 BitBuf.kt\nnet/rsprot/buffer/bitbuffer/BitBuf\n*L\n1#1,102:1\n137#2,4:103\n137#2,4:107\n127#2,14:111\n127#2,14:131\n137#2,4:145\n127#2,14:149\n16#3:125\n16#3:126\n16#3:127\n16#3:128\n16#3:129\n16#3:130\n16#3:163\n16#3:164\n*S KotlinDebug\n*F\n+ 1 WrappedBitBuf.kt\nnet/rsprot/buffer/bitbuffer/WrappedBitBuf\n*L\n11#1:103,4\n20#1:107,4\n23#1:111,14\n77#1:131,14\n82#1:145,4\n85#1:149,14\n37#1:125\n39#1:126\n44#1:127\n61#1:128\n63#1:129\n68#1:130\n93#1:163\n97#1:164\n*E\n"})
public final class WrappedBitBuf
extends BitBuf {
    /*
     * WARNING - void declaration
     */
    public WrappedBitBuf(@NotNull ByteBuf buffer) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super(buffer);
        BitBuf.Companion companion = BitBuf.Companion;
        boolean value$iv = buffer.capacity() <= 0xFFFFFFF;
        boolean $i$f$req = false;
        if (this_$iv.getErrorChecking() && !value$iv) {
            boolean bl = false;
            String string = "This bitbuffer cannot work with buffers greater than 268,435,455 bytes in capacity.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void pBits(int count, int value) {
        BitBuf.Companion this_$iv;
        BitBuf.Companion companion = BitBuf.Companion;
        boolean value$iv = 1 <= count ? count < 33 : false;
        boolean $i$f$req = false;
        if (this_$iv.getErrorChecking() && !value$iv) {
            boolean $i$a$-req-WrappedBitBuf$pBits$22 = false;
            String $i$a$-req-WrappedBitBuf$pBits$22 = "Number of bits must be in 1..32";
            throw new IllegalArgumentException($i$a$-req-WrappedBitBuf$pBits$22.toString());
        }
        this_$iv = BitBuf.Companion;
        value$iv = this.isWritable(count);
        $i$f$req = false;
        BitBuf.Companion this_$iv$iv = this_$iv;
        boolean $i$f$req2 = false;
        if (this_$iv$iv.getErrorChecking() && !value$iv) {
            boolean bl = false;
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.pBitsUnsafe(count, value);
    }

    private final void pBitsUnsafe(int count, int value) {
        boolean $i$f$bitmask;
        BitBuf this_$iv;
        int rem;
        int index = this.getWriterIndex();
        int bytePos = index >>> 3;
        int bitPos = 8 - (index & 7);
        this.setWriterIndex(this.getWriterIndex() + count);
        for (rem = count; rem > bitPos; rem -= bitPos) {
            BitBuf this_$iv2 = this;
            boolean $i$f$bitmask2 = false;
            int ending = value >>> rem - bitPos & (1 << bitPos) - 1;
            byte by = this.getBuffer().getByte(bytePos);
            int n = bytePos++;
            this_$iv = this;
            $i$f$bitmask = false;
            this.getBuffer().setByte(n, by & ~((1 << bitPos) - 1) | ending);
            bitPos = 8;
        }
        byte cur = this.getBuffer().getByte(bytePos);
        this_$iv = this;
        $i$f$bitmask = false;
        int mask = (1 << rem) - 1;
        int offset = bitPos - rem;
        int sanitized = cur & ~(mask << offset);
        int addition = (value & mask) << offset;
        this.getBuffer().setByte(bytePos, sanitized | addition);
    }

    private final void pBitsUnsafe(int count, long value) {
        boolean $i$f$bitmask;
        BitBuf this_$iv;
        int rem;
        int index = this.getWriterIndex();
        int bytePos = index >>> 3;
        int bitPos = 8 - (index & 7);
        this.setWriterIndex(this.getWriterIndex() + count);
        for (rem = count; rem > bitPos; rem -= bitPos) {
            BitBuf this_$iv2 = this;
            boolean $i$f$bitmask2 = false;
            int ending = (int)(value >>> rem - bitPos) & (1 << bitPos) - 1;
            byte by = this.getBuffer().getByte(bytePos);
            int n = bytePos++;
            this_$iv = this;
            $i$f$bitmask = false;
            this.getBuffer().setByte(n, by & ~((1 << bitPos) - 1) | ending);
            bitPos = 8;
        }
        byte cur = this.getBuffer().getByte(bytePos);
        this_$iv = this;
        $i$f$bitmask = false;
        int mask = (1 << rem) - 1;
        int offset = bitPos - rem;
        int sanitized = cur & ~(mask << offset);
        int addition = ((int)value & mask) << offset;
        this.getBuffer().setByte(bytePos, sanitized | addition);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void pBits(@NotNull UnsafeLongBackedBitBuf src) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        int count = src.readableBits();
        BitBuf.Companion companion = BitBuf.Companion;
        boolean value$iv = this.isWritable(count);
        boolean $i$f$req = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$req2 = false;
        if (this_$iv$iv.getErrorChecking() && !value$iv) {
            boolean bl = false;
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.pBitsUnsafe(count, src.gBitsLong(src.readerIndex(), src.readableBits()));
    }

    @Override
    public int gBits(int count) {
        boolean $i$f$bitmask;
        BitBuf this_$iv;
        int remaining;
        BitBuf.Companion this_$iv2;
        BitBuf.Companion companion = BitBuf.Companion;
        boolean value$iv = 1 <= count ? count < 33 : false;
        boolean $i$f$req = false;
        if (this_$iv2.getErrorChecking() && !value$iv) {
            boolean $i$a$-req-WrappedBitBuf$gBits$22 = false;
            String $i$a$-req-WrappedBitBuf$gBits$22 = "Number of bits must be in 1..32";
            throw new IllegalArgumentException($i$a$-req-WrappedBitBuf$gBits$22.toString());
        }
        this_$iv2 = BitBuf.Companion;
        value$iv = this.isReadable(count);
        $i$f$req = false;
        BitBuf.Companion this_$iv$iv = this_$iv2;
        boolean $i$f$req2 = false;
        if (this_$iv$iv.getErrorChecking() && !value$iv) {
            boolean $i$a$-req-BitBuf$Companion$req$1$iv22 = false;
            String $i$a$-req-BitBuf$Companion$req$1$iv22 = "Failed requirement.";
            throw new IllegalArgumentException($i$a$-req-BitBuf$Companion$req$1$iv22.toString());
        }
        int bytePos = this.getReaderIndex() >> 3;
        int bitPos = 8 - (this.getReaderIndex() & 7);
        int value = 0;
        this.setReaderIndex(this.getReaderIndex() + remaining);
        for (remaining = count; remaining > bitPos; remaining -= bitPos) {
            short s = this.getBuffer().getUnsignedByte(bytePos++);
            this_$iv = this;
            $i$f$bitmask = false;
            value += (s & (1 << bitPos) - 1) << remaining - bitPos;
            bitPos = 8;
        }
        this_$iv = this;
        $i$f$bitmask = false;
        int bitmask = (1 << remaining) - 1;
        short cur = this.getBuffer().getUnsignedByte(bytePos);
        return value + (cur >>> bitPos - remaining & bitmask);
    }
}

