/*
 * Decompiled with CFR 0.152.
 */
package net.rsprot.buffer.bitbuffer;

import io.netty.buffer.ByteBuf;
import io.netty.util.internal.shaded.org.jctools.util.UnsafeAccess;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rsprot.buffer.bitbuffer.BitBuf;
import net.rsprot.buffer.bitbuffer.UnsafeLongBackedBitBuf;
import org.jetbrains.annotations.NotNull;
import sun.misc.Unsafe;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0016J\u0011\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0082\bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0002J\u0018\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u0019\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0082\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0002"}, d2={"Lnet/rsprot/buffer/bitbuffer/UnsafeBitBuf;", "Lnet/rsprot/buffer/bitbuffer/BitBuf;", "buffer", "Lio/netty/buffer/ByteBuf;", "(Lio/netty/buffer/ByteBuf;)V", "address", "", "capacity", "", "getCapacity", "()I", "maxCapacity", "getMaxCapacity", "gBits", "count", "get", "idx", "pBits", "", "value", "src", "Lnet/rsprot/buffer/bitbuffer/UnsafeLongBackedBitBuf;", "pBitsUnsafe", "set", "i", "Companion"})
@SourceDebugExtension(value={"SMAP\nUnsafeBitBuf.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsafeBitBuf.kt\nnet/rsprot/buffer/bitbuffer/UnsafeBitBuf\n+ 2 BitBuf.kt\nnet/rsprot/buffer/bitbuffer/BitBuf$Companion\n+ 3 BitBuf.kt\nnet/rsprot/buffer/bitbuffer/BitBuf\n*L\n1#1,117:1\n24#1:137\n20#1,2:139\n24#1:141\n20#1,2:143\n24#1:146\n20#1,2:148\n24#1:150\n20#1,2:152\n24#1:186\n24#1:189\n137#2,4:118\n127#2,14:122\n127#2,14:154\n137#2,4:168\n127#2,14:172\n16#3:136\n16#3:138\n16#3:142\n16#3:145\n16#3:147\n16#3:151\n16#3:187\n16#3:188\n*S KotlinDebug\n*F\n+ 1 UnsafeBitBuf.kt\nnet/rsprot/buffer/bitbuffer/UnsafeBitBuf\n*L\n49#1:137\n50#1:139,2\n54#1:141\n59#1:143,2\n73#1:146\n74#1:148,2\n78#1:150\n83#1:152,2\n103#1:186\n109#1:189\n31#1:118,4\n34#1:122,14\n88#1:154,14\n93#1:168,4\n96#1:172,14\n48#1:136\n50#1:138\n55#1:142\n72#1:145\n74#1:147\n79#1:151\n104#1:187\n108#1:188\n*E\n"})
public final class UnsafeBitBuf
extends BitBuf {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final long address;
    private static final Unsafe unsafe = UnsafeAccess.UNSAFE;

    public UnsafeBitBuf(@NotNull ByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super(buffer);
        this.address = buffer.memoryAddress();
    }

    private final int getMaxCapacity() {
        return this.getBuffer().maxCapacity();
    }

    private final int getCapacity() {
        return this.getBuffer().capacity();
    }

    private final void set(int i, int value) {
        boolean $i$f$set = false;
        unsafe.putByte(this.address + (long)i, (byte)value);
    }

    private final int get(int idx) {
        boolean $i$f$get = false;
        return unsafe.getByte(this.address + (long)idx);
    }

    @Override
    public void pBits(int count, int value) {
        BitBuf.Companion this_$iv;
        BitBuf.Companion companion = BitBuf.Companion;
        boolean value$iv = 1 <= count ? count < 33 : false;
        boolean $i$f$req = false;
        if (this_$iv.getErrorChecking() && !value$iv) {
            boolean $i$a$-req-UnsafeBitBuf$pBits$22 = false;
            String $i$a$-req-UnsafeBitBuf$pBits$22 = "Number of bits must be in 1..32";
            throw new IllegalArgumentException($i$a$-req-UnsafeBitBuf$pBits$22.toString());
        }
        this_$iv = BitBuf.Companion;
        value$iv = this.isWritable(count);
        $i$f$req = false;
        BitBuf.Companion this_$iv$iv = this_$iv;
        boolean $i$f$req2 = false;
        if (this_$iv$iv.getErrorChecking() && !value$iv) {
            boolean bl = false;
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.pBitsUnsafe(count, value);
    }

    /*
     * WARNING - void declaration
     */
    private final void pBitsUnsafe(int count, int value) {
        void this_$iv;
        int rem;
        int index = this.getWriterIndex();
        int bytePos = index >>> 3;
        int bitPos = 8 - (index & 7);
        this.setWriterIndex(this.getWriterIndex() + count);
        for (rem = count; rem > bitPos; rem -= bitPos) {
            void i$iv;
            BitBuf this_$iv2 = this;
            boolean $i$f$bitmask = false;
            int ending = value >>> rem - bitPos & (1 << bitPos) - 1;
            UnsafeBitBuf this_$iv3 = this;
            int $i$f$get = 0;
            byte by = unsafe.getByte(this_$iv3.address + (long)bytePos);
            this_$iv3 = this;
            $i$f$get = bytePos++;
            BitBuf this_$iv4 = this;
            boolean $i$f$bitmask2 = false;
            int value$iv = by & ~((1 << bitPos) - 1) | ending;
            boolean $i$f$set = false;
            unsafe.putByte(this_$iv3.address + (long)i$iv, (byte)value$iv);
            bitPos = 8;
        }
        UnsafeBitBuf this_$iv5 = this;
        boolean $i$f$get = false;
        byte cur = unsafe.getByte(this_$iv5.address + (long)bytePos);
        BitBuf this_$iv6 = this;
        boolean $i$f$bitmask = false;
        int mask = (1 << rem) - 1;
        int offset = bitPos - rem;
        int sanitized = cur & ~(mask << offset);
        int addition = (value & mask) << offset;
        UnsafeBitBuf $i$f$set = this;
        int value$iv = sanitized | addition;
        boolean $i$f$set2 = false;
        unsafe.putByte(this_$iv.address + (long)bytePos, (byte)value$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void pBitsUnsafe(int count, long value) {
        void this_$iv;
        int rem;
        int index = this.getWriterIndex();
        int bytePos = index >>> 3;
        int bitPos = 8 - (index & 7);
        this.setWriterIndex(this.getWriterIndex() + count);
        for (rem = count; rem > bitPos; rem -= bitPos) {
            void i$iv;
            BitBuf this_$iv2 = this;
            boolean $i$f$bitmask = false;
            int ending = (int)(value >>> rem - bitPos) & (1 << bitPos) - 1;
            UnsafeBitBuf this_$iv3 = this;
            int $i$f$get = 0;
            byte by = unsafe.getByte(this_$iv3.address + (long)bytePos);
            this_$iv3 = this;
            $i$f$get = bytePos++;
            BitBuf this_$iv4 = this;
            boolean $i$f$bitmask2 = false;
            int value$iv = by & ~((1 << bitPos) - 1) | ending;
            boolean $i$f$set = false;
            unsafe.putByte(this_$iv3.address + (long)i$iv, (byte)value$iv);
            bitPos = 8;
        }
        UnsafeBitBuf this_$iv5 = this;
        boolean $i$f$get = false;
        byte cur = unsafe.getByte(this_$iv5.address + (long)bytePos);
        BitBuf this_$iv6 = this;
        boolean $i$f$bitmask = false;
        int mask = (1 << rem) - 1;
        int offset = bitPos - rem;
        int sanitized = cur & ~(mask << offset);
        int addition = ((int)value & mask) << offset;
        UnsafeBitBuf $i$f$set = this;
        int value$iv = sanitized | addition;
        boolean $i$f$set2 = false;
        unsafe.putByte(this_$iv.address + (long)bytePos, (byte)value$iv);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void pBits(@NotNull UnsafeLongBackedBitBuf src) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        int count = src.readableBits();
        BitBuf.Companion companion = BitBuf.Companion;
        boolean value$iv = this.isWritable(count);
        boolean $i$f$req = false;
        void this_$iv$iv = this_$iv;
        boolean $i$f$req2 = false;
        if (this_$iv$iv.getErrorChecking() && !value$iv) {
            boolean bl = false;
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.pBitsUnsafe(count, src.gBitsLong(src.readerIndex(), src.readableBits()));
    }

    @Override
    public int gBits(int count) {
        boolean $i$f$bitmask;
        BitBuf this_$iv;
        boolean $i$f$get;
        int remaining;
        BitBuf.Companion this_$iv2;
        BitBuf.Companion companion = BitBuf.Companion;
        boolean value$iv = 1 <= count ? count < 33 : false;
        boolean $i$f$req = false;
        if (this_$iv2.getErrorChecking() && !value$iv) {
            boolean $i$a$-req-UnsafeBitBuf$gBits$22 = false;
            String $i$a$-req-UnsafeBitBuf$gBits$22 = "Number of bits must be in 1..32";
            throw new IllegalArgumentException($i$a$-req-UnsafeBitBuf$gBits$22.toString());
        }
        this_$iv2 = BitBuf.Companion;
        value$iv = this.isReadable(count);
        $i$f$req = false;
        BitBuf.Companion this_$iv$iv = this_$iv2;
        boolean $i$f$req2 = false;
        if (this_$iv$iv.getErrorChecking() && !value$iv) {
            boolean $i$a$-req-BitBuf$Companion$req$1$iv22 = false;
            String $i$a$-req-BitBuf$Companion$req$1$iv22 = "Failed requirement.";
            throw new IllegalArgumentException($i$a$-req-BitBuf$Companion$req$1$iv22.toString());
        }
        int bytePos = this.getReaderIndex() >> 3;
        int bitPos = 8 - (this.getReaderIndex() & 7);
        int value = 0;
        this.setReaderIndex(this.getReaderIndex() + remaining);
        for (remaining = count; remaining > bitPos; remaining -= bitPos) {
            UnsafeBitBuf $i$a$-req-BitBuf$Companion$req$1$iv22 = this;
            int idx$iv = bytePos++;
            $i$f$get = false;
            int n = unsafe.getByte(((UnsafeBitBuf)this_$iv).address + (long)idx$iv) & 0xFF;
            this_$iv = this;
            $i$f$bitmask = false;
            value += (n & (1 << bitPos) - 1) << remaining - bitPos;
            bitPos = 8;
        }
        this_$iv = this;
        $i$f$bitmask = false;
        int bitmask = (1 << remaining) - 1;
        UnsafeBitBuf this_$iv3 = this;
        $i$f$get = false;
        int cur = unsafe.getByte(this_$iv3.address + (long)bytePos) & 0xFF;
        return value + (cur >>> bitPos - remaining & bitmask);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/rsprot/buffer/bitbuffer/UnsafeBitBuf$Companion;", "", "()V", "unsafe", "Lsun/misc/Unsafe;", "kotlin.jvm.PlatformType", "buffer"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

