/*
 * Decompiled with CFR 0.152.
 */
package net.bottegaio.management.web;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import net.bottegaio.management.web.BottegaioWebAgentTabPage;
import net.bottegaio.management.web.BottegaioWebComponent;
import net.bottegaio.management.web.BottegaioWebMenuPage;
import net.bottegaio.management.web.annotation.BottegaioWebAgentTab;
import net.bottegaio.management.web.annotation.BottegaioWebMenu;
import net.bottegaio.utils.LogUtils;
import net.bottegaio.utils.StaticUtils;

public class StaticWebUtils {
    private static String baseSearchPackageForWebComponents = "net.bottegaio";
    private static final Logger logger = Logger.getLogger(StaticWebUtils.class.getName());

    private static <W extends BottegaioWebComponent, A extends Annotation> Collection<W> findAllComponents(Class<A> annotation, Class<W> interfaceClass, String baseSearchPackage) throws IOException {
        if (annotation.equals(BottegaioWebAgentTab.class) || annotation.equals(BottegaioWebMenu.class)) {
            ArrayList<BottegaioWebComponent> resultList = new ArrayList<BottegaioWebComponent>();
            for (Class oneClass : StaticUtils.findAllClassesUsingGoogleGuice((String)baseSearchPackage)) {
                if (!oneClass.isAnnotationPresent(annotation)) continue;
                if (interfaceClass.isAssignableFrom(oneClass)) {
                    try {
                        Annotation annotationCasted;
                        boolean ok = false;
                        Constructor<?> constructor = oneClass.getConstructors()[0];
                        Object instance = constructor.newInstance(new Object[0]);
                        A annotationInstance = oneClass.getAnnotation(annotation);
                        if (annotationInstance instanceof BottegaioWebAgentTab && interfaceClass.equals(BottegaioWebAgentTabPage.class)) {
                            annotationCasted = (BottegaioWebAgentTab)annotationInstance;
                            ok = true;
                        } else if (annotationInstance instanceof BottegaioWebMenu && interfaceClass.equals(BottegaioWebMenuPage.class)) {
                            annotationCasted = (BottegaioWebMenu)annotationInstance;
                            ok = true;
                        }
                        if (!ok) continue;
                        resultList.add((BottegaioWebComponent)instance);
                    }
                    catch (Exception creationEx) {
                        logger.severe("during instance creation of " + oneClass.toString() + " " + LogUtils.stackTraceToString((Throwable)creationEx, (int)8));
                    }
                    continue;
                }
                logger.severe("the class " + oneClass.toString() + " is annoteted as " + annotation + " but is not a implementation of " + interfaceClass.getName() + " interface");
            }
            return resultList;
        }
        throw new IOException("the class " + annotation + " is not a valid for this task");
    }

    public static Collection<BottegaioWebAgentTabPage> getAgentTabRecords() throws IOException {
        return StaticWebUtils.findAllComponents(BottegaioWebAgentTab.class, BottegaioWebAgentTabPage.class, baseSearchPackageForWebComponents);
    }

    public static String getBaseSearchPackageForWebComponents() {
        return baseSearchPackageForWebComponents;
    }

    public static Collection<BottegaioWebMenuPage> getMenuRecords() throws IOException {
        return StaticWebUtils.findAllComponents(BottegaioWebMenu.class, BottegaioWebMenuPage.class, baseSearchPackageForWebComponents);
    }

    public static void setBaseSearchPackageForWebComponents(String baseSearchPackageForWebComponents) {
        StaticWebUtils.baseSearchPackageForWebComponents = baseSearchPackageForWebComponents;
    }

    private StaticWebUtils() {
        throw new UnsupportedOperationException("Just for static usage");
    }
}

