package net.bottegaio.management.web;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

import net.bottegaio.agent.StaticFields;
import net.bottegaio.management.web.annotation.BottegaioWebAgentTab;
import net.bottegaio.management.web.annotation.BottegaioWebMenu;
import net.bottegaio.utils.LogUtils;
import net.bottegaio.utils.StaticUtils;

public class StaticWebUtils {

	private static String baseSearchPackageForWebComponents = "net.bottegaio";

	private static final Logger logger = Logger.getLogger(StaticWebUtils.class.getName());

	@SuppressWarnings("unchecked")
	private static <W extends BottegaioWebComponent, A extends Annotation> Collection<W> findAllComponents(
			final Class<A> annotation, final Class<W> interfaceClass, final String baseSearchPackage)
			throws IOException {
		if (annotation.equals(BottegaioWebAgentTab.class) || annotation.equals(BottegaioWebMenu.class)) {
			final Collection<W> resultList = new ArrayList<>();
			for (final Class<?> oneClass : StaticUtils.findAllClassesUsingGoogleGuice(baseSearchPackage)) {
				if (oneClass.isAnnotationPresent(annotation)) {
					if (interfaceClass.isAssignableFrom(oneClass)) {
						try {
							boolean ok = false;
							final Constructor<?> constructor = oneClass.getConstructors()[0];
							final Object instance = constructor.newInstance();
							final Annotation annotationInstance = oneClass.getAnnotation(annotation);
							if (annotationInstance instanceof BottegaioWebAgentTab
									&& interfaceClass.equals(BottegaioWebAgentTabPage.class)) {
								@SuppressWarnings("unused")
								final BottegaioWebAgentTab annotationCasted = (BottegaioWebAgentTab) annotationInstance;
								// recuperare parametri annotazione qui
								ok = true;
							} else if (annotationInstance instanceof BottegaioWebMenu
									&& interfaceClass.equals(BottegaioWebMenuPage.class)) {
								@SuppressWarnings("unused")
								final BottegaioWebMenu annotationCasted = (BottegaioWebMenu) annotationInstance;
								// recuperare parametri annotazione qui
								ok = true;
							}
							if (ok) {
								resultList.add((W) instance);
							}
						} catch (final Exception creationEx) {
							logger.severe("during instance creation of " + oneClass.toString() + " "
									+ LogUtils.stackTraceToString(creationEx, StaticFields.NUMBER_OF_LINE_STACKTRACE));
						}
					} else {
						logger.severe("the class " + oneClass.toString() + " is annoteted as " + annotation
								+ " but is not a implementation of " + interfaceClass.getName() + " interface");
					}
				}
			}
			return resultList;
		} else {
			throw new IOException("the class " + annotation + " is not a valid for this task");
		}
	}

	public static Collection<BottegaioWebAgentTabPage> getAgentTabRecords() throws IOException {
		return findAllComponents(BottegaioWebAgentTab.class, BottegaioWebAgentTabPage.class,
				baseSearchPackageForWebComponents);
	}

	public static String getBaseSearchPackageForWebComponents() {
		return baseSearchPackageForWebComponents;
	}

	public static Collection<BottegaioWebMenuPage> getMenuRecords() throws IOException {
		return findAllComponents(BottegaioWebMenu.class, BottegaioWebMenuPage.class, baseSearchPackageForWebComponents);
	}

	public static void setBaseSearchPackageForWebComponents(final String baseSearchPackageForWebComponents) {
		StaticWebUtils.baseSearchPackageForWebComponents = baseSearchPackageForWebComponents;
	}

	private StaticWebUtils() {
		throw new UnsupportedOperationException("Just for static usage");
	}

}
