/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.security;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import net.risedata.rpc.provide.context.RPCRequestContext;
import net.risesoft.pojo.Y9Result;
import net.risesoft.security.ConcurrentSecurity;
import net.risesoft.security.RPCRequestFilter;
import net.risesoft.security.SecurityConfig;
import net.risesoft.security.SecurityManager;
import net.risesoft.security.pojo.DataUser;
import net.risesoft.util.IpUtils;
import net.risesoft.util.PattenUtil;
import net.risesoft.util.Y9KernelApiUtil;
import net.risesoft.y9.Y9Context;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.PatternMatchUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class DefaultSecurityManager
implements SecurityManager,
Filter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSecurityManager.class);
    private ThreadLocal<Object> threadLocal = new ThreadLocal();
    private ConcurrentHashMap<String, ConcurrentSecurity> TOKEN_SECURITY_MAP = new ConcurrentHashMap();
    public static Y9Result<Object> tokenError = Y9Result.failure((int)401, (String)"no token or Token expired");
    public static Y9Result<Object> noPermission = Y9Result.failure((int)403, (String)"no permission");
    @Autowired(required=false)
    private List<SecurityConfig> securityConfigs;
    public String[] excludeStartUrls = new String[]{"/RPC/", "/register/"};
    public String[] excludeEndUrls = new String[]{"getToken", "/register/", "getTestData", "saveTestData"};

    public ConcurrentSecurity getConcurrentSecurity() {
        Object token = this.threadLocal.get();
        if (token == null) {
            return null;
        }
        if (token instanceof String) {
            this.threadLocal.set(this.TOKEN_SECURITY_MAP.get(token));
        }
        return (ConcurrentSecurity)this.threadLocal.get();
    }

    public boolean hasMatch(String source, String compare) {
        return PatternMatchUtils.simpleMatch((String)source, (String)compare);
    }

    public boolean hasMatch(String[] source, String compare) {
        for (String s : source) {
            if (!this.hasMatch(s, compare)) continue;
            return true;
        }
        return false;
    }

    public void tokenFailure(List<String> failureTokens, Long time) {
    }

    public boolean removeToken(String token) {
        return false;
    }

    public String getConcurrentIp() {
        RPCRequestContext current = RPCRequestFilter.getCurrent();
        if (current != null) {
            return ((InetSocketAddress)current.getConcurrentConnection().getRemoteAddress()).getHostString();
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        return IpUtils.getIPAddress((HttpServletRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest request1 = (HttpServletRequest)request;
            String token = Y9LoginUserHolder.getPersonId();
            String url = request1.getRequestURI();
            if (StringUtils.isEmpty((CharSequence)token)) {
                for (String excludeStartUrl : this.excludeEndUrls) {
                    if (!url.endsWith(excludeStartUrl)) continue;
                    chain.doFilter(request, response);
                    return;
                }
                for (String excludeStartUrl : this.excludeStartUrls) {
                    if (!url.startsWith(excludeStartUrl)) continue;
                    chain.doFilter(request, response);
                    return;
                }
                this.throwError(tokenError, request, response);
                return;
            }
            this.saveSecurity(token);
            for (SecurityConfig securityConfig : this.securityConfigs) {
                if (!PattenUtil.hasMatch((List)securityConfig.getCheckUrl(), (String)url)) continue;
                if (PattenUtil.hasMatch((List)securityConfig.getWhiteList(), (String)url)) continue;
                if (securityConfig.getSecurityCheck().check(securityConfig, this.getConcurrentSecurity(), url, request1)) continue;
                this.throwError(noPermission, request, response);
                return;
            }
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            this.throwError(Y9Result.failure((int)500, (String)e.getMessage()), request, response);
        }
        finally {
            this.threadLocal.remove();
        }
    }

    private void saveSecurity(String token) throws Exception {
        String[] environments;
        DataUser user = new DataUser();
        user.setId(token);
        user.setUserName(Y9LoginUserHolder.getUserInfo().getName());
        user.setAccount(Y9LoginUserHolder.getUserInfo().getLoginName());
        LOGGER.debug("\u83b7\u53d6\u7528\u6237[" + Y9LoginUserHolder.getUserInfo().getName() + "]\u6743\u9650-\u5f00\u59cb");
        boolean userManager = false;
        boolean systemManager = Y9KernelApiUtil.hasRole(Y9LoginUserHolder.getTenantId(), token, "\u7cfb\u7edf\u7ba1\u7406\u5458");
        ArrayList<String> envRoles = new ArrayList<String>();
        for (String env : environments = Y9Context.getProperty((String)"y9.common.environments", (String)"Public,dev").split(",")) {
            boolean hasRole = Y9KernelApiUtil.hasRole2(Y9LoginUserHolder.getTenantId(), token, env);
            if (!hasRole) continue;
            envRoles.add(env);
        }
        List<Map<String, Object>> dataCatalogList = Y9KernelApiUtil.getDataCatalogTree(Y9LoginUserHolder.getTenantId(), token, true);
        if (dataCatalogList.size() == 0) {
            throw new Exception("\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        List jobTypes = dataCatalogList.stream().map(map -> (String)map.get("id")).collect(Collectors.toList());
        LOGGER.debug("\u83b7\u53d6\u7528\u6237[" + Y9LoginUserHolder.getUserInfo().getName() + "]\u6743\u9650-\u7ed3\u675f");
        ConcurrentSecurity concurrentSecurity = new ConcurrentSecurity(user, jobTypes, envRoles, userManager, systemManager);
        this.threadLocal.set(token);
        this.TOKEN_SECURITY_MAP.put(token, concurrentSecurity);
    }

    private void throwError(Y9Result<?> result, ServletRequest request, ServletResponse response) throws IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json");
        response.getWriter().write(JSON.toJSONString(result));
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public String getToken() {
        return "";
    }
}

