/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.util;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import net.risesoft.api.platform.org.PositionApi;
import net.risesoft.controller.dto.EmailDTO;
import net.risesoft.model.platform.Position;
import net.risesoft.model.user.UserInfo;
import net.risesoft.util.ConvertPinYin;
import net.risesoft.y9.Y9Context;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.configuration.app.y9webmail.Y9WebMailProperties;
import net.risesoft.y9.util.Y9FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringSubstitutor;
import org.springframework.util.ResourceUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class EmailUtil {
    public static String getReplyOrForwardContent(EmailDTO email) {
        String toEmailAddresses = String.join((CharSequence)";", email.getToEmailAddressList());
        String ccEmailAddresses = String.join((CharSequence)";", email.getCcEmailAddressList());
        String sendTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(email.getSendTime());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(EmailUtil.getSignature());
        stringBuilder.append("<p><br/></p>");
        stringBuilder.append("<p>-------------------------------\u539f\u6b63\u6587\u5982\u4e0b-----------------------------------</p>");
        stringBuilder.append("<p>\u4e3b\u9898\uff1a").append(email.getSubject()).append("</p>");
        stringBuilder.append("<p>\u65f6\u95f4\uff1a").append(sendTime).append("</p>");
        stringBuilder.append("<p>\u53d1\u4ef6\u4eba\uff1a").append(email.getFrom()).append("</p>");
        stringBuilder.append("<p>\u6536\u4ef6\u4eba\uff1a").append(toEmailAddresses).append("</p>");
        if (StringUtils.isNotBlank((CharSequence)ccEmailAddresses)) {
            stringBuilder.append("<p>\u6284\u9001\uff1a").append(ccEmailAddresses).append("</p>");
        }
        stringBuilder.append("<p><br/></p>");
        return stringBuilder.toString();
    }

    public static String getSignature() {
        UserInfo userInfo = Y9LoginUserHolder.getUserInfo();
        Position position = (Position)((PositionApi)Y9Context.getBean(PositionApi.class)).get(userInfo.getTenantId(), userInfo.getPositionId()).getData();
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String ipAddr = Y9Context.getIpAddr((HttpServletRequest)request);
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        keyValueMap.put("personName", userInfo.getName());
        keyValueMap.put("mobile", userInfo.getMobile());
        keyValueMap.put("jobName", position.getJobName());
        keyValueMap.put("tenantName", userInfo.getTenantName());
        keyValueMap.put("ip", ipAddr);
        String template = null;
        try {
            template = Y9FileUtil.getContent((String)ResourceUtils.getFile((String)"classpath:templates/signature.txt").getAbsolutePath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return StringSubstitutor.replace((Object)template, keyValueMap, (String)"{{", (String)"}}");
    }

    public static String buildEmailAddress(String loginName) {
        Y9WebMailProperties y9WebMailProperties = (Y9WebMailProperties)Y9Context.getBean(Y9WebMailProperties.class);
        return ConvertPinYin.getPinyin(loginName) + "@" + y9WebMailProperties.getHost();
    }
}

