/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import com.sun.mail.imap.IMAPFolder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.activation.DataSource;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.search.SearchTerm;
import jodd.mail.ImapServer;
import jodd.mail.MailServer;
import jodd.mail.ReceiveMailSession;
import jodd.mail.SendMailSession;
import jodd.mail.SmtpServer;
import lombok.Generated;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.controller.dto.EmailAttachmentDTO;
import net.risesoft.controller.dto.EmailContactDTO;
import net.risesoft.controller.dto.EmailListDTO;
import net.risesoft.controller.dto.ToDTO;
import net.risesoft.james.entity.JamesUser;
import net.risesoft.james.entity.term.MyMessageIDTerm;
import net.risesoft.james.service.JamesUserService;
import net.risesoft.model.platform.Person;
import net.risesoft.support.EmailThreadLocalHolder;
import net.risesoft.util.MimeMessageParser;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.configuration.app.y9webmail.Y9WebMailProperties;
import net.risesoft.y9.util.signing.Y9MessageDigest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class MailHelper {
    protected final Y9WebMailProperties y9WebMailProperties;
    protected final JamesUserService jamesUserService;
    protected final PersonApi personApi;

    public static EmailAttachmentDTO parseEmailAttachment(DataSource dataSource) throws IOException {
        EmailAttachmentDTO emailAttachmentDTO = new EmailAttachmentDTO();
        byte[] bytes = IOUtils.toByteArray((InputStream)dataSource.getInputStream());
        emailAttachmentDTO.setMd5(Y9MessageDigest.md5((byte[])bytes));
        emailAttachmentDTO.setFileExt(FilenameUtils.getExtension((String)dataSource.getName()));
        emailAttachmentDTO.setFileName(dataSource.getName());
        emailAttachmentDTO.setDisplaySize(FileUtils.byteCountToDisplaySize((long)bytes.length));
        return emailAttachmentDTO;
    }

    public ReceiveMailSession createReceiveMailSession() {
        String plainText = this.jamesUserService.getPlainTextByPersonId(Y9LoginUserHolder.getUserInfo().getPersonId());
        String email = EmailThreadLocalHolder.getEmailAddress();
        ImapServer imapServer = MailServer.create().host(this.y9WebMailProperties.getImapHost()).property("mail.imap.sasl.authorizationid", email).port(this.y9WebMailProperties.getImapPort().intValue()).auth(email, plainText).buildImapMailServer();
        return imapServer.createSession();
    }

    public SendMailSession createSendMailSession() {
        String plainText = this.jamesUserService.getPlainTextByPersonId(Y9LoginUserHolder.getUserInfo().getPersonId());
        String email = EmailThreadLocalHolder.getEmailAddress();
        SmtpServer smtpServer = MailServer.create().host(this.y9WebMailProperties.getSmtpHost()).port(this.y9WebMailProperties.getSmtpPort().intValue()).auth(email, plainText).buildSmtpMailServer();
        return smtpServer.createSession();
    }

    public Message getMessage(IMAPFolder folder, String messageId) throws MessagingException {
        Message[] searchedMessage = folder.search((SearchTerm)new MyMessageIDTerm(messageId));
        if (searchedMessage.length > 0) {
            return searchedMessage[0];
        }
        return null;
    }

    public List<EmailAttachmentDTO> parseEmailAttachmentList(List<DataSource> attachmentList) throws IOException {
        ArrayList<EmailAttachmentDTO> emailAttachmentDTOList = new ArrayList<EmailAttachmentDTO>();
        for (DataSource dataSource : attachmentList) {
            emailAttachmentDTOList.add(MailHelper.parseEmailAttachment(dataSource));
        }
        return emailAttachmentDTOList;
    }

    public void getPersonData(IMAPFolder folder, List<EmailListDTO> emailReceiverDTOList) {
        JamesUser JamesUser2 = null;
        Person person = null;
        try {
            for (EmailListDTO emailListDTO : emailReceiverDTOList) {
                Message message = folder.getMessageByUID(emailListDTO.getUid().longValue());
                if (message == null) continue;
                MimeMessageParser parser = new MimeMessageParser((MimeMessage)message).parse();
                List emailAddressList = parser.getTo().stream().map(address -> ((InternetAddress)address).getAddress()).collect(Collectors.toList());
                if (emailAddressList != null && emailAddressList.size() != 0) {
                    String emailAddress;
                    ArrayList<ToDTO> toDTOList = new ArrayList<ToDTO>();
                    Iterator iterator = emailAddressList.iterator();
                    while (iterator.hasNext() && (emailAddress = (String)iterator.next()).indexOf("@youshengyun.com") != -1) {
                        ToDTO toDTO = new ToDTO();
                        toDTO.setTo(emailAddress);
                        JamesUser2 = this.jamesUserService.findByEmailAddress(emailAddress);
                        if (JamesUser2 != null) {
                            person = (Person)this.personApi.get(Y9LoginUserHolder.getTenantId(), JamesUser2.getPersonId()).getData();
                            toDTO.setToName(person.getName());
                            toDTO.setToAvator(person.getAvator());
                        }
                        toDTOList.add(toDTO);
                    }
                    emailListDTO.setToDTOList(toDTOList);
                }
                if (parser.getFrom().indexOf("@youshengyun.com") == -1) continue;
                emailListDTO.setFrom(parser.getFrom());
                JamesUser2 = this.jamesUserService.findByEmailAddress(emailListDTO.getFrom());
                if (JamesUser2 == null) continue;
                person = (Person)this.personApi.get(Y9LoginUserHolder.getTenantId(), JamesUser2.getPersonId()).getData();
                emailListDTO.setFromName(person.getName());
                emailListDTO.setFromAvator(person.getAvator());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getEmailContactDTOList(IMAPFolder folder, List<EmailListDTO> emailReceiverDTOList, List<EmailContactDTO> contactDTOList) {
        JamesUser JamesUser2 = null;
        Person person = null;
        try {
            String email = this.jamesUserService.getEmailAddressByPersonId(Y9LoginUserHolder.getPersonId());
            for (EmailListDTO emailListDTO : emailReceiverDTOList) {
                boolean exists;
                String from;
                Message message = folder.getMessageByUID(emailListDTO.getUid().longValue());
                if (message == null) continue;
                MimeMessageParser parser = new MimeMessageParser((MimeMessage)message).parse();
                List emailAddressList = parser.getTo().stream().map(address -> ((InternetAddress)address).getAddress()).collect(Collectors.toList());
                if (emailAddressList != null && emailAddressList.size() != 0) {
                    for (String emailAddress : emailAddressList) {
                        boolean exists2;
                        if (emailAddress.equals(email) || (exists2 = contactDTOList.stream().anyMatch(param -> param.getContactPerson() instanceof String && param.getContactPerson().equalsIgnoreCase(emailAddress)))) continue;
                        EmailContactDTO contactDTO = new EmailContactDTO();
                        contactDTO.setContactPerson(emailAddress);
                        if (emailAddress.indexOf("@youshengyun.com") != -1 && (JamesUser2 = this.jamesUserService.findByEmailAddress(emailAddress)) != null) {
                            person = (Person)this.personApi.get(Y9LoginUserHolder.getTenantId(), JamesUser2.getPersonId()).getData();
                            contactDTO.setContactPersonId(person.getId());
                            contactDTO.setContactPersonName(person.getName());
                            contactDTO.setContactPersonAvator(person.getAvator());
                        }
                        contactDTOList.add(contactDTO);
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)(from = parser.getFrom())) || from.equals(email) || (exists = contactDTOList.stream().anyMatch(param -> param.getContactPerson() instanceof String && param.getContactPerson().equalsIgnoreCase(from)))) continue;
                EmailContactDTO contactDTO = new EmailContactDTO();
                contactDTO.setContactPerson(parser.getFrom());
                if (parser.getFrom().indexOf("@youshengyun.com") != -1 && (JamesUser2 = this.jamesUserService.findByEmailAddress(parser.getFrom())) != null) {
                    person = (Person)this.personApi.get(Y9LoginUserHolder.getTenantId(), JamesUser2.getPersonId()).getData();
                    contactDTO.setContactPersonId(person.getId());
                    contactDTO.setContactPersonName(person.getName());
                    contactDTO.setContactPersonAvator(person.getAvator());
                }
                contactDTOList.add(contactDTO);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Generated
    public MailHelper(Y9WebMailProperties y9WebMailProperties, JamesUserService jamesUserService, PersonApi personApi) {
        this.y9WebMailProperties = y9WebMailProperties;
        this.jamesUserService = jamesUserService;
        this.personApi = personApi;
    }
}

