/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import com.sun.mail.imap.IMAPFolder;
import com.sun.mail.imap.IMAPMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.ContentType;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.ParseException;
import javax.mail.search.AndTerm;
import javax.mail.search.OrTerm;
import javax.mail.search.ReceivedDateTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SentDateTerm;
import javax.mail.util.ByteArrayDataSource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.mail.ReceiveMailSession;
import jodd.mail.SendMailSession;
import jodd.util.Base64;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.controller.dto.EmailContactDTO;
import net.risesoft.controller.dto.EmailDTO;
import net.risesoft.controller.dto.EmailDetailDTO;
import net.risesoft.controller.dto.EmailListDTO;
import net.risesoft.controller.dto.EmailSearchDTO;
import net.risesoft.enums.platform.OrgTreeTypeEnum;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.james.entity.JamesAddressBook;
import net.risesoft.james.entity.term.MyAttachmentTerm;
import net.risesoft.james.entity.term.MyBodyTerm;
import net.risesoft.james.entity.term.MyFlagTerm;
import net.risesoft.james.entity.term.MyFormTerm;
import net.risesoft.james.entity.term.MyReceiverTerm;
import net.risesoft.james.entity.term.MySubjectTerm;
import net.risesoft.james.service.JamesAddressBookService;
import net.risesoft.james.service.JamesUserService;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Person;
import net.risesoft.model.user.UserInfo;
import net.risesoft.pojo.Y9Page;
import net.risesoft.service.EmailService;
import net.risesoft.service.impl.MailHelper;
import net.risesoft.support.DefaultFolder;
import net.risesoft.support.EmailErrorCodeEnum;
import net.risesoft.support.EmailThreadLocalHolder;
import net.risesoft.util.EmailUtil;
import net.risesoft.util.MimeMessageParser;
import net.risesoft.y9.Y9Context;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.configuration.app.y9webmail.Y9WebMailProperties;
import net.risesoft.y9.exception.Y9BusinessException;
import net.risesoft.y9.util.mime.ContentDispositionUtil;
import net.risesoft.y9public.entity.Y9FileStore;
import net.risesoft.y9public.service.Y9FileStoreService;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class EmailServiceImpl
extends MailHelper
implements EmailService {
    private final Y9FileStoreService y9FileStoreService;
    private final OrgUnitApi orgUnitApi;
    private final JamesAddressBookService jamesAddressBookService;
    private final JamesUserService jamesUserService;

    public EmailServiceImpl(Y9WebMailProperties y9WebMailProperties, JamesUserService jamesUserService, PersonApi personApi, Y9FileStoreService y9FileStoreService, OrgUnitApi orgUnitApi, JamesAddressBookService jamesAddressBookService, JamesUserService jamesUserService1) {
        super(y9WebMailProperties, jamesUserService, personApi);
        this.y9FileStoreService = y9FileStoreService;
        this.orgUnitApi = orgUnitApi;
        this.jamesAddressBookService = jamesAddressBookService;
        this.jamesUserService = jamesUserService1;
    }

    private static void setMailer(MimeMessage mimeMessage) throws MessagingException {
        mimeMessage.setHeader("X-Mailer", "risesoft webmail");
    }

    private static EmailDTO buildReplyEmail(String folderName, EmailDTO email) {
        EmailDTO replyEmail = new EmailDTO();
        replyEmail.setFolder(folderName);
        replyEmail.setReplyMessageId(email.getMessageId());
        replyEmail.setRichText(EmailUtil.getReplyOrForwardContent(email) + (StringUtils.isNotBlank((CharSequence)email.getRichText()) ? email.getRichText() : ""));
        replyEmail.setSubject("\u56de\u590d\uff1a" + email.getSubject());
        return replyEmail;
    }

    public static boolean isHasAttachment(Message message) throws IOException, MessagingException {
        boolean hasAttachment = false;
        if (message.getContent().getClass().toString().trim().contains("MimeMultipart")) {
            MimeMultipart mmp = (MimeMultipart)message.getContent();
            int count = mmp.getCount();
            for (int j = 0; j < count; ++j) {
                BodyPart bodyPart = mmp.getBodyPart(j);
                String disposition = bodyPart.getDisposition();
                if (null == disposition || !disposition.equals("attachment")) continue;
                hasAttachment = true;
            }
        }
        return hasAttachment;
    }

    private static String getAttachmentSize(Message message) throws IOException, MessagingException {
        long attachmentSize = 0L;
        if (message.getContent().getClass().toString().trim().contains("MimeMultipart")) {
            MimeMultipart mmp = (MimeMultipart)message.getContent();
            int count = mmp.getCount();
            for (int j = 0; j < count; ++j) {
                BodyPart bodyPart = mmp.getBodyPart(j);
                String disposition = bodyPart.getDisposition();
                if (null == disposition || !disposition.equals("attachment")) continue;
                InputStream inputStream = bodyPart.getInputStream();
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                int bytesRead = -1;
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                attachmentSize += (long)outputStream.toByteArray().length;
                outputStream.close();
            }
        }
        return (attachmentSize >> 10) + " KB";
    }

    private void addHtml(MimeMultipart mimeMultipart, String richText) throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setContent((Object)richText, "text/html;charset=UTF-8");
        mimeMultipart.addBodyPart((BodyPart)bodyPart);
    }

    private List<String> addHtmlTextReplaceCID(MimeMultipart alternativeMultipart, String richText) throws MessagingException {
        ArrayList<String> inlineIdList = new ArrayList<String>();
        String patternStr = "<img\\s*([^>]*)\\s*src=\\\"(.*?)\\\"\\s*([^>]*)>";
        Pattern pattern = Pattern.compile(patternStr, 2);
        Matcher matcher = pattern.matcher(richText);
        String result = richText;
        while (matcher.find()) {
            String src = matcher.group(2);
            int index = src.indexOf(Y9Context.getSystemName());
            if (index == -1) continue;
            try {
                String fileName = src.substring(src.lastIndexOf("/") + 1);
                String fileId = FilenameUtils.getBaseName((String)fileName);
                String replaceSrc = "cid:" + fileId;
                if (StringUtils.isNotBlank((CharSequence)replaceSrc)) {
                    result = result.replaceAll(src, replaceSrc);
                }
                inlineIdList.add(fileId);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MimeBodyPart htmlBodyPart = new MimeBodyPart();
        htmlBodyPart.setContent((Object)result, "text/html;charset=UTF-8");
        alternativeMultipart.addBodyPart((BodyPart)htmlBodyPart);
        return inlineIdList;
    }

    private void addPictures(MimeMultipart mimeMultipart, List<String> cidList) throws MessagingException {
        if (cidList != null) {
            for (String fileId : cidList) {
                try {
                    MimeBodyPart mimeBodyPart = new MimeBodyPart();
                    byte[] bytes = this.y9FileStoreService.downloadFileToBytes(fileId);
                    Y9FileStore y9FileStore = this.y9FileStoreService.getById(fileId);
                    ByteArrayDataSource dataSource = new ByteArrayDataSource(bytes, new MimetypesFileTypeMap().getContentType(y9FileStore.getFileName()));
                    DataHandler dataHandler = new DataHandler((DataSource)dataSource);
                    mimeBodyPart.setDataHandler(dataHandler);
                    mimeBodyPart.setContentID("<" + fileId + ">");
                    mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
                    this.y9FileStoreService.deleteFile(fileId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void addText(MimeMultipart alternativeMultipart, String text) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setContent((Object)text, "text/plain;charset=UTF-8");
        alternativeMultipart.addBodyPart((BodyPart)mimeBodyPart);
    }

    @Override
    public void delete(String folderName, long[] uids) throws MessagingException {
        this.move(uids, folderName, DefaultFolder.TRASH.getName());
    }

    @Override
    public void deletePermanently(String folderName, long[] uids) throws MessagingException {
        ReceiveMailSession sendMailSession = this.createReceiveMailSession();
        sendMailSession.open();
        IMAPFolder folder = (IMAPFolder)sendMailSession.getFolder(folderName);
        folder.open(2);
        Message[] messages = folder.getMessagesByUID(uids);
        folder.setFlags(messages, new Flags(Flags.Flag.DELETED), true);
        folder.close(true);
        sendMailSession.close();
    }

    @Override
    public EmailDetailDTO detail(String folderName, long uid) throws Exception {
        ReceiveMailSession receiveMailSession = this.createReceiveMailSession();
        EmailDetailDTO email = null;
        receiveMailSession.open();
        IMAPFolder folder = (IMAPFolder)receiveMailSession.getFolder(folderName);
        if (!folder.exists()) {
            folder = (IMAPFolder)receiveMailSession.getFolder(DefaultFolder.MY_FOLDER.getName()).getFolder(folderName);
        }
        if (folder.exists()) {
            folder.open(2);
            Message message = this.getMessageByUID(folder, uid);
            folder.setFlags(new Message[]{message}, new Flags(Flags.Flag.SEEN), true);
            email = this.parseToEmail((MimeMessage)message, EmailDetailDTO.class);
            email.setUid(uid);
            int messageNumber = message.getMessageNumber();
            if (messageNumber > 1) {
                Message nextMessage = folder.getMessage(messageNumber - 1);
                email.setNextUid(folder.getUID(nextMessage));
            }
            if (messageNumber < folder.getMessageCount()) {
                Message previousMessage = folder.getMessage(messageNumber + 1);
                email.setPreviousUid(folder.getUID(previousMessage));
            }
            folder.close(true);
        }
        return email;
    }

    @Override
    public void exportEml(String folderName, long uid, HttpServletResponse response, HttpServletRequest request) throws IOException, MessagingException {
        ReceiveMailSession receiveMailSession = this.createReceiveMailSession();
        receiveMailSession.open();
        IMAPFolder folder = (IMAPFolder)receiveMailSession.getFolder(folderName);
        folder.open(1);
        Message message = this.getMessageByUID(folder, uid);
        String filename = message.getSubject() + ".eml";
        ServletOutputStream out = response.getOutputStream();
        response.reset();
        response.setHeader("Content-disposition", ContentDispositionUtil.standardizeAttachment((String)filename));
        response.setHeader("Content-type", "text/html;charset=UTF-8");
        response.setContentType("application/octet-stream");
        message.writeTo((OutputStream)out);
        out.flush();
        out.close();
    }

    @Override
    public EmailDTO findByFolderAndUid(String folderName, long uid) throws Exception {
        ReceiveMailSession receiveMailSession = this.createReceiveMailSession();
        EmailDTO email = null;
        receiveMailSession.open();
        IMAPFolder folder = (IMAPFolder)receiveMailSession.getFolder(folderName);
        if (!folder.exists()) {
            folder = (IMAPFolder)receiveMailSession.getFolder(DefaultFolder.MY_FOLDER.getName()).getFolder(folderName);
        }
        if (folder.exists()) {
            folder.open(1);
            Message message = this.getMessageByUID(folder, uid);
            email = this.parseToEmail((MimeMessage)message, EmailDTO.class);
            folder.close();
        }
        return email;
    }

    private Message getMessageByUID(IMAPFolder folder, long uid) throws MessagingException {
        Message message = folder.getMessageByUID(uid);
        if (message == null) {
            throw new Y9BusinessException(EmailErrorCodeEnum.EMAIL_NOT_EXIST.getCode(), EmailErrorCodeEnum.EMAIL_NOT_EXIST.getDescription());
        }
        return message;
    }

    @Override
    public void flag(String folderName, long[] uids, boolean flagged) throws MessagingException {
        ReceiveMailSession receiveMailSession = this.createReceiveMailSession();
        receiveMailSession.open();
        IMAPFolder folder = (IMAPFolder)receiveMailSession.getFolder(folderName);
        if (folder.exists()) {
            folder.open(2);
            Message[] msgs = folder.getMessagesByUID(uids);
            folder.setFlags(msgs, new Flags(Flags.Flag.FLAGGED), flagged);
            folder.close(true);
        }
        receiveMailSession.close();
    }

    @Override
    public EmailDTO forward(String folderName, long uid) throws Exception {
        EmailDTO email = this.findByFolderAndUid(folderName, uid);
        EmailDTO forwardEmail = new EmailDTO();
        forwardEmail.setFolder(folderName);
        forwardEmail.setForwardMessageId(email.getMessageId());
        forwardEmail.setRichText(EmailUtil.getReplyOrForwardContent(email) + (StringUtils.isNotBlank((CharSequence)email.getRichText()) ? email.getRichText() : ""));
        forwardEmail.setSubject("\u8f6c\u53d1\uff1a" + email.getSubject());
        forwardEmail.setEmailAttachmentDTOList(email.getEmailAttachmentDTOList());
        return forwardEmail;
    }

    @Override
    public int getCountByFolder(String folderName, boolean unRead) throws MessagingException {
        int receiveImapCount = 0;
        ReceiveMailSession receiveMailSession = this.createReceiveMailSession();
        receiveMailSession.open();
        IMAPFolder folder = (IMAPFolder)receiveMailSession.getFolder(folderName);
        if (!folder.exists()) {
            folder.create(1);
        }
        folder.open(1);
        receiveImapCount = unRead ? folder.getUnreadMessageCount() : folder.getMessageCount();
        folder.close();
        receiveMailSession.close();
        return receiveImapCount;
    }

    @Override
    public Map<String, Object> getTodoCount(String personId) throws MessagingException {
        int deletedCount;
        int sendCount;
        int receivedCount;
        HashMap<String, Object> data = new HashMap<String, Object>();
        int draftCount = this.getCountByFolder(DefaultFolder.DRAFTS.getName(), false);
        if (draftCount != 0) {
            data.put(DefaultFolder.DRAFTS.getName(), draftCount);
        }
        if (0 != (receivedCount = this.getCountByFolder(DefaultFolder.INBOX.getName(), true))) {
            data.put(DefaultFolder.INBOX.getName(), receivedCount);
        }
        if (0 != (sendCount = this.getCountByFolder(DefaultFolder.SENT.getName(), false))) {
            data.put(DefaultFolder.SENT.getName(), sendCount);
        }
        if (0 != (deletedCount = this.getCountByFolder(DefaultFolder.TRASH.getName(), false))) {
            data.put(DefaultFolder.TRASH.getName(), deletedCount);
        }
        return data;
    }

    @Override
    public Y9Page<EmailListDTO> listByFolder(String folderName, int page, int rows) throws MessagingException, IOException {
        ReceiveMailSession receiveMailSession = this.createReceiveMailSession();
        receiveMailSession.open();
        List<EmailListDTO> emailReceiverDTOList = new ArrayList<EmailListDTO>();
        IMAPFolder folder = (IMAPFolder)receiveMailSession.getFolder(folderName);
        if (!folder.exists()) {
            folder = (IMAPFolder)receiveMailSession.getFolder(DefaultFolder.MY_FOLDER.getName()).getFolder(folderName);
        }
        int totalCount = 0;
        int totalPage = 0;
        if (folder.exists()) {
            Message[] messages;
            folder.open(1);
            totalCount = folder.getMessageCount();
            totalPage = totalCount / rows + 1;
            int end = totalCount - (page - 1) * rows;
            int start = totalCount - page * rows + 1;
            if (start < 1) {
                start = 1;
            }
            if ((messages = folder.getMessages(start, end)) != null && messages.length > 0) {
                for (int i = messages.length - 1; i >= 0; --i) {
                    IMAPMessage imapMessage = (IMAPMessage)messages[i];
                    long uid = folder.getUID((Message)imapMessage);
                    EmailListDTO eDTO = this.messageToEmailListDTO(messages[i], uid);
                    if (eDTO.getCreateTime() == null) {
                        eDTO.setCreateTime(messages[i].getReceivedDate());
                    }
                    emailReceiverDTOList.add(eDTO);
                }
                if (!"Sent".equals(folderName)) {
                    emailReceiverDTOList = emailReceiverDTOList.stream().sorted(EmailListDTO.getComparator()).collect(Collectors.toList());
                }
            }
        }
        this.getPersonData(folder, emailReceiverDTOList);
        folder.close(true);
        receiveMailSession.close();
        return Y9Page.success((int)page, (int)totalPage, (long)totalCount, emailReceiverDTOList);
    }

    @Override
    public void move(long[] uids, String originFolderName, String toFolderName) throws MessagingException {
        IMAPFolder toFolder;
        ReceiveMailSession receiveMailSession = this.createReceiveMailSession();
        receiveMailSession.open();
        IMAPFolder originFolder = (IMAPFolder)receiveMailSession.getFolder(originFolderName);
        if (!originFolder.exists()) {
            originFolder = (IMAPFolder)receiveMailSession.getFolder(DefaultFolder.MY_FOLDER.getName()).getFolder(originFolderName);
        }
        if (!(toFolder = (IMAPFolder)receiveMailSession.getFolder(toFolderName)).exists()) {
            toFolder.create(1);
        }
        originFolder.open(2);
        toFolder.open(2);
        Message[] messages = originFolder.getMessagesByUID(uids);
        originFolder.copyMessages(messages, (Folder)toFolder);
        originFolder.setFlags(messages, new Flags(Flags.Flag.DELETED), true);
        originFolder.close(true);
        toFolder.close(true);
        receiveMailSession.close();
    }

    @Override
    public void quickReply(String folderName, Long uid, String richText) throws Exception {
        EmailDTO replyEmail = this.reply(folderName, uid);
        replyEmail.setRichText(richText + replyEmail.getRichText());
        replyEmail.setText(richText);
        String messageId = this.save(replyEmail);
        this.send(messageId);
    }

    @Override
    public void read(String folderName, long[] uids, Boolean isRead) throws Exception {
        ReceiveMailSession receiveMailSession = this.createReceiveMailSession();
        receiveMailSession.open();
        IMAPFolder folder = (IMAPFolder)receiveMailSession.getFolder(folderName);
        if (folder.exists()) {
            folder.open(2);
            Message[] msgs = folder.getMessagesByUID(uids);
            folder.setFlags(msgs, new Flags(Flags.Flag.SEEN), isRead.booleanValue());
            folder.close(true);
        }
        receiveMailSession.close();
    }

    @Override
    public EmailDTO reply(String folderName, Long uid) throws Exception {
        EmailDTO email = this.findByFolderAndUid(folderName, uid);
        EmailDTO replyEmail = EmailServiceImpl.buildReplyEmail(folderName, email);
        replyEmail.setToEmailAddressList(Collections.singletonList(email.getFrom()));
        return replyEmail;
    }

    @Override
    public EmailDTO replyAll(String folderName, Long uid) throws Exception {
        EmailDTO email = this.findByFolderAndUid(folderName, uid);
        EmailDTO replyEmail = EmailServiceImpl.buildReplyEmail(folderName, email);
        ArrayList<String> toEmailAddressList = new ArrayList<String>();
        toEmailAddressList.add(email.getFrom());
        toEmailAddressList.addAll(email.getToEmailAddressList());
        toEmailAddressList.addAll(email.getCcEmailAddressList());
        toEmailAddressList.remove(EmailThreadLocalHolder.getEmailAddress());
        replyEmail.setToEmailAddressList(toEmailAddressList);
        return replyEmail;
    }

    @Override
    public String save(EmailDTO email) throws Exception {
        MimeMessage mimeMessage;
        ReceiveMailSession receiveMailSession = this.createReceiveMailSession();
        receiveMailSession.open();
        Session session = receiveMailSession.getSession();
        IMAPFolder draftsFolder = (IMAPFolder)receiveMailSession.getFolder(DefaultFolder.DRAFTS.getName());
        draftsFolder.open(2);
        IMAPFolder folder = null;
        if (StringUtils.isNotBlank((CharSequence)email.getReplyMessageId())) {
            folder = (IMAPFolder)receiveMailSession.getFolder(email.getFolder());
            if (!folder.exists()) {
                folder = (IMAPFolder)receiveMailSession.getFolder(DefaultFolder.MY_FOLDER.getName()).getFolder(email.getFolder());
            }
            folder.open(2);
            Message originMessage = this.getMessage(folder, email.getReplyMessageId());
            mimeMessage = (MimeMessage)originMessage.reply(false);
            mimeMessage.setReplyTo(originMessage.getReplyTo());
            this.setBody(mimeMessage, email);
        } else if (StringUtils.isNotBlank((CharSequence)email.getForwardMessageId())) {
            folder = (IMAPFolder)receiveMailSession.getFolder(email.getFolder());
            if (!folder.exists()) {
                folder = (IMAPFolder)receiveMailSession.getFolder(DefaultFolder.MY_FOLDER.getName()).getFolder(email.getFolder());
            }
            folder.open(2);
            MimeMessage originMessage = (MimeMessage)this.getMessage(folder, email.getForwardMessageId());
            mimeMessage = new MimeMessage(originMessage){

                protected void updateMessageID() throws MessagingException {
                    super.setHeader("Message-ID", EmailServiceImpl.this.generateUniqueMessageId());
                }
            };
            this.setAlternativeContent((MimePart)mimeMessage, email.getText(), email.getRichText());
        } else if (StringUtils.isNotBlank((CharSequence)email.getMessageId())) {
            MimeMessage originMessage = (MimeMessage)this.getMessage(draftsFolder, email.getMessageId());
            final String originMessageId = originMessage.getMessageID();
            mimeMessage = new MimeMessage(originMessage){

                protected void updateMessageID() throws MessagingException {
                    super.setHeader("Message-ID", originMessageId);
                }
            };
            this.setAlternativeContent((MimePart)mimeMessage, email.getText(), email.getRichText());
            draftsFolder.setFlags(new Message[]{originMessage}, new Flags(Flags.Flag.DELETED), true);
        } else {
            mimeMessage = new MimeMessage(session){

                protected void updateMessageID() throws MessagingException {
                    super.setHeader("Message-ID", EmailServiceImpl.this.generateUniqueMessageId());
                }
            };
            this.setBody(mimeMessage, email);
            EmailServiceImpl.setMailer(mimeMessage);
        }
        this.setSubject(mimeMessage, email.getSubject());
        this.setFrom(mimeMessage);
        this.setRecipients(mimeMessage, email.getToEmailAddressList(), email.getCcEmailAddressList(), email.getBccEmailAddressList());
        mimeMessage.saveChanges();
        draftsFolder.appendMessages(new Message[]{mimeMessage});
        draftsFolder.close(true);
        if (folder != null) {
            folder.close();
        }
        receiveMailSession.close();
        return mimeMessage.getMessageID();
    }

    @Override
    public Y9Page<EmailListDTO> search(EmailSearchDTO searchDTO, int page, int size) throws MessagingException, IOException {
        ReceiveMailSession receiveMailSession = this.createReceiveMailSession();
        receiveMailSession.open();
        List<EmailListDTO> emailListDTOList = new ArrayList<EmailListDTO>();
        SearchTerm searchTerm = this.buildSearchTerm(searchDTO);
        int totalCount = 0;
        int totalPage = 0;
        if (StringUtils.isNotBlank((CharSequence)searchDTO.getFolder())) {
            IMAPFolder folder = (IMAPFolder)receiveMailSession.getFolder(searchDTO.getFolder());
            if (folder.exists()) {
                IMAPFolder[] messages;
                folder.open(2);
                for (IMAPFolder message : messages = folder.search(searchTerm)) {
                    long uid = folder.getUID((Message)message);
                    EmailListDTO eDTO = this.messageToEmailListDTO((Message)message, uid);
                    if (eDTO.getCreateTime() == null) {
                        eDTO.setCreateTime(message.getReceivedDate());
                    }
                    emailListDTOList.add(eDTO);
                }
                this.getPersonData(folder, emailListDTOList);
                folder.close(true);
            }
        } else {
            IMAPFolder[] folders;
            for (IMAPFolder folder : folders = (IMAPFolder[])receiveMailSession.getService().getDefaultFolder().list("*")) {
                Message[] messages;
                if ((folder.getType() & 1) == 0) continue;
                folder.open(1);
                for (Message message : messages = folder.search(searchTerm)) {
                    long uid = folder.getUID(message);
                    EmailListDTO eDTO = this.messageToEmailListDTO(message, uid);
                    if (eDTO.getCreateTime() == null) {
                        eDTO.setCreateTime(message.getReceivedDate());
                    }
                    emailListDTOList.add(eDTO);
                }
                this.getPersonData(folder, emailListDTOList);
                folder.close(true);
            }
        }
        totalCount = emailListDTOList.size();
        totalPage = totalCount / size + 1;
        int end = page * size;
        int start = (page - 1) * size;
        if (end > totalCount) {
            end = totalCount;
        }
        emailListDTOList = emailListDTOList.stream().sorted(EmailListDTO.getComparator()).collect(Collectors.toList());
        emailListDTOList = emailListDTOList.subList(start, end);
        receiveMailSession.close();
        return Y9Page.success((int)page, (int)totalPage, (long)totalCount, emailListDTOList);
    }

    @Override
    public int todoCount(String folder) {
        ReceiveMailSession receiveMailSession = this.createReceiveMailSession();
        receiveMailSession.open();
        IMAPFolder folder1 = (IMAPFolder)receiveMailSession.getFolder(folder);
        ArrayList emailListDTOList = new ArrayList();
        EmailSearchDTO searchDTO = new EmailSearchDTO();
        searchDTO.setRead(false);
        searchDTO.setFolder(folder);
        SearchTerm searchTerm = this.buildSearchTerm(searchDTO);
        try {
            if (folder1.exists()) {
                folder1.open(2);
                Message[] messages = folder1.search(searchTerm);
                return messages.length;
            }
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        return 0;
    }

    private SearchTerm buildSearchTerm(EmailSearchDTO searchDTO) {
        ArrayList<Object> searchTermList = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)searchDTO.getSubject())) {
            searchTermList.add((Object)new MySubjectTerm(searchDTO.getSubject()));
        } else {
            searchTermList.add((Object)new MySubjectTerm(""));
        }
        if (StringUtils.isNotBlank((CharSequence)searchDTO.getText())) {
            searchTermList.add((Object)new MyBodyTerm(searchDTO.getText()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchDTO.getFrom())) {
            searchTermList.add((Object)new MyFormTerm(searchDTO.getFrom()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchDTO.getTo())) {
            searchTermList.add((Object)new MyReceiverTerm(searchDTO.getTo()));
        }
        if (searchDTO.getStartDate() != null) {
            OrTerm startDateTerm = new OrTerm(new SearchTerm[]{new SentDateTerm(6, searchDTO.getStartDate()), new ReceivedDateTerm(6, searchDTO.getStartDate())});
            searchTermList.add(startDateTerm);
        }
        if (searchDTO.getEndDate() != null) {
            OrTerm endDateTerm = new OrTerm(new SearchTerm[]{new SentDateTerm(1, searchDTO.getEndDate()), new ReceivedDateTerm(1, searchDTO.getEndDate())});
            searchTermList.add(endDateTerm);
        }
        if (searchDTO.getAttachment() != null) {
            searchTermList.add((Object)new MyAttachmentTerm("", searchDTO.getAttachment()));
        }
        if (searchDTO.getRead() != null) {
            searchTermList.add((Object)new MyFlagTerm(new Flags(Flags.Flag.SEEN), searchDTO.getRead()));
        }
        if (searchDTO.getFlagged() != null) {
            searchTermList.add((Object)new MyFlagTerm(new Flags(Flags.Flag.FLAGGED), searchDTO.getFlagged()));
        }
        return new AndTerm(searchTermList.toArray(new SearchTerm[searchTermList.size()]));
    }

    @Override
    public void send(String messageId) throws MessagingException, IOException {
        ReceiveMailSession receiveMailSession = this.createReceiveMailSession();
        receiveMailSession.open();
        SendMailSession sendMailSession = this.createSendMailSession();
        sendMailSession.open();
        IMAPFolder draftsFolder = (IMAPFolder)receiveMailSession.getFolder(DefaultFolder.DRAFTS.getName());
        draftsFolder.open(2);
        MimeMessage originMessage = (MimeMessage)this.getMessage(draftsFolder, messageId);
        final String originMessageId = originMessage.getMessageID();
        MimeMessage message = new MimeMessage(originMessage){

            protected void updateMessageID() throws MessagingException {
                super.setHeader("Message-ID", originMessageId);
            }
        };
        ArrayList<String> cidList = new ArrayList<String>();
        this.setHtml4Send((MimePart)message, cidList);
        this.addPictures((MimeMultipart)message.getContent(), cidList);
        message.saveChanges();
        Transport transport = sendMailSession.getService();
        transport.sendMessage((Message)message, message.getAllRecipients());
        draftsFolder.setFlags(new Message[]{originMessage}, new Flags(Flags.Flag.DELETED), true);
        sendMailSession.close();
        draftsFolder.close(true);
        receiveMailSession.close();
    }

    @Override
    public List<EmailContactDTO> contactPerson() throws MessagingException, IOException {
        ReceiveMailSession receiveMailSession = this.createReceiveMailSession();
        receiveMailSession.open();
        ArrayList<EmailContactDTO> contactDTOList = new ArrayList<EmailContactDTO>();
        ArrayList<EmailListDTO> emailReceiverDTOList = new ArrayList<EmailListDTO>();
        IMAPFolder folderSent = (IMAPFolder)receiveMailSession.getFolder("Sent");
        if (!folderSent.exists()) {
            folderSent = (IMAPFolder)receiveMailSession.getFolder(DefaultFolder.MY_FOLDER.getName()).getFolder("Sent");
        }
        if (folderSent.exists()) {
            folderSent.open(1);
            Message[] messagesSent = folderSent.getMessages(1, folderSent.getMessageCount() <= 20 ? folderSent.getMessageCount() : 20);
            if (messagesSent != null && messagesSent.length > 0) {
                for (int i = messagesSent.length - 1; i >= 0; --i) {
                    IMAPMessage imapMessage = (IMAPMessage)messagesSent[i];
                    long uid = folderSent.getUID((Message)imapMessage);
                    emailReceiverDTOList.add(this.messageToEmailListDTO(messagesSent[i], uid));
                }
            }
        }
        this.getEmailContactDTOList(folderSent, emailReceiverDTOList, contactDTOList);
        folderSent.close(true);
        emailReceiverDTOList = new ArrayList();
        IMAPFolder folderINBOX = (IMAPFolder)receiveMailSession.getFolder("INBOX");
        if (!folderINBOX.exists()) {
            folderINBOX = (IMAPFolder)receiveMailSession.getFolder(DefaultFolder.MY_FOLDER.getName()).getFolder("INBOX");
        }
        if (folderINBOX.exists()) {
            folderINBOX.open(1);
            Message[] messagesINBOX = folderINBOX.getMessages(1, folderINBOX.getMessageCount() <= 20 ? folderINBOX.getMessageCount() : 20);
            if (messagesINBOX != null && messagesINBOX.length > 0) {
                for (int i = messagesINBOX.length - 1; i >= 0; --i) {
                    IMAPMessage imapMessage = (IMAPMessage)messagesINBOX[i];
                    long uid = folderINBOX.getUID((Message)imapMessage);
                    emailReceiverDTOList.add(this.messageToEmailListDTO(messagesINBOX[i], uid));
                }
            }
        }
        this.getEmailContactDTOList(folderINBOX, emailReceiverDTOList, contactDTOList);
        folderINBOX.close(true);
        receiveMailSession.close();
        return contactDTOList;
    }

    private EmailListDTO messageToEmailListDTO(Message message, Long uid) throws IOException, MessagingException {
        EmailListDTO emailListDTO = new EmailListDTO();
        emailListDTO.setUid(uid);
        emailListDTO.setCreateTime(message.getSentDate());
        emailListDTO.setSubject(message.getSubject());
        emailListDTO.setRead(message.getFlags().contains(Flags.Flag.SEEN));
        emailListDTO.setFlagged(message.getFlags().contains(Flags.Flag.FLAGGED));
        emailListDTO.setEmailType(1);
        emailListDTO.setFolder(message.getFolder().getName());
        emailListDTO.setFolderStr(this.getFolderString(message));
        emailListDTO.setFromPersonName(this.getFromString(message));
        emailListDTO.setAttachment(EmailServiceImpl.isHasAttachment(message));
        emailListDTO.setAttachmentSize(EmailServiceImpl.getAttachmentSize(message));
        emailListDTO.setToPersonNames(this.getToString(message.getAllRecipients()));
        try {
            MimeMessage mm = (MimeMessage)message;
            MimeMessageParser parser = null;
            parser = new MimeMessageParser(mm).parse();
            if (parser != null) {
                emailListDTO.setText(parser.getPlainContent());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return emailListDTO;
    }

    private String getFolderString(Message message) {
        String folder = message.getFolder().getName();
        return "INBOX".equals(folder) ? "\u6536\u4ef6\u7bb1" : ("Sent".equals(folder) ? "\u5df2\u53d1\u9001" : ("Trash".equals(folder) ? "\u56de\u6536\u7ad9" : ("Drafts".equals(folder) ? "\u8349\u7a3f\u7bb1" : folder)));
    }

    private String getFromString(Message message) throws MessagingException {
        InternetAddress internetAddress = (InternetAddress)message.getFrom()[0];
        return internetAddress.getAddress().split("@")[0];
    }

    private String getToString(Address[] to) {
        String toPerson = "";
        if (null != to) {
            toPerson = Arrays.stream(to).map(address -> ((InternetAddress)address).getAddress().split("@")[0]).collect(Collectors.joining(";"));
        }
        return toPerson;
    }

    private <T extends EmailDTO> T parseToEmail(MimeMessage mimeMessage, Class<T> tClass) throws Exception {
        EmailDTO email = (EmailDTO)tClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        MimeMessageParser parser = new MimeMessageParser(mimeMessage).parse();
        email.setFolder(mimeMessage.getFolder().getName());
        email.setMessageId(mimeMessage.getMessageID());
        email.setSubject(parser.getSubject());
        email.setFrom(parser.getFrom());
        email.setSendTime(mimeMessage.getSentDate());
        email.setRichText(this.getRichText(parser));
        email.setEmailAttachmentDTOList(this.parseEmailAttachmentList(parser.getAttachmentList()));
        email.setToEmailAddressList(this.getEmailAddressList(parser, Message.RecipientType.TO));
        email.setCcEmailAddressList(this.getEmailAddressList(parser, Message.RecipientType.CC));
        email.setBccEmailAddressList(this.getEmailAddressList(parser, Message.RecipientType.BCC));
        return (T)email;
    }

    private String getRichText(MimeMessageParser parser) throws IOException {
        String htmlContent = parser.getHtmlContent();
        Collection<String> inlineImageContentIds = parser.getInlineContentIds();
        for (String inlineImageContentId : inlineImageContentIds) {
            DataSource dataSource = parser.findInlineByCid(inlineImageContentId);
            byte[] bytes = IOUtils.toByteArray((InputStream)dataSource.getInputStream());
            String imageContent = "data:image/png;base64," + Base64.encodeToString((byte[])bytes);
            htmlContent = htmlContent.replace("cid:" + inlineImageContentId, imageContent);
        }
        return htmlContent;
    }

    private List<String> getEmailAddressList(MimeMessageParser parser, Message.RecipientType recipientType) throws Exception {
        if (recipientType == Message.RecipientType.TO) {
            return parser.getTo().stream().map(address -> ((InternetAddress)address).getAddress()).collect(Collectors.toList());
        }
        if (recipientType == Message.RecipientType.CC) {
            return parser.getCc().stream().map(address -> ((InternetAddress)address).getAddress()).collect(Collectors.toList());
        }
        return parser.getBcc().stream().map(address -> ((InternetAddress)address).getAddress()).collect(Collectors.toList());
    }

    private String generateUniqueMessageId() {
        return String.format("<%s@%s>", Y9IdGenerator.genId(), this.y9WebMailProperties.getHost());
    }

    private MimeBodyPart getBaseBodyPart(MimeMultipart mimeMultipart) throws MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setContent((Multipart)mimeMultipart);
        return bodyPart;
    }

    private boolean isMimeType(MimePart part, String mimeType) throws MessagingException, IOException {
        try {
            ContentType ct = new ContentType(part.getDataHandler().getContentType());
            return ct.match(mimeType);
        }
        catch (ParseException ex) {
            return part.getContentType().equalsIgnoreCase(mimeType);
        }
    }

    private void setAlternativeContent(MimePart part, String text, String html) throws MessagingException, IOException {
        if (this.isMimeType(part, "text/plain") && !"attachment".equalsIgnoreCase(part.getDisposition())) {
            part.setContent((Object)text, "text/plain;charset=UTF-8");
        } else if (this.isMimeType(part, "text/html") && !"attachment".equalsIgnoreCase(part.getDisposition())) {
            part.setContent((Object)html, "text/html;charset=UTF-8");
        } else if (this.isMimeType(part, "multipart/*")) {
            Multipart mp = (Multipart)part.getContent();
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                this.setAlternativeContent((MimePart)((MimeBodyPart)mp.getBodyPart(i)), text, html);
            }
        }
    }

    private void setBody(MimeMessage mimeMessage, EmailDTO email) throws Exception {
        MimeMultipart rootMimeMultipart = new MimeMultipart();
        MimeMultipart alternativeMultipart = new MimeMultipart("alternative");
        this.addHtml(alternativeMultipart, email.getRichText());
        this.addText(alternativeMultipart, email.getText());
        rootMimeMultipart.addBodyPart((BodyPart)this.getBaseBodyPart(alternativeMultipart));
        mimeMessage.setContent((Multipart)rootMimeMultipart);
    }

    private void setFrom(MimeMessage mimeMessage) throws MessagingException, UnsupportedEncodingException {
        UserInfo userInfo = Y9LoginUserHolder.getUserInfo();
        mimeMessage.setFrom((Address)new InternetAddress(EmailThreadLocalHolder.getEmailAddress(), userInfo.getName(), "UTF-8"));
    }

    private void setHtml4Send(MimePart part, List<String> cidList) throws MessagingException, IOException {
        if (!this.isMimeType(part, "text/plain") || "attachment".equalsIgnoreCase(part.getDisposition())) {
            if (this.isMimeType(part, "text/html") && !"attachment".equalsIgnoreCase(part.getDisposition())) {
                String richText = (String)part.getContent();
                String patternStr = "<img\\s*([^>]*)\\s*src=\\\"(.*?)\\\"\\s*([^>]*)>";
                Pattern pattern = Pattern.compile(patternStr, 2);
                Matcher matcher = pattern.matcher(richText);
                String result = richText;
                while (matcher.find()) {
                    String src = matcher.group(2);
                    int index = src.indexOf(Y9Context.getSystemName());
                    if (index == -1) continue;
                    try {
                        String fileName = src.substring(src.lastIndexOf("/") + 1);
                        String fileId = FilenameUtils.getBaseName((String)fileName);
                        String replaceSrc = "cid:" + fileId;
                        if (StringUtils.isNotBlank((CharSequence)replaceSrc)) {
                            result = result.replaceAll(src, replaceSrc);
                        }
                        cidList.add(fileId);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                part.setContent((Object)result, "text/html;charset=UTF-8");
            } else if (this.isMimeType(part, "multipart/*")) {
                Multipart mp = (Multipart)part.getContent();
                int count = mp.getCount();
                for (int i = 0; i < count; ++i) {
                    this.setHtml4Send((MimePart)((MimeBodyPart)mp.getBodyPart(i)), cidList);
                }
            }
        }
    }

    private void setRecipients(MimeMessage mimeMessage, List<String> toPersonIdList, List<String> ccPersonIdList, List<String> bccPersonIdList) throws MessagingException {
        this.setRecipients(mimeMessage, toPersonIdList, Message.RecipientType.TO);
        this.setRecipients(mimeMessage, ccPersonIdList, Message.RecipientType.CC);
        this.setRecipients(mimeMessage, bccPersonIdList, Message.RecipientType.BCC);
    }

    private void setRecipients(MimeMessage mimeMessage, List<String> toPersonIdList, Message.RecipientType recipientType) throws MessagingException {
        if (toPersonIdList != null) {
            int toSize = toPersonIdList.size();
            Address[] toAddress = new Address[toSize];
            for (int i = 0; i < toSize; ++i) {
                toAddress[i] = new InternetAddress(toPersonIdList.get(i));
            }
            mimeMessage.setRecipients(recipientType, toAddress);
        }
    }

    private void setSubject(MimeMessage mimeMessage, String subject) throws MessagingException {
        mimeMessage.setSubject(subject);
    }

    @Override
    public Map<String, Object> addressRelevancy(String search) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String tenantId = Y9LoginUserHolder.getTenantId();
        List orgUnitList = (List)this.orgUnitApi.treeSearch(tenantId, search, OrgTreeTypeEnum.TREE_TYPE_PERSON).getData();
        ArrayList<Person> orgUnits = new ArrayList<Person>();
        for (OrgUnit ou : orgUnitList) {
            if (!OrgTypeEnum.PERSON.getEnName().equals(ou.getOrgType().getEnName())) continue;
            Person person = (Person)ou;
            String email = this.jamesUserService.getEmailAddressByPersonId(ou.getId());
            if (StringUtils.isEmpty((CharSequence)email)) {
                email = "\u672a\u6ce8\u518c\u90ae\u7bb1";
            } else {
                person.setEmail(email);
            }
            orgUnits.add(person);
        }
        map.put("business", orgUnits);
        List<JamesAddressBook> jamesAddressBookList = this.jamesAddressBookService.findSearch(search);
        map.put("personal", jamesAddressBookList);
        try {
            List<EmailContactDTO> emailContactDTOList = this.contactPerson();
            ArrayList<EmailContactDTO> emailContactDTOs = new ArrayList<EmailContactDTO>();
            for (EmailContactDTO ec : emailContactDTOList) {
                if ((!StringUtils.isNotBlank((CharSequence)ec.getContactPerson()) || ec.getContactPerson().indexOf(search) == -1) && (!StringUtils.isNotBlank((CharSequence)ec.getContactPersonName()) || ec.getContactPersonName().indexOf(search) == -1)) continue;
                emailContactDTOs.add(ec);
            }
            map.put("recently", emailContactDTOs);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    @Override
    public EmailDTO newEmail() {
        EmailDTO email = new EmailDTO();
        email.setRichText(EmailUtil.getSignature());
        return email;
    }
}

