/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import com.sun.mail.imap.IMAPFolder;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.mail.ReceiveMailSession;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.controller.dto.EmailAttachmentDTO;
import net.risesoft.james.service.JamesUserService;
import net.risesoft.service.EmailAttachmentService;
import net.risesoft.service.impl.MailHelper;
import net.risesoft.support.DefaultFolder;
import net.risesoft.y9.configuration.app.y9webmail.Y9WebMailProperties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class EmailAttachmentServiceImpl
extends MailHelper
implements EmailAttachmentService {
    public EmailAttachmentServiceImpl(Y9WebMailProperties y9WebMailProperties, JamesUserService jamesUserService, PersonApi personApi) {
        super(y9WebMailProperties, jamesUserService, personApi);
    }

    private static Set<String> getFileNameSet(MimeMultipart originMimeMultipart) throws MessagingException {
        HashSet<String> fileNameSet = new HashSet<String>();
        for (int i = 0; i < originMimeMultipart.getCount(); ++i) {
            BodyPart bodyPart = originMimeMultipart.getBodyPart(i);
            if (!"attachment".equalsIgnoreCase(bodyPart.getDisposition())) continue;
            fileNameSet.add(bodyPart.getFileName());
        }
        return fileNameSet;
    }

    @Override
    public void download(String folderName, String messageId, String name, HttpServletResponse response, HttpServletRequest request) throws IOException, MessagingException {
        InputStream inputStream = null;
        String filename = name;
        filename = request.getHeader("User-Agent").toLowerCase().indexOf("firefox") > 0 ? new String(filename.getBytes(StandardCharsets.UTF_8), "ISO8859-1") : URLEncoder.encode(filename, StandardCharsets.UTF_8);
        ServletOutputStream out = response.getOutputStream();
        response.reset();
        response.setHeader("Content-disposition", "attachment; filename=\"" + filename + "\"");
        response.setHeader("Content-type", "text/html;charset=UTF-8");
        response.setContentType("application/octet-stream");
        ReceiveMailSession receiveMailSession = this.createReceiveMailSession();
        receiveMailSession.open();
        Folder folder = receiveMailSession.getFolder(folderName);
        if (!folder.exists()) {
            folder = receiveMailSession.getFolder(DefaultFolder.MY_FOLDER.getName()).getFolder(folderName);
        }
        folder.open(1);
        Message message = this.getMessage((IMAPFolder)folder, messageId);
        MimeMultipart mimeMultipart = (MimeMultipart)message.getContent();
        for (int i = 0; i < mimeMultipart.getCount(); ++i) {
            BodyPart bodyPart = mimeMultipart.getBodyPart(i);
            String disposition = bodyPart.getDisposition();
            if (!StringUtils.isNotBlank((CharSequence)disposition) || !disposition.equals("attachment") || !name.equals(bodyPart.getFileName())) continue;
            inputStream = bodyPart.getInputStream();
            int len = 0;
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer, 0, buffer.length)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        out.flush();
        out.close();
        if (inputStream != null) {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batchDownload(String folderName, String messageId, HttpServletRequest request, HttpServletResponse response) {
        DataOutputStream dataOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        ServletOutputStream outputStream = null;
        Object fileName = null;
        try {
            outputStream = response.getOutputStream();
            ReceiveMailSession receiveMailSession = this.createReceiveMailSession();
            receiveMailSession.open();
            Folder folder = receiveMailSession.getFolder(folderName);
            if (!folder.exists()) {
                folder = receiveMailSession.getFolder(DefaultFolder.MY_FOLDER.getName()).getFolder(folderName);
            }
            folder.open(1);
            Message message = this.getMessage((IMAPFolder)folder, messageId);
            MimeMultipart mimeMultipart = (MimeMultipart)message.getContent();
            fileName = message.getSubject() + "_\u9644\u4ef6\u6253\u5305.zip";
            String userAgent = request.getHeader("User-Agent");
            if (userAgent.contains("MSIE") || userAgent.contains("Trident")) {
                fileName = URLEncoder.encode((String)fileName, StandardCharsets.UTF_8);
                fileName = ((String)fileName).replaceAll("\\+", "%20");
            } else {
                fileName = new String(((String)fileName).getBytes(StandardCharsets.UTF_8), "ISO8859-1");
            }
            response.setContentType("text/html;charset=UTF-8");
            response.setContentType("application/octet-stream");
            response.setHeader("Content-disposition", "attachment;filename=\"" + (String)fileName + "\"");
            try {
                zipOutputStream = new ZipOutputStream(new BufferedOutputStream((OutputStream)outputStream));
                zipOutputStream.setMethod(8);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (int i = 0; i < mimeMultipart.getCount(); ++i) {
                BodyPart bodyPart = mimeMultipart.getBodyPart(i);
                String disposition = bodyPart.getDisposition();
                if (!StringUtils.isNotBlank((CharSequence)disposition) || !disposition.equals("attachment")) continue;
                try {
                    zipOutputStream.putNextEntry(new ZipEntry(bodyPart.getFileName()));
                    dataOutputStream = new DataOutputStream(zipOutputStream);
                    InputStream is = bodyPart.getInputStream();
                    byte[] b = new byte[100];
                    int length = 0;
                    while ((length = is.read(b)) != -1) {
                        dataOutputStream.write(b, 0, length);
                    }
                    is.close();
                    zipOutputStream.closeEntry();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dataOutputStream != null) {
                    dataOutputStream.flush();
                    dataOutputStream.close();
                }
                if (outputStream != null) {
                    outputStream.flush();
                    outputStream.close();
                }
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public EmailAttachmentDTO addAttachment(String folder, String messageId, MultipartFile file) throws MessagingException, IOException {
        ReceiveMailSession receiveMailSession = this.createReceiveMailSession();
        receiveMailSession.open();
        IMAPFolder draftsFolder = (IMAPFolder)receiveMailSession.getFolder(DefaultFolder.DRAFTS.getName());
        draftsFolder.open(2);
        MimeMessage originMessage = (MimeMessage)this.getMessage(draftsFolder, messageId);
        final String originMessageId = originMessage.getMessageID();
        MimeMessage message = new MimeMessage(originMessage){

            protected void updateMessageID() throws MessagingException {
                super.setHeader("Message-ID", originMessageId);
            }
        };
        MimeMultipart mimeMultipart = (MimeMultipart)message.getContent();
        Set<String> fileNameSet = EmailAttachmentServiceImpl.getFileNameSet(mimeMultipart);
        String fileName = this.getUniqueFileName(fileNameSet, file.getOriginalFilename());
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        ByteArrayDataSource dataSource = new ByteArrayDataSource(file.getBytes(), new MimetypesFileTypeMap().getContentType(fileName));
        dataSource.setName(fileName);
        DataHandler dataHandler = new DataHandler((DataSource)dataSource);
        mimeBodyPart.setDataHandler(dataHandler);
        mimeBodyPart.setFileName(fileName);
        mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
        message.saveChanges();
        draftsFolder.setFlags(new Message[]{originMessage}, new Flags(Flags.Flag.DELETED), true);
        draftsFolder.addMessages(new Message[]{message});
        draftsFolder.close();
        receiveMailSession.close();
        return EmailAttachmentServiceImpl.parseEmailAttachment((DataSource)dataSource);
    }

    @Override
    public void removeAttachment(String folder, String messageId, String fileName) throws MessagingException, IOException {
        ReceiveMailSession receiveMailSession = this.createReceiveMailSession();
        receiveMailSession.open();
        IMAPFolder draftsFolder = (IMAPFolder)receiveMailSession.getFolder(DefaultFolder.DRAFTS.getName());
        draftsFolder.open(2);
        MimeMessage originMessage = (MimeMessage)this.getMessage(draftsFolder, messageId);
        final String originMessageId = originMessage.getMessageID();
        MimeMessage message = new MimeMessage(originMessage){

            protected void updateMessageID() throws MessagingException {
                super.setHeader("Message-ID", originMessageId);
            }
        };
        MimeMultipart originMimeMultipart = (MimeMultipart)message.getContent();
        for (int i = 0; i < originMimeMultipart.getCount(); ++i) {
            BodyPart bodyPart = originMimeMultipart.getBodyPart(i);
            if (!"attachment".equalsIgnoreCase(bodyPart.getDisposition()) || !Objects.equals(fileName, bodyPart.getFileName())) continue;
            originMimeMultipart.removeBodyPart(i);
        }
        message.saveChanges();
        draftsFolder.setFlags(new Message[]{originMessage}, new Flags(Flags.Flag.DELETED), true);
        draftsFolder.addMessages(new Message[]{message});
        draftsFolder.close();
        receiveMailSession.close();
    }

    private String getUniqueFileName(Set<String> fileNameSet, String originalFilename) {
        String baseName = FilenameUtils.getBaseName((String)originalFilename);
        String extension = FilenameUtils.getExtension((String)originalFilename);
        int i = 1;
        while (fileNameSet.contains(originalFilename)) {
            originalFilename = String.format("%s(%d).%s", baseName, i++, extension);
        }
        return originalFilename;
    }
}

