/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.listener;

import lombok.Generated;
import net.risesoft.james.service.JamesUserService;
import net.risesoft.model.platform.Department;
import net.risesoft.model.platform.Person;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.pubsub.event.Y9EventOrg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class Y9EventOrgListener
implements ApplicationListener<Y9EventOrg> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JamesUserService jamesUserService;

    public void onApplicationEvent(Y9EventOrg event) {
        this.logger.info(event.getEventType());
        String tenantId = event.getTenantId();
        Y9LoginUserHolder.setTenantId((String)tenantId);
        try {
            if ("RISEORGEVENT_TYPE_ADD_PERSON".equals(event.getEventType())) {
                Person person = (Person)event.getOrgObj();
                this.logger.info("--------------------------\u65b0\u589e\u4eba\u5458-------------------------------");
                this.logger.info("--------------------" + person.getName() + "---------------------");
                this.jamesUserService.add(person.getId(), person.getLoginName());
            } else if ("RISEORGEVENT_TYPE_UPDATE_PERSON".equals(event.getEventType())) {
                Person person = (Person)event.getOrgObj();
                this.logger.info("--------------------------\u4fee\u6539\u4eba\u5458-------------------------------");
                this.logger.info("--------------------" + person.getName() + "---------------------");
            } else if ("RISEORGEVENT_TYPE_DELETE_DEPARTMENT".equals(event.getEventType())) {
                Department newDept = (Department)event.getOrgObj();
                this.logger.info("--------------------------\u5220\u9664\u90e8\u95e8-------------------------------");
                this.logger.info("--------------------" + newDept.getName() + "---------------------");
            } else if ("RISEORGEVENT_TYPE_DELETE_PERSON".equals(event.getEventType())) {
                Person person = (Person)event.getOrgObj();
                this.logger.info("--------------------------\u5220\u9664\u4eba\u5458-------------------------------");
                this.logger.info("--------------------" + person.getName() + "---------------------");
                this.jamesUserService.delete(person);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Generated
    public Y9EventOrgListener(JamesUserService jamesUserService) {
        this.jamesUserService = jamesUserService;
    }
}

