/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.james.entity.term;

import java.io.IOException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.search.StringTerm;

public final class MyBodyTerm
extends StringTerm {
    public MyBodyTerm(String pattern) {
        super(pattern);
    }

    public boolean match(Message msg) {
        return this.matchPart((Part)msg);
    }

    private boolean matchPart(Part p) {
        try {
            if (p.isMimeType("text/*")) {
                String s = (String)p.getContent();
                if (s == null) {
                    return false;
                }
                return super.match(s);
            }
            if (p.isMimeType("multipart/*")) {
                Multipart mp = (Multipart)p.getContent();
                int count = mp.getCount();
                for (int i = 0; i < count; ++i) {
                    if (!this.matchPart((Part)mp.getBodyPart(i))) continue;
                    return true;
                }
            } else if (p.isMimeType("message/rfc822")) {
                return this.matchPart((Part)p.getContent());
            }
        }
        catch (IOException | RuntimeException | MessagingException throwable) {
            // empty catch block
        }
        return false;
    }
}

