/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.risesoft.james.service.JamesUserService;
import net.risesoft.model.user.UserInfo;
import net.risesoft.support.EmailThreadLocalHolder;
import net.risesoft.y9.Y9Context;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;

public class EmailAddressFilter
implements Filter {
    public void destroy() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            UserInfo userInfo = Y9LoginUserHolder.getUserInfo();
            if (userInfo != null) {
                JamesUserService jamesUserService = (JamesUserService)Y9Context.getBean(JamesUserService.class);
                String emailAddress = jamesUserService.getEmailAddressByPersonId(userInfo.getPersonId());
                if (StringUtils.isNotBlank((CharSequence)emailAddress)) {
                    EmailThreadLocalHolder.setEmailAddress(emailAddress);
                } else {
                    jamesUserService.add(userInfo.getPersonId(), userInfo.getLoginName());
                }
            }
            chain.doFilter(request, response);
        }
        finally {
            Y9LoginUserHolder.clear();
        }
    }
}

