/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller.rest;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.OrganizationApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.controller.dto.EmailAttachmentDTO;
import net.risesoft.controller.dto.EmailDTO;
import net.risesoft.controller.dto.EmailDetailDTO;
import net.risesoft.controller.dto.EmailFolderDTO;
import net.risesoft.controller.dto.EmailListDTO;
import net.risesoft.controller.dto.EmailSearchDTO;
import net.risesoft.enums.platform.OrgTreeTypeEnum;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.james.entity.JamesAddressBook;
import net.risesoft.james.service.JamesAddressBookService;
import net.risesoft.james.service.JamesUserService;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Organization;
import net.risesoft.model.platform.Person;
import net.risesoft.model.user.UserInfo;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.EmailAttachmentService;
import net.risesoft.service.EmailFolderService;
import net.risesoft.service.EmailService;
import net.risesoft.support.EmailThreadLocalHolder;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/mobile"}, produces={"application/json"})
public class EmailMobileController {
    private final EmailService emailService;
    private final PersonApi personApi;
    private final EmailAttachmentService emailAttachmentService;
    private final EmailFolderService emailFolderService;
    private final OrgUnitApi orgUnitApi;
    private final OrganizationApi organizationApi;
    private final JamesUserService jamesUserService;
    private final JamesAddressBookService jamesAddressBookService;

    @DeleteMapping(value={"/email"})
    public Y9Result<Object> delete(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, @RequestParam(value="uids") long[] uids, String folder) throws MessagingException {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        this.emailService.delete(folder, uids);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @DeleteMapping(value={"/permanently"})
    public Y9Result<Object> deletePermanently(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, @RequestParam(value="uids") long[] uids, String folder) throws MessagingException {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        this.emailService.deletePermanently(folder, uids);
        return Y9Result.successMsg((String)"\u6c38\u4e45\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/{folder}/{uid}"})
    public Y9Result<EmailDetailDTO> detail(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, @PathVariable String folder, @PathVariable long uid) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        EmailDetailDTO email = this.emailService.detail(folder, uid);
        return Y9Result.success((Object)email);
    }

    @GetMapping(value={"/exportEml"})
    public void exportEml(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, String folder, int uid, HttpServletResponse response, HttpServletRequest request) throws MessagingException, IOException {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        this.emailService.exportEml(folder, uid, response, request);
    }

    @PostMapping(value={"/flag"})
    public Y9Result<Object> flag(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, @RequestParam(value="uids") long[] uids, @RequestParam String folder, boolean flagged) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        this.emailService.flag(folder, uids, flagged);
        return Y9Result.successMsg((String)"\u6807\u661f\u6210\u529f");
    }

    @GetMapping(value={"/forward/{folder}/{uid}"})
    public Y9Result<EmailDTO> forward(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, @PathVariable String folder, @PathVariable long uid) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        return Y9Result.success((Object)this.emailService.forward(folder, uid));
    }

    @GetMapping(value={"/list"})
    public Y9Page<EmailListDTO> list(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, int page, @RequestParam int size, @RequestParam(required=false) String folder) throws IOException, MessagingException {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        return this.emailService.listByFolder(folder, page, size);
    }

    @PostMapping(value={"/move"})
    public Y9Result<Object> move(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, @RequestParam(value="uids") long[] uids, String originFolder, String toFolder) throws MessagingException {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        this.emailService.move(uids, originFolder, toFolder);
        return Y9Result.successMsg((String)"\u79fb\u52a8\u6210\u529f");
    }

    @PostMapping(value={"/read"})
    public Y9Result<Object> read(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, @RequestParam(value="uids") long[] uids, @RequestParam String folder, @RequestParam Boolean isRead) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        this.emailService.read(folder, uids, isRead);
        return Y9Result.success();
    }

    @GetMapping(value={"/reply/{folder}/{uid}"})
    public Y9Result<EmailDTO> reply(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, @PathVariable String folder, @PathVariable Long uid) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        return Y9Result.success((Object)this.emailService.reply(folder, uid));
    }

    @PostMapping(value={"/quickReply/{folder}/{uid}"})
    public Y9Result<EmailDTO> quickReply(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, @PathVariable String folder, @PathVariable Long uid, @RequestParam String richText) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        this.emailService.quickReply(folder, uid, richText);
        return Y9Result.successMsg((String)"\u5feb\u6377\u56de\u590d\u6210\u529f");
    }

    @GetMapping(value={"/replyAll/{folder}/{uid}"})
    public Y9Result<EmailDTO> replyAll(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, @PathVariable String folder, @PathVariable Long uid) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        return Y9Result.success((Object)this.emailService.replyAll(folder, uid));
    }

    @PostMapping(value={"/save"})
    public Y9Result<String> save(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, EmailDTO email) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        String messageId = this.emailService.save(email);
        return Y9Result.success((Object)messageId, (String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/search"})
    public Y9Page<EmailListDTO> search(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, EmailSearchDTO searchDTO) throws MessagingException, IOException {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        return this.emailService.search(searchDTO, searchDTO.getPage(), searchDTO.getSize());
    }

    @PostMapping(value={"/send"})
    public Y9Result<Object> send(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, String messageId) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        this.emailService.send(messageId);
        return Y9Result.successMsg((String)"\u53d1\u9001\u6210\u529f");
    }

    @GetMapping(value={"/todoList"})
    public Y9Result<Object> todoList(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId) throws MessagingException {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        String personId = Y9LoginUserHolder.getUserInfo().getPersonId();
        Map<String, Object> todoList = this.emailService.getTodoCount(personId);
        return Y9Result.success(todoList);
    }

    @PostMapping(value={"/addAttachment"})
    public Y9Result<EmailAttachmentDTO> addAttachment(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, String folder, String messageId, MultipartFile file) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        EmailAttachmentDTO emailAttachmentDTO = this.emailAttachmentService.addAttachment(folder, messageId, file);
        return Y9Result.success((Object)emailAttachmentDTO);
    }

    @RequestMapping(value={"/download"})
    public void download(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, String folder, String messageId, String fileName, HttpServletResponse response, HttpServletRequest request) {
        try {
            Y9LoginUserHolder.setTenantId((String)tenantId);
            Person person = (Person)this.personApi.get(tenantId, userId).getData();
            Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
            String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
            EmailThreadLocalHolder.setEmailAddress(emailAddress);
            this.emailAttachmentService.download(folder, messageId, fileName, response, request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/batchDownload"})
    public void batchDownload(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, String folder, String messageId, HttpServletRequest request, HttpServletResponse response) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        this.emailAttachmentService.batchDownload(folder, messageId, request, response);
    }

    @DeleteMapping(value={"/deleteAttachment"})
    public Y9Result<Object> deleteAttachment(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, String folder, String messageId, String fileName) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        this.emailAttachmentService.removeAttachment(folder, messageId, fileName);
        return Y9Result.success();
    }

    @PostMapping(value={"/folder"})
    public Y9Result<Object> save(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, String originFolderName, String newFolderName) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        this.emailFolderService.save(originFolderName, newFolderName);
        return Y9Result.success();
    }

    @DeleteMapping(value={"/folder"})
    public Y9Result<Object> delete(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, String folder) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        this.emailFolderService.delete(folder);
        return Y9Result.success();
    }

    @GetMapping(value={"/folder/customList"})
    public Y9Result<List<EmailFolderDTO>> customList(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId) throws MessagingException {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        List<EmailFolderDTO> emailFolderList = this.emailFolderService.list();
        return Y9Result.success(emailFolderList);
    }

    @GetMapping(value={"/allList"})
    public Y9Result<Map<String, Object>> list(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId) throws MessagingException {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        List<EmailFolderDTO> customFolderList = this.emailFolderService.list();
        List<EmailFolderDTO> defaultFolderList = this.emailFolderService.getDefaultFolderList();
        HashMap<String, List<EmailFolderDTO>> data = new HashMap<String, List<EmailFolderDTO>>();
        data.put("customFolderList", customFolderList);
        data.put("defaultFolderList", defaultFolderList);
        return Y9Result.success(data);
    }

    @RequestMapping(value={"/getOrgTree"})
    public Y9Result<List<OrgUnit>> getOrgTree(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, @RequestParam(required=false) String id, @RequestParam(required=false) OrgTreeTypeEnum treeType, @RequestParam(required=false) String name) {
        List<OrgUnit> orgUnitList;
        List organizationList;
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        if (StringUtils.isBlank((CharSequence)id) && (organizationList = (List)this.organizationApi.list(tenantId).getData()) != null && organizationList.size() > 0) {
            id = ((Organization)organizationList.get(0)).getId();
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            orgUnitList = (List<OrgUnit>)this.orgUnitApi.treeSearch(tenantId, name, treeType).getData();
            orgUnitList = this.mapEmailAddress(orgUnitList);
        } else {
            orgUnitList = (List)this.orgUnitApi.getSubTree(tenantId, id, treeType).getData();
            orgUnitList = this.mapEmailAddress(orgUnitList);
        }
        return Y9Result.success(orgUnitList);
    }

    private List<OrgUnit> mapEmailAddress(List<OrgUnit> orgUnitList) {
        orgUnitList = orgUnitList.stream().peek(org -> {
            if (OrgTypeEnum.PERSON.equals((Object)org.getOrgType())) {
                Person person = (Person)org;
                String email = this.jamesUserService.getEmailAddressByPersonId(org.getId());
                if (StringUtils.isEmpty((CharSequence)email) && StringUtils.isEmpty((CharSequence)person.getEmail())) {
                    email = "\u672a\u6ce8\u518c\u90ae\u7bb1";
                } else {
                    if (!StringUtils.isEmpty((CharSequence)email)) {
                        person.setEmail(email);
                    }
                    if (!StringUtils.isEmpty((CharSequence)person.getEmail())) {
                        email = person.getEmail();
                    }
                }
                person.setName(org.getName() + "(" + email + ")");
            }
        }).collect(Collectors.toList());
        return orgUnitList;
    }

    @GetMapping(value={"/getPersonData"})
    public Y9Result<Map<String, String>> getPersonData(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId) {
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", person.getName());
        map.put("emailAddress", emailAddress);
        map.put("avator", person.getAvator());
        return Y9Result.success(map);
    }

    @GetMapping(value={"/contact"})
    public Y9Result<Object> contact(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId) throws MessagingException, IOException {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        return Y9Result.success(this.emailService.contactPerson());
    }

    @PostMapping(value={"/addressBookSave"})
    public Y9Result<Object> addressBookSave(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, JamesAddressBook jamesAddressBook) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        return Y9Result.success((Object)this.jamesAddressBookService.saveOrUpdate(jamesAddressBook), (String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/addressBooksearch"})
    public Y9Result<Object> addressBooksearch(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, String search) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        return Y9Result.success(this.jamesAddressBookService.findSearch(search));
    }

    @GetMapping(value={"/addressBook"})
    public Y9Result<Object> addressBook(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String email = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(email);
        return Y9Result.success((Object)this.jamesAddressBookService.findOne(id));
    }

    @GetMapping(value={"/addressBookList"})
    public Y9Result<Object> addressBookList(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        return Y9Result.success(this.jamesAddressBookService.findAll());
    }

    @DeleteMapping(value={"/addressBookDelete"})
    public Y9Result<Object> addressBookDelete(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, String id) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String email = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(email);
        this.jamesAddressBookService.delete(id);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/addressRelevancy"})
    public Y9Result<Object> addressRelevancy(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId, String search) {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String email = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(email);
        return Y9Result.success(this.emailService.addressRelevancy(search));
    }

    @GetMapping(value={"/unread"})
    public Y9Result<Object> unread(@RequestHeader(value="auth-tenantId") String tenantId, @RequestHeader(value="auth-userId") String userId) throws Exception {
        Y9LoginUserHolder.setTenantId((String)tenantId);
        Person person = (Person)this.personApi.get(tenantId, userId).getData();
        Y9LoginUserHolder.setUserInfo((UserInfo)person.toUserInfo());
        String personId = Y9LoginUserHolder.getUserInfo().getPersonId();
        String emailAddress = this.jamesUserService.getEmailAddressByPersonId(userId);
        EmailThreadLocalHolder.setEmailAddress(emailAddress);
        int conunt = this.emailService.todoCount("INBOX");
        return Y9Result.success((Object)conunt);
    }

    @Generated
    public EmailMobileController(EmailService emailService, PersonApi personApi, EmailAttachmentService emailAttachmentService, EmailFolderService emailFolderService, OrgUnitApi orgUnitApi, OrganizationApi organizationApi, JamesUserService jamesUserService, JamesAddressBookService jamesAddressBookService) {
        this.emailService = emailService;
        this.personApi = personApi;
        this.emailAttachmentService = emailAttachmentService;
        this.emailFolderService = emailFolderService;
        this.orgUnitApi = orgUnitApi;
        this.organizationApi = organizationApi;
        this.jamesUserService = jamesUserService;
        this.jamesAddressBookService = jamesAddressBookService;
    }
}

