/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.List;
import lombok.Generated;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.james.service.JamesUserService;
import net.risesoft.model.platform.Person;
import net.risesoft.pojo.Y9Result;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="standardSyncController")
@RequestMapping(value={"/api/standard"})
public class SyncController {
    private final JamesUserService jamesUserService;
    private final PersonApi personApi;

    @RequestMapping(value={"/syncUsers"})
    public Y9Result<String> syncUsers() {
        String tenantId = Y9LoginUserHolder.getTenantId();
        List personList = (List)this.personApi.list(tenantId).getData();
        int allcount = personList.size();
        int disabledcount = 0;
        int deletedcount = 0;
        int successcount = 0;
        int errorcount = 0;
        Object errorNames = "";
        for (Person person : personList) {
            if (Boolean.TRUE.equals(person.getDisabled())) {
                ++disabledcount;
                continue;
            }
            try {
                this.jamesUserService.add(person.getId(), person.getLoginName());
                ++successcount;
            }
            catch (Exception e) {
                errorNames = StringUtils.isBlank((CharSequence)errorNames) ? errorcount + "\u3001" + person.getName() + "(" + person.getLoginName() + ")" : (String)errorNames + "</br>" + ++errorcount + "\u3001" + person.getName() + "(" + person.getLoginName() + ")";
                e.printStackTrace();
            }
        }
        String msg = "\u603b\u5171\uff1a" + allcount + "\u4eba</br>\u7981\u7528\uff1a" + disabledcount + "\u4eba</br>\u5220\u9664\uff1a" + deletedcount + "\u4eba</br>\u6210\u529f\uff1a" + successcount + "\u4eba</br>\u5931\u8d25\uff1a" + errorcount + "\u4eba</br>\u5931\u8d25\u4eba\u5458\u5217\u8868\uff1a" + (String)errorNames;
        return Y9Result.success((Object)msg);
    }

    @Generated
    public SyncController(JamesUserService jamesUserService, PersonApi personApi) {
        this.jamesUserService = jamesUserService;
        this.personApi = personApi;
    }
}

