/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.risesoft.api.platform.customgroup.CustomGroupApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.model.platform.CustomGroup;
import net.risesoft.model.platform.CustomGroupMember;
import net.risesoft.model.platform.Person;
import net.risesoft.pojo.Y9Result;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="standardGroupController")
@RequestMapping(value={"/api/standard/group"})
public class GroupController {
    private final CustomGroupApi customGroupApi;
    private final PersonApi personApi;

    @RequestMapping(value={"/getAllGroups"})
    public Y9Result<List<CustomGroup>> getAllGroups() {
        String tenantId = Y9LoginUserHolder.getTenantId();
        String personId = Y9LoginUserHolder.getUserInfo().getPersonId();
        List customGroupList = (List)this.customGroupApi.listCustomGroupByPersonId(tenantId, personId).getData();
        return Y9Result.success((Object)customGroupList);
    }

    @ResponseBody
    @RequestMapping(value={"/getGroupMembers4Email"})
    public Y9Result<List<CustomGroupMember>> getEmailGroupMembers(String groupId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        String personId = Y9LoginUserHolder.getUserInfo().getPersonId();
        List groupMemberModels = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)groupId)) {
            groupMemberModels = (List)this.customGroupApi.listCustomGroupMemberByGroupId(tenantId, personId, groupId).getData();
        }
        return Y9Result.success(groupMemberModels);
    }

    @RequestMapping(value={"/getGroupMembers"})
    public Y9Result<List<CustomGroupMember>> getGroupMembers(String groupId) {
        String tenantId = Y9LoginUserHolder.getTenantId();
        String personId = Y9LoginUserHolder.getUserInfo().getPersonId();
        List groupMemberModels = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)groupId)) {
            groupMemberModels = (List)this.customGroupApi.listCustomGroupMemberByGroupId(tenantId, personId, groupId).getData();
        }
        for (CustomGroupMember customGroupModel : groupMemberModels) {
            Person person;
            if (!customGroupModel.getMemberType().equals((Object)OrgTypeEnum.PERSON) || (person = (Person)this.personApi.get(tenantId, customGroupModel.getMemberId()).getData()) == null || !StringUtils.isNotBlank((CharSequence)person.getMobile())) continue;
            customGroupModel.setMemberName(customGroupModel.getMemberName() + "(" + person.getMobile() + ")");
        }
        return Y9Result.success(groupMemberModels);
    }

    @RequestMapping(value={"/getGroups4Email"})
    public Y9Result<List<CustomGroup>> getGroups4Email() {
        String tenantId = Y9LoginUserHolder.getTenantId();
        String personId = Y9LoginUserHolder.getUserInfo().getPersonId();
        List customGroupList = (List)this.customGroupApi.listCustomGroupByPersonId(tenantId, personId).getData();
        return Y9Result.success((Object)customGroupList);
    }

    @Generated
    public GroupController(CustomGroupApi customGroupApi, PersonApi personApi) {
        this.customGroupApi = customGroupApi;
        this.personApi = personApi;
    }
}

