/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.controller.dto.EmailContactDTO;
import net.risesoft.controller.dto.EmailDTO;
import net.risesoft.controller.dto.EmailDetailDTO;
import net.risesoft.controller.dto.EmailListDTO;
import net.risesoft.controller.dto.EmailSearchDTO;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.EmailService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="standardEmailController")
@RequestMapping(value={"/api/standard/email"})
public class EmailController {
    private final EmailService emailService;
    private final PersonApi personApi;

    @PostMapping(value={"/delete"})
    public Y9Result<Object> delete(@RequestParam(value="uids") long[] uids, String folder) throws MessagingException {
        this.emailService.delete(folder, uids);
        return Y9Result.successMsg((String)"\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/deletePermanently"})
    public Y9Result<Object> deletePermanently(@RequestParam(value="uids") long[] uids, String folder) throws MessagingException {
        this.emailService.deletePermanently(folder, uids);
        return Y9Result.successMsg((String)"\u6c38\u4e45\u5220\u9664\u6210\u529f");
    }

    @GetMapping(value={"/{folder}/{uid}"})
    public Y9Result<EmailDetailDTO> detail(@PathVariable String folder, @PathVariable long uid) throws Exception {
        EmailDetailDTO email = this.emailService.detail(folder, uid);
        return Y9Result.success((Object)email);
    }

    @GetMapping(value={"/exportEml"})
    public void exportEml(String folder, int uid, HttpServletResponse response, HttpServletRequest request) throws MessagingException, IOException {
        this.emailService.exportEml(folder, uid, response, request);
    }

    @PostMapping(value={"/flag"})
    public Y9Result<Object> flag(@RequestParam(value="uids") long[] uids, @RequestParam String folder, boolean flagged) throws Exception {
        this.emailService.flag(folder, uids, flagged);
        if (flagged) {
            return Y9Result.successMsg((String)"\u6807\u661f\u6210\u529f");
        }
        return Y9Result.successMsg((String)"\u53d6\u6d88\u6807\u661f\u6210\u529f");
    }

    @GetMapping(value={"/newEmail"})
    public Y9Result<EmailDTO> newEmail() throws Exception {
        return Y9Result.success((Object)this.emailService.newEmail());
    }

    @GetMapping(value={"/forward/{folder}/{uid}"})
    public Y9Result<EmailDTO> forward(@PathVariable String folder, @PathVariable long uid) throws Exception {
        return Y9Result.success((Object)this.emailService.forward(folder, uid));
    }

    @GetMapping(value={"/list"})
    public Y9Page<EmailListDTO> list(int page, @RequestParam int size, @RequestParam(required=false) String folder) throws IOException, MessagingException {
        return this.emailService.listByFolder(folder, page, size);
    }

    @PostMapping(value={"/move"})
    public Y9Result<Object> move(@RequestParam(value="uids") long[] uids, String originFolder, String toFolder) throws MessagingException {
        this.emailService.move(uids, originFolder, toFolder);
        return Y9Result.successMsg((String)"\u79fb\u52a8\u6210\u529f");
    }

    @PostMapping(value={"/read"})
    public Y9Result<Object> read(@RequestParam(value="uids") long[] uids, @RequestParam String folder, @RequestParam Boolean isRead) throws Exception {
        this.emailService.read(folder, uids, isRead);
        return Y9Result.success();
    }

    @GetMapping(value={"/reply/{folder}/{uid}"})
    public Y9Result<EmailDTO> reply(@PathVariable String folder, @PathVariable Long uid) throws Exception {
        return Y9Result.success((Object)this.emailService.reply(folder, uid));
    }

    @PostMapping(value={"/quickReply/{folder}/{uid}"})
    public Y9Result<EmailDTO> quickReply(@PathVariable String folder, @PathVariable Long uid, @RequestParam String richText) throws Exception {
        this.emailService.quickReply(folder, uid, richText);
        return Y9Result.successMsg((String)"\u5feb\u6377\u56de\u590d\u6210\u529f");
    }

    @GetMapping(value={"/replyAll/{folder}/{uid}"})
    public Y9Result<EmailDTO> replyAll(@PathVariable String folder, @PathVariable Long uid) throws Exception {
        return Y9Result.success((Object)this.emailService.replyAll(folder, uid));
    }

    @PostMapping
    public Y9Result<String> save(EmailDTO email) throws Exception {
        String messageId = this.emailService.save(email);
        return Y9Result.success((Object)messageId, (String)"\u4fdd\u5b58\u6210\u529f");
    }

    @GetMapping(value={"/search"})
    public Y9Page<EmailListDTO> search(EmailSearchDTO searchDTO) throws MessagingException, IOException {
        return this.emailService.search(searchDTO, searchDTO.getPage(), searchDTO.getSize());
    }

    @PostMapping(value={"/send"})
    public Y9Result<Object> send(String messageId) throws Exception {
        this.emailService.send(messageId);
        return Y9Result.successMsg((String)"\u53d1\u9001\u6210\u529f");
    }

    @GetMapping(value={"/todoList"})
    public Y9Result<Object> todoList() throws MessagingException {
        String personId = Y9LoginUserHolder.getUserInfo().getPersonId();
        Map<String, Object> todoList = this.emailService.getTodoCount(personId);
        return Y9Result.success(todoList);
    }

    @ResponseBody
    @RequestMapping(value={"/contact"})
    public Y9Result<Object> contactPerson() throws MessagingException, IOException {
        List<EmailContactDTO> contactPerson = this.emailService.contactPerson();
        return Y9Result.success(contactPerson);
    }

    @GetMapping(value={"/addressRelevancy"})
    public Y9Result<Object> addressRelevancy(String search) {
        return Y9Result.success(this.emailService.addressRelevancy(search));
    }

    @Generated
    public EmailController(EmailService emailService, PersonApi personApi) {
        this.emailService = emailService;
        this.personApi = personApi;
    }
}

