/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import net.risesoft.controller.dto.EmailAttachmentDTO;
import net.risesoft.pojo.Y9Result;
import net.risesoft.service.EmailAttachmentService;
import net.risesoft.y9.Y9Context;
import net.risesoft.y9.configuration.Y9Properties;
import net.risesoft.y9public.entity.Y9FileStore;
import net.risesoft.y9public.service.Y9FileStoreService;
import org.apache.commons.io.FilenameUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController(value="standardEmailAttachmentController")
@RequestMapping(value={"/api/standard/emailAttachment"})
public class EmailAttachmentController {
    private final EmailAttachmentService emailAttachmentService;
    private final Y9FileStoreService y9FileStoreService;
    private final Y9Properties y9Properties;

    @PostMapping
    public Y9Result<EmailAttachmentDTO> addAttachment(String folder, String messageId, MultipartFile file) throws Exception {
        EmailAttachmentDTO emailAttachmentDTO = this.emailAttachmentService.addAttachment(folder, messageId, file);
        return Y9Result.success((Object)emailAttachmentDTO);
    }

    @RequestMapping(value={"/batchDownload"})
    public void batchDownload(String folder, String messageId, HttpServletRequest request, HttpServletResponse response) {
        this.emailAttachmentService.batchDownload(folder, messageId, request, response);
    }

    @PostMapping(value={"/delete"})
    public Y9Result<Object> deleteAttachment(String folder, String messageId, String fileName) throws Exception {
        this.emailAttachmentService.removeAttachment(folder, messageId, fileName);
        return Y9Result.success();
    }

    @RequestMapping(value={"/download"})
    public void download(String folder, String messageId, String fileName, HttpServletResponse response, HttpServletRequest request) {
        try {
            this.emailAttachmentService.download(folder, messageId, fileName, response, request);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PostMapping(value={"/uploadFile"})
    public Y9Result<String> uploadFile(MultipartFile file) throws Exception {
        String originalFilename = file.getOriginalFilename();
        String fileName = FilenameUtils.getName((String)originalFilename);
        String fullPath = Y9FileStore.buildPath((String[])new String[]{Y9Context.getSystemName()});
        Y9FileStore y9FileStore = this.y9FileStoreService.uploadFile(file, fullPath, fileName);
        String webmailBaseUrl = this.y9Properties.getCommon().getWebmailBaseUrl();
        return Y9Result.success((Object)(webmailBaseUrl + "/s/" + y9FileStore.getRealFileName()));
    }

    @Generated
    public EmailAttachmentController(EmailAttachmentService emailAttachmentService, Y9FileStoreService y9FileStoreService, Y9Properties y9Properties) {
        this.emailAttachmentService = emailAttachmentService;
        this.y9FileStoreService = y9FileStoreService;
        this.y9Properties = y9Properties;
    }
}

