/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import java.util.List;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import jodd.mail.SendMailSession;
import net.risesoft.model.user.UserInfo;
import net.risesoft.service.EmailMessageService;
import net.risesoft.service.impl.MailHelper;
import net.risesoft.support.EmailThreadLocalHolder;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9public.entity.Y9FileStore;
import net.risesoft.y9public.service.Y9FileStoreService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmailMessageServiceImpl
extends MailHelper
implements EmailMessageService {
    @Autowired
    private Y9FileStoreService y9FileStoreService;

    @Override
    public void send(Integer messageNumber, String subject, String richText, List<String> emailAddressList, List<String> ccEmailAddressList, List<String> bccEmailAddressList, List<String> attachmentIdList) throws Exception {
        SendMailSession sendMailSession = this.createSendMailSession();
        sendMailSession.open();
        Session session = sendMailSession.getSession();
        MimeMessage mimeMessage = this.createEmail(session, emailAddressList, ccEmailAddressList, bccEmailAddressList, subject, richText, attachmentIdList);
        Transport transport = sendMailSession.getService();
        transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
        sendMailSession.close();
    }

    public MimeMessage createEmail(Session session, List<String> toJamesUserIds, List<String> ccJamesUserIds, List<String> bccJamesUserIds, String title, String body, List<String> attachmentIdList) throws Exception {
        int i;
        UserInfo userInfo = Y9LoginUserHolder.getUserInfo();
        MimeMessage message = new MimeMessage(session);
        message.setFrom((Address)new InternetAddress(EmailThreadLocalHolder.getEmailAddress(), userInfo.getName(), "UTF-8"));
        if (toJamesUserIds != null) {
            int toSize = toJamesUserIds.size();
            Address[] toAddress = new Address[toSize];
            for (i = 0; i < toSize; ++i) {
                toAddress[i] = new InternetAddress(toJamesUserIds.get(i));
            }
            message.setRecipients(Message.RecipientType.TO, toAddress);
        }
        if (ccJamesUserIds != null) {
            int ccSize = ccJamesUserIds.size();
            Address[] ccAddress = new Address[ccSize];
            for (i = 0; i < ccSize; ++i) {
                ccAddress[i] = new InternetAddress(ccJamesUserIds.get(i));
            }
            message.setRecipients(Message.RecipientType.CC, ccAddress);
        }
        if (bccJamesUserIds != null) {
            int bccSize = bccJamesUserIds.size();
            Address[] bccAddress = new Address[bccSize];
            for (i = 0; i < bccSize; ++i) {
                bccAddress[i] = new InternetAddress(bccJamesUserIds.get(i));
            }
            message.setRecipients(Message.RecipientType.BCC, bccAddress);
        }
        message.setSubject(title);
        MimeMultipart mimeMultipart = new MimeMultipart();
        MimeBodyPart bodyPart = new MimeBodyPart();
        bodyPart.setContent((Object)body, "text/html;charset=UTF-8");
        mimeMultipart.addBodyPart((BodyPart)bodyPart);
        if (attachmentIdList != null) {
            MimeBodyPart mimeBodyPart = null;
            for (String attachmentId : attachmentIdList) {
                mimeBodyPart = new MimeBodyPart();
                byte[] bytes = this.y9FileStoreService.downloadFileToBytes(attachmentId);
                Y9FileStore y9FileStore = this.y9FileStoreService.getById(attachmentId);
                ByteArrayDataSource dataSource = new ByteArrayDataSource(bytes, new MimetypesFileTypeMap().getContentType(y9FileStore.getFileName()));
                DataHandler dataHandler = new DataHandler((DataSource)dataSource);
                mimeBodyPart.setDataHandler(dataHandler);
                mimeBodyPart.setFileName(y9FileStore.getFileName());
                mimeMultipart.addBodyPart((BodyPart)mimeBodyPart);
            }
        }
        message.setContent((Multipart)mimeMultipart);
        message.saveChanges();
        return message;
    }
}

