/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.mail.Folder;
import javax.mail.MessagingException;
import jodd.mail.ReceiveMailSession;
import net.risesoft.controller.dto.EmailFolderDTO;
import net.risesoft.service.EmailFolderService;
import net.risesoft.service.impl.MailHelper;
import net.risesoft.support.DefaultFolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class EmailFolderServiceImpl
extends MailHelper
implements EmailFolderService {
    @Override
    public List<EmailFolderDTO> list() throws MessagingException {
        ArrayList<EmailFolderDTO> emailFolderList = new ArrayList<EmailFolderDTO>();
        ReceiveMailSession session = this.createReceiveMailSession();
        session.open();
        try {
            Folder myFolder = session.getFolder(DefaultFolder.MY_FOLDER.getName());
            if (myFolder.exists()) {
                Folder[] folders;
                for (Folder folder : folders = myFolder.list()) {
                    emailFolderList.add(new EmailFolderDTO(folder.getName(), folder.getFullName(), folder.getName()));
                }
            } else {
                myFolder.create(2);
            }
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        session.close();
        return emailFolderList;
    }

    @Override
    public List<EmailFolderDTO> getDefaultFolderList() {
        ReceiveMailSession session = this.createReceiveMailSession();
        session.open();
        ArrayList<EmailFolderDTO> emailFolderDTOList = new ArrayList<EmailFolderDTO>();
        List defaultFolderList = Arrays.stream(DefaultFolder.values()).filter(defaultFolder -> !defaultFolder.isExistSubFolder()).collect(Collectors.toList());
        for (DefaultFolder folder : defaultFolderList) {
            Folder mailFolder = session.getFolder(folder.getName());
            try {
                if (!mailFolder.exists()) {
                    mailFolder.create(1);
                }
            }
            catch (MessagingException e) {
                throw new RuntimeException(e);
            }
            emailFolderDTOList.add(new EmailFolderDTO(folder.getName(), folder.getName(), folder.getcName()));
        }
        session.close();
        return emailFolderDTOList;
    }

    @Override
    public void save(String originFolderName, String newFolderName) {
        ReceiveMailSession session = this.createReceiveMailSession();
        session.open();
        try {
            Folder myFolder = session.getFolder(DefaultFolder.MY_FOLDER.getName());
            Folder newFolder = myFolder.getFolder(newFolderName);
            if (StringUtils.isNotBlank((CharSequence)originFolderName)) {
                Folder originFolder = myFolder.getFolder(originFolderName);
                originFolder.renameTo(myFolder.getFolder(newFolderName));
            } else {
                newFolder.create(2);
            }
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        session.close();
    }

    @Override
    public void delete(String folderName) {
        ReceiveMailSession session = this.createReceiveMailSession();
        session.open();
        try {
            Folder myFolder = session.getFolder(DefaultFolder.MY_FOLDER.getName());
            myFolder.getFolder(folderName).delete(true);
        }
        catch (MessagingException e) {
            e.printStackTrace();
        }
        session.close();
    }
}

