/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.james.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.risesoft.api.platform.customgroup.CustomGroupApi;
import net.risesoft.api.platform.org.PersonApi;
import net.risesoft.enums.platform.ExtendedOrgTypeEnum;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.james.entity.JamesUser;
import net.risesoft.james.repository.JamesUserRepository;
import net.risesoft.james.service.JamesUserService;
import net.risesoft.model.platform.CustomGroupMember;
import net.risesoft.model.platform.Person;
import net.risesoft.util.EmailUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.configuration.Y9Properties;
import net.risesoft.y9.util.signing.Y9MessageDigest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="jamesUserService")
public class JamesUserServiceImpl
implements JamesUserService {
    private final CustomGroupApi customGroupApi;
    private final PersonApi personApi;
    private final Y9Properties y9Properties;
    private final JamesUserRepository jamesUserRepository;

    @Override
    public void add(String personId, String loginName) {
        Optional<JamesUser> jamesUserOptional = this.jamesUserRepository.findByPersonId(personId);
        if (!jamesUserOptional.isPresent()) {
            String emailAddress = EmailUtil.buildEmailAddress(loginName);
            int i = 1;
            while (this.jamesUserRepository.existsById(emailAddress)) {
                emailAddress = EmailUtil.buildEmailAddress(String.format("%s%d", loginName, i++));
            }
            String password = this.y9Properties.getCommon().getDefaultPassword();
            JamesUser jamesUser = new JamesUser();
            jamesUser.setEmailAddress(emailAddress);
            jamesUser.setVersion(1);
            jamesUser.setPasswordHashAlgorithm("MD5");
            jamesUser.setPlainText(password);
            jamesUser.setPersonId(personId);
            jamesUser.setPassword(Y9MessageDigest.md5((String)password));
            this.jamesUserRepository.save(jamesUser);
        }
    }

    private void addByPersonId(List<String> emailAddressList, String id) {
        String emailAddress = this.getEmailAddressByPersonId(id);
        if (StringUtils.isNotBlank((CharSequence)emailAddress)) {
            emailAddressList.add(emailAddress);
        }
    }

    @Override
    public JamesUser findById(String id) {
        return this.jamesUserRepository.findById(id).orElse(null);
    }

    @Override
    public JamesUser findByEmailAddress(String emailAddress) {
        return this.jamesUserRepository.findByEmailAddress(emailAddress).orElse(null);
    }

    @Override
    public List<String> getEmailAddressListByOrgUnitId(List<String> orgUnitIdList) {
        ArrayList<String> emailAddressList = new ArrayList<String>();
        for (String orgUnitId : orgUnitIdList) {
            emailAddressList.addAll(this.getEmailAddressListByOrgUnitId(orgUnitId));
        }
        return emailAddressList;
    }

    @Override
    public void delete(Person person) {
        this.jamesUserRepository.deleteByPersonId(person.getId());
    }

    private List<String> getEmailAddressListByOrgUnitId(String orgTypeAndOrgUnitId) {
        ArrayList<String> emailAddressList;
        block3: {
            String orgUnitId;
            String orgType;
            String tenantId;
            block4: {
                block2: {
                    emailAddressList = new ArrayList<String>();
                    tenantId = Y9LoginUserHolder.getTenantId();
                    String[] orgTypeAndOrgUnitIdArr = orgTypeAndOrgUnitId.split(":");
                    orgType = orgTypeAndOrgUnitIdArr[0];
                    orgUnitId = orgTypeAndOrgUnitIdArr[1];
                    if (!OrgTypeEnum.DEPARTMENT.getEnName().equals(orgType)) break block2;
                    List personList = (List)this.personApi.listRecursivelyByParentId(tenantId, orgUnitId).getData();
                    for (Person person : personList) {
                        this.addByPersonId(emailAddressList, person.getId());
                    }
                    break block3;
                }
                if (!OrgTypeEnum.PERSON.getEnName().equals(orgType)) break block4;
                this.addByPersonId(emailAddressList, orgUnitId);
                break block3;
            }
            if (!ExtendedOrgTypeEnum.CUSTOM_GROUP.getEnName().equals(orgType)) break block3;
            List groupMemberList = (List)this.customGroupApi.listCustomGroupMemberByGroupId(tenantId, Y9LoginUserHolder.getPersonId(), orgUnitId).getData();
            for (CustomGroupMember customGroupMember : groupMemberList) {
                this.addByPersonId(emailAddressList, customGroupMember.getMemberId());
            }
        }
        return emailAddressList;
    }

    @Override
    public String getEmailAddressByPersonId(String personId) {
        return this.jamesUserRepository.findEmailAddressByPersonId(personId);
    }

    @Override
    public List<String> getIdByPersonIDs(List<String> personIds) {
        return this.jamesUserRepository.findEmailAddressByPersonIds(personIds);
    }

    @Override
    public String getPlainTextByPersonId(String personId) {
        Optional<JamesUser> jamesUserOptional = this.jamesUserRepository.findByPersonId(personId);
        if (jamesUserOptional.isPresent()) {
            return jamesUserOptional.get().getPlainText();
        }
        return "";
    }

    @Override
    public void modifyPassword(String id, String plainText) {
        JamesUser oldju = this.findById(id);
        Integer version = oldju.getVersion() + 1;
        oldju.setPlainText(plainText);
        plainText = Y9MessageDigest.md5((String)plainText);
        oldju.setPassword(plainText);
        oldju.setVersion(version);
        this.jamesUserRepository.save(oldju);
    }

    @Generated
    public JamesUserServiceImpl(CustomGroupApi customGroupApi, PersonApi personApi, Y9Properties y9Properties, JamesUserRepository jamesUserRepository) {
        this.customGroupApi = customGroupApi;
        this.personApi = personApi;
        this.y9Properties = y9Properties;
        this.jamesUserRepository = jamesUserRepository;
    }
}

