/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.james.service.impl;

import java.util.List;
import net.risesoft.james.entity.JamesAddressBook;
import net.risesoft.james.repository.JamesAddressBookRepository;
import net.risesoft.james.service.JamesAddressBookService;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="jamesAddressBookService")
public class JamesAddressBookServiceImpl
implements JamesAddressBookService {
    @Autowired
    private JamesAddressBookRepository jamesAddressBookRepository;

    @Override
    public JamesAddressBook saveOrUpdate(JamesAddressBook jamesAddressBook) {
        if (StringUtils.isBlank((CharSequence)jamesAddressBook.getId())) {
            jamesAddressBook.setId(Y9LoginUserHolder.getUserInfo().getPersonId() + "-" + jamesAddressBook.getEmailAddress());
        }
        jamesAddressBook.setPersonId(Y9LoginUserHolder.getUserInfo().getPersonId());
        return (JamesAddressBook)this.jamesAddressBookRepository.save(jamesAddressBook);
    }

    @Override
    public void delete(String id) {
        if (this.jamesAddressBookRepository.findById(id).orElse(null) != null) {
            this.jamesAddressBookRepository.deleteById(id);
        }
    }

    @Override
    public JamesAddressBook findOne(String id) {
        return this.jamesAddressBookRepository.findById(id).orElse(null);
    }

    @Override
    public List<JamesAddressBook> findSearch(String search) {
        return this.jamesAddressBookRepository.findByPersonIdAndEmailAddressLikeOrNameLikeOrderByNameAsc(Y9LoginUserHolder.getUserInfo().getPersonId(), "%" + search + "%", "%" + search + "%");
    }

    @Override
    public List<JamesAddressBook> findAll() {
        return this.jamesAddressBookRepository.findByPersonIdOrderByNameAsc(Y9LoginUserHolder.getUserInfo().getPersonId());
    }
}

