/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.james.service.impl;

import com.google.common.collect.Lists;
import com.google.common.net.MediaType;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import lombok.Generated;
import net.risesoft.controller.dto.EmailAttachmentDTO;
import net.risesoft.controller.dto.EmailDTO;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.james.entity.ImportEml;
import net.risesoft.james.entity.ImportEmlAttchMents;
import net.risesoft.james.repository.ImportEmlRepository;
import net.risesoft.james.service.ImportEmlAttchMentsService;
import net.risesoft.james.service.ImportEmlService;
import net.risesoft.pojo.EmlResult;
import net.risesoft.pojo.Y9PageQuery;
import net.risesoft.service.EmailService;
import net.risesoft.util.EmailUtil;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.signing.Y9MessageDigest;
import net.risesoft.y9public.service.Y9FileStoreService;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.james.mime4j.dom.BinaryBody;
import org.apache.james.mime4j.dom.Body;
import org.apache.james.mime4j.dom.Entity;
import org.apache.james.mime4j.dom.Header;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.TextBody;
import org.apache.james.mime4j.dom.address.Address;
import org.apache.james.mime4j.dom.address.AddressList;
import org.apache.james.mime4j.dom.address.Mailbox;
import org.apache.james.mime4j.dom.address.MailboxList;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.field.ContentTypeFieldLenientImpl;
import org.apache.james.mime4j.message.MultipartImpl;
import org.apache.james.mime4j.stream.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="importEmlService")
public class ImportEmlServiceImpl
implements ImportEmlService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportEmlServiceImpl.class);
    private final ImportEmlRepository importEmlRepository;
    private final ImportEmlAttchMentsService importEmlAttchMentsService;
    private final Y9FileStoreService y9FileStoreService;
    private final EmailService emailService;

    private List<Pair<String, String>> addressToList(AddressList addressList) {
        ArrayList list = Lists.newArrayList();
        if (addressList == null) {
            return list;
        }
        for (Address address : addressList) {
            Mailbox mailbox = (Mailbox)address;
            String name = mailbox.getName();
            if (StringUtils.isBlank((CharSequence)name)) {
                name = mailbox.getLocalPart();
            }
            list.add(Pair.of((Object)name, (Object)mailbox.getAddress()));
        }
        return list;
    }

    private String addressToString(AddressList addressList) {
        StringBuilder sb = new StringBuilder();
        if (addressList == null || addressList.isEmpty()) {
            return sb.toString();
        }
        for (Address address : addressList) {
            Mailbox mailbox = (Mailbox)address;
            String name = mailbox.getName();
            if (StringUtils.isBlank((CharSequence)name)) {
                name = mailbox.getLocalPart();
            }
            sb.append(name + "<" + mailbox.getAddress() + ">,");
        }
        String addressStr = sb.toString();
        return addressStr.substring(0, addressStr.length() - 1);
    }

    private String addressToString(MailboxList addressList) {
        if (addressList == null) {
            return "";
        }
        Iterator iterator = addressList.iterator();
        if (iterator.hasNext()) {
            Address address = (Address)iterator.next();
            return address.toString();
        }
        return "";
    }

    @Override
    @Transactional(readOnly=false)
    public void delete(List<String> ids) {
        if (!ids.isEmpty()) {
            for (String id : ids) {
                this.importEmlRepository.deleteById(id);
            }
        }
    }

    @Override
    public void forward(String id) throws Exception {
        Optional emlOptional = this.importEmlRepository.findById(id);
        if (emlOptional.isPresent()) {
            ImportEml eml = (ImportEml)emlOptional.get();
            EmailDTO email = new EmailDTO();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            email.setFolder("INBOX");
            email.setSubject(eml.getSubject());
            email.setFrom(eml.getFrom());
            email.setSendTime(sdf.parse(eml.getDateTime()));
            email.setRichText(eml.getHtmlContent());
            if (Boolean.TRUE.equals(eml.getExistAttchMent())) {
                List<ImportEmlAttchMents> attchsList = this.importEmlAttchMentsService.listByImportEmlId(id);
                ArrayList<EmailAttachmentDTO> emailAttachmentDTOList = new ArrayList<EmailAttachmentDTO>();
                for (ImportEmlAttchMents attch : attchsList) {
                    EmailAttachmentDTO emailAttachmentDTO = new EmailAttachmentDTO();
                    emailAttachmentDTO.setFileExt(attch.getFileExt());
                    byte[] bytes = this.y9FileStoreService.downloadFileToBytes(attch.getFileStoreId());
                    emailAttachmentDTO.setMd5(Y9MessageDigest.md5((byte[])bytes));
                    emailAttachmentDTO.setFileName(attch.getFileName());
                    emailAttachmentDTO.setDisplaySize(FileUtils.byteCountToDisplaySize((long)bytes.length));
                    emailAttachmentDTOList.add(emailAttachmentDTO);
                }
                email.setEmailAttachmentDTOList(emailAttachmentDTOList);
            }
            email.setToEmailAddressList(this.getEmailAddressList(EmailUtil.buildEmailAddress(Y9LoginUserHolder.getUserInfo().getLoginName())));
            email.setCcEmailAddressList(this.getEmailAddressList(eml.getCc()));
            email.setBccEmailAddressList(this.getEmailAddressList(eml.getBcc()));
            this.emailService.save(email);
        }
    }

    @Override
    public ImportEml getById(String id) {
        return this.importEmlRepository.findById(id).orElse(null);
    }

    private List<String> getEmailAddressList(String emailAddressList) {
        if (StringUtils.isBlank((CharSequence)emailAddressList)) {
            return Collections.emptyList();
        }
        String[] list = emailAddressList.split(",");
        ArrayList<String> addressList = new ArrayList<String>();
        for (String address : list) {
            if (address.indexOf("<") > -1) {
                addressList.add(address.substring(address.indexOf("<") + 1, address.indexOf(">")));
                continue;
            }
            addressList.add(address);
        }
        return addressList;
    }

    @Override
    public void importEmailByEml(Message message) throws IOException {
        EmlResult emlDTO = new EmlResult();
        emlDTO.setMessage(message);
        emlDTO.setMessageId(message.getMessageId());
        emlDTO.setSubject(message.getSubject());
        emlDTO.setFrom(this.addressToString(message.getFrom()));
        emlDTO.setTo(this.addressToList(message.getTo()));
        emlDTO.setCc(this.addressToList(message.getCc()));
        emlDTO.setBcc(this.addressToList(message.getBcc()));
        TimeZone timeZone = TimeZone.getTimeZone(ZoneId.of("GMT"));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(timeZone);
        emlDTO.setDateTime(sdf.format(message.getDate()));
        if (message.getBody() instanceof TextBody) {
            TextBody textBody = (TextBody)message.getBody();
            emlDTO = this.outputContentInText(message.getHeader(), textBody, emlDTO);
        } else {
            MultipartImpl body = (MultipartImpl)message.getBody();
            List bodyParts = body.getBodyParts();
            emlDTO = this.outputContentAndAttachments(bodyParts, emlDTO);
        }
        Optional<ImportEml> emlOptional = this.importEmlRepository.findByMessageId(emlDTO.getMessageId());
        if (emlOptional.isEmpty()) {
            ImportEml eml = new ImportEml();
            eml.setId(Y9IdGenerator.genId());
            eml.setPersonId(Y9LoginUserHolder.getPersonId());
            eml.setMessageId(emlDTO.getMessageId());
            eml.setSubject(emlDTO.getSubject());
            eml.setFrom(emlDTO.getFrom());
            eml.setTo(this.addressToString(message.getTo()));
            eml.setCc(this.addressToString(message.getCc()));
            eml.setBcc(this.addressToString(message.getBcc()));
            eml.setDateTime(emlDTO.getDateTime());
            eml.setTextContent(emlDTO.getTextContent());
            eml.setHtmlContent(emlDTO.getHtmlContent());
            eml.setExistAttchMent(!emlDTO.getAttachments().isEmpty());
            eml = (ImportEml)this.importEmlRepository.save(eml);
            if (!emlDTO.getAttachments().isEmpty()) {
                List<MutableTriple<String, Long, InputStream>> attachments = emlDTO.getAttachments();
                for (MutableTriple<String, Long, InputStream> attachment : attachments) {
                    this.importEmlAttchMentsService.saveAttchMents(eml.getId(), (String)attachment.getLeft(), (Long)attachment.getMiddle(), (InputStream)attachment.getRight());
                }
            }
        }
    }

    @Override
    public List<String> listIdsByPersonId(String personId) {
        List<ImportEml> emlList = this.importEmlRepository.findByPersonIdOrderByDateTimeDesc(personId);
        return emlList.stream().map(ImportEml::getId).collect(Collectors.toList());
    }

    private EmlResult outputContentAndAttachments(List<Entity> bodyParts, EmlResult entry) throws IOException {
        for (Entity bodyPart : bodyParts) {
            BinaryBody binaryBody;
            Body bodyContent = bodyPart.getBody();
            String dispositionType = bodyPart.getDispositionType();
            if ("attachment".equals(dispositionType)) {
                binaryBody = (BinaryBody)bodyContent;
                entry.getAttachments().add((MutableTriple<String, Long, InputStream>)MutableTriple.of((Object)bodyPart.getFilename(), (Object)binaryBody.size(), (Object)binaryBody.getInputStream()));
                continue;
            }
            if (bodyContent instanceof TextBody) {
                TextBody textBody = (TextBody)bodyContent;
                this.outputContentInText(bodyPart.getHeader(), textBody, entry);
                continue;
            }
            if (bodyContent instanceof Multipart) {
                MultipartImpl multipart = (MultipartImpl)bodyContent;
                this.outputContentAndAttachments(multipart.getBodyParts(), entry);
                continue;
            }
            if (bodyContent instanceof BinaryBody) {
                binaryBody = (BinaryBody)bodyContent;
                this.outputContentInAttachment(bodyPart.getHeader(), binaryBody, entry);
                continue;
            }
            LOGGER.error("\u3010\u662f\u5426\u8fd8\u5b58\u5728\u672a\u8986\u76d6\u5230\u7684\u5176\u5b83\u5185\u5bb9\u7c7b\u578b\u573a\u666f\u3011\uff1f");
        }
        return entry;
    }

    private EmlResult outputContentInAttachment(Header header, BinaryBody binaryBody, EmlResult entry) throws IOException {
        ContentTypeField contentTypeField;
        Field contentIdField = header.getField("Content-ID");
        Field typeField = header.getField("Content-Type");
        if (typeField instanceof ContentTypeField && (contentTypeField = (ContentTypeField)typeField).getMediaType().startsWith(MediaType.ANY_IMAGE_TYPE.type())) {
            try (InputStream inputStream = binaryBody.getInputStream();){
                String base64 = Base64.getEncoder().encodeToString(IOUtils.toByteArray((InputStream)inputStream));
                String cid = StringUtils.substringBetween((String)contentIdField.getBody(), (String)"<", (String)">");
                String content = StringUtils.replace((String)entry.getHtmlContent(), (String)("cid:" + cid), (String)("data:" + contentTypeField.getMimeType() + ";base64," + base64));
                entry.setHtmlContent(content);
            }
        }
        return entry;
    }

    private EmlResult outputContentInText(Header header, TextBody body, EmlResult entry) throws IOException {
        ContentTypeFieldLenientImpl contentType = (ContentTypeFieldLenientImpl)header.getField("Content-Type");
        String mimeType = contentType.getMimeType();
        if (MediaType.PLAIN_TEXT_UTF_8.toString().startsWith(mimeType)) {
            entry.setTextContent(IOUtils.toString((Reader)body.getReader()));
        }
        if (MediaType.HTML_UTF_8.toString().startsWith(mimeType)) {
            entry.setHtmlContent(IOUtils.toString((Reader)body.getReader()));
        }
        return entry;
    }

    @Override
    public Page<ImportEml> pageByPersonId(String personId, Y9PageQuery pageQuery) {
        PageRequest pageable = PageRequest.of((int)pageQuery.getPage4Db(), (int)pageQuery.getSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"dateTime"}));
        return this.importEmlRepository.findByPersonId(personId, (Pageable)pageable);
    }

    @Override
    public Page<ImportEml> pageSearch(final String personId, final String subject, final String htmlContent, Y9PageQuery pageQuery) {
        PageRequest pageable = PageRequest.of((int)pageQuery.getPage4Db(), (int)pageQuery.getSize(), (Sort)Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{"dateTime"}));
        return this.importEmlRepository.findAll((Specification)new Specification<ImportEml>(){
            private static final long serialVersionUID = -2210269486911993525L;

            public Predicate toPredicate(Root<ImportEml> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
                Predicate predicate = criteriaBuilder.conjunction();
                List list = predicate.getExpressions();
                list.add(criteriaBuilder.equal(root.get("personId").as(String.class), (Object)personId));
                if (StringUtils.isNotBlank((CharSequence)subject)) {
                    list.add(criteriaBuilder.like(root.get("subject").as(String.class), "%" + subject + "%"));
                }
                if (StringUtils.isNotBlank((CharSequence)htmlContent)) {
                    list.add(criteriaBuilder.like(root.get("htmlContent").as(String.class), "%" + htmlContent + "%"));
                }
                return predicate;
            }
        }, (Pageable)pageable);
    }

    @Generated
    public ImportEmlServiceImpl(ImportEmlRepository importEmlRepository, ImportEmlAttchMentsService importEmlAttchMentsService, Y9FileStoreService y9FileStoreService, EmailService emailService) {
        this.importEmlRepository = importEmlRepository;
        this.importEmlAttchMentsService = importEmlAttchMentsService;
        this.y9FileStoreService = y9FileStoreService;
        this.emailService = emailService;
    }
}

