/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.james.service.impl;

import java.io.InputStream;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import net.risesoft.id.Y9IdGenerator;
import net.risesoft.james.entity.ImportEmlAttchMents;
import net.risesoft.james.repository.ImportEmlAttchMentsRepository;
import net.risesoft.james.service.ImportEmlAttchMentsService;
import net.risesoft.y9.Y9Context;
import net.risesoft.y9.configuration.Y9Properties;
import net.risesoft.y9public.entity.Y9FileStore;
import net.risesoft.y9public.service.Y9FileStoreService;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="importEmlAttchMentsService")
public class ImportEmlAttchMentsServiceImpl
implements ImportEmlAttchMentsService {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportEmlAttchMentsServiceImpl.class);
    private final ImportEmlAttchMentsRepository importEmlAttchMentsRepository;
    private final Y9FileStoreService y9FileStoreService;
    private final Y9Properties y9conf;

    @Override
    public ImportEmlAttchMents getById(String id) {
        return this.importEmlAttchMentsRepository.findById(id).orElse(null);
    }

    @Override
    public List<ImportEmlAttchMents> listByImportEmlId(String importEmlId) {
        return this.importEmlAttchMentsRepository.findByImportEmlId(importEmlId);
    }

    @Override
    public void saveAttchMents(String importEmlId, String fileName, Long fileSize, InputStream file) {
        try {
            LocalDate currentDate = LocalDate.now();
            String fullPath = Y9FileStore.buildPath((String[])new String[]{Y9Context.getSystemName(), "eml-attchMents", "" + currentDate.getYear(), "" + currentDate.getMonthValue()});
            Y9FileStore y9FileStore = this.y9FileStoreService.uploadFile(file, fullPath, fileName);
            ImportEmlAttchMents attch = new ImportEmlAttchMents();
            attch.setId(Y9IdGenerator.genId());
            attch.setImportEmlId(importEmlId);
            attch.setFileName(fileName);
            attch.setFileSize(FileUtils.byteCountToDisplaySize((Number)fileSize));
            attch.setFileStoreId(y9FileStore.getId());
            attch.setFileExt(y9FileStore.getFileExt());
            String url = this.y9conf.getCommon().getWebmailBaseUrl() + "/s/" + y9FileStore.getId() + "." + y9FileStore.getFileExt();
            attch.setUrl(url);
            this.importEmlAttchMentsRepository.save(attch);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("\u4e0a\u4f20\u9644\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    @Generated
    public ImportEmlAttchMentsServiceImpl(ImportEmlAttchMentsRepository importEmlAttchMentsRepository, Y9FileStoreService y9FileStoreService, Y9Properties y9conf) {
        this.importEmlAttchMentsRepository = importEmlAttchMentsRepository;
        this.y9FileStoreService = y9FileStoreService;
        this.y9conf = y9conf;
    }
}

