/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.util.List;
import java.util.stream.Collectors;
import net.risesoft.api.platform.org.OrgUnitApi;
import net.risesoft.api.platform.org.OrganizationApi;
import net.risesoft.enums.platform.OrgTreeTypeEnum;
import net.risesoft.enums.platform.OrgTypeEnum;
import net.risesoft.james.service.JamesUserService;
import net.risesoft.model.platform.OrgUnit;
import net.risesoft.model.platform.Organization;
import net.risesoft.model.platform.Person;
import net.risesoft.pojo.Y9Result;
import net.risesoft.y9.Y9LoginUserHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="standardOrgController")
@RequestMapping(value={"/api/standard/org"})
public class OrgController {
    @Autowired
    private OrgUnitApi orgUnitApi;
    @Autowired
    private OrganizationApi organizationApi;
    @Autowired
    private JamesUserService jamesUserService;

    @GetMapping(value={"/getOrganization"})
    public Y9Result<List<Organization>> getOrganization() {
        String tenantId = Y9LoginUserHolder.getTenantId();
        List organizationList = (List)this.organizationApi.list(tenantId).getData();
        return Y9Result.success((Object)organizationList);
    }

    @RequestMapping(value={"/getOrgTree"})
    public Y9Result<List<OrgUnit>> getOrgTree(@RequestParam(required=false) String id, @RequestParam(required=false) OrgTreeTypeEnum treeType, @RequestParam(required=false) String name) {
        List<OrgUnit> orgUnitList;
        List organizationList;
        String tenantId = Y9LoginUserHolder.getTenantId();
        if (StringUtils.isBlank((CharSequence)id) && (organizationList = (List)this.organizationApi.list(tenantId).getData()) != null && !organizationList.isEmpty()) {
            id = ((Organization)organizationList.get(0)).getId();
        }
        if (StringUtils.isNotBlank((CharSequence)name)) {
            orgUnitList = (List<OrgUnit>)this.orgUnitApi.treeSearch(tenantId, name, treeType).getData();
            orgUnitList = this.mapEmailAddress(orgUnitList);
        } else {
            orgUnitList = (List)this.orgUnitApi.getSubTree(tenantId, id, treeType).getData();
            orgUnitList = this.mapEmailAddress(orgUnitList);
        }
        return Y9Result.success(orgUnitList);
    }

    private List<OrgUnit> mapEmailAddress(List<OrgUnit> orgUnitList) {
        orgUnitList = orgUnitList.stream().peek(org -> {
            if (OrgTypeEnum.PERSON.equals((Object)org.getOrgType())) {
                Person person = (Person)org;
                String email = this.jamesUserService.getEmailAddressByPersonId(org.getId());
                if (StringUtils.isEmpty((CharSequence)email) && StringUtils.isEmpty((CharSequence)person.getEmail())) {
                    email = "\u672a\u6ce8\u518c\u90ae\u7bb1";
                } else {
                    if (!StringUtils.isEmpty((CharSequence)email)) {
                        person.setEmail(email);
                    }
                    if (!StringUtils.isEmpty((CharSequence)person.getEmail())) {
                        email = person.getEmail();
                    }
                }
                person.setName(org.getName() + "(" + email + ")");
            }
        }).collect(Collectors.toList());
        return orgUnitList;
    }
}

