/*
 * Decompiled with CFR 0.152.
 */
package net.risesoft.controller;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import net.risesoft.controller.vo.ImportEmlAttchMentVO;
import net.risesoft.controller.vo.ImportEmlVO;
import net.risesoft.james.entity.ImportEml;
import net.risesoft.james.entity.ImportEmlAttchMents;
import net.risesoft.james.service.ImportEmlAttchMentsService;
import net.risesoft.james.service.ImportEmlService;
import net.risesoft.log.OperationTypeEnum;
import net.risesoft.log.annotation.RiseLog;
import net.risesoft.pojo.Y9Page;
import net.risesoft.pojo.Y9PageQuery;
import net.risesoft.pojo.Y9Result;
import net.risesoft.y9.Y9LoginUserHolder;
import net.risesoft.y9.util.Y9ModelConvertUtil;
import net.risesoft.y9.util.mime.ContentDispositionUtil;
import net.risesoft.y9public.service.Y9FileStoreService;
import org.apache.james.mime4j.dom.Message;
import org.apache.james.mime4j.stream.MimeConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/rest/importEml"}, produces={"application/json"})
public class ImportEmlController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportEmlController.class);
    private final ImportEmlService importEmlService;
    private final ImportEmlAttchMentsService importEmlAttchMentsService;
    private final Y9FileStoreService y9FileStoreService;

    private void compress(ZipOutputStream zipOut, String baseDir, ImportEmlAttchMents attachment) throws Exception {
        String zipEntryName = baseDir + File.separator + attachment.getFileName();
        byte[] be = this.y9FileStoreService.downloadFileToBytes(attachment.getFileStoreId());
        try (ByteArrayInputStream is = new ByteArrayInputStream(be);){
            zipOut.putNextEntry(new ZipEntry(zipEntryName));
            byte[] b = new byte[100];
            int length = 0;
            while ((length = is.read(b)) != -1) {
                zipOut.write(b, 0, length);
            }
            zipOut.flush();
            zipOut.closeEntry();
        }
        catch (Exception e) {
            LOGGER.error("\u538b\u7f29\u6587\u4ef6\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    @RiseLog(moduleName="\u7535\u5b50\u90ae\u4ef6", operationName="\u6279\u91cf\u5220\u9664\u5bfc\u5165\u4fe1\u606f")
    @PostMapping(value={"/deleteEml"})
    public Y9Result<Object> deleteEml(@RequestParam @NotBlank List<String> ids) {
        this.importEmlService.delete(ids);
        return Y9Result.successMsg((String)"\u5220\u9664\u90ae\u4ef6EML\u8be6\u7ec6\u4fe1\u606f\u6210\u529f");
    }

    @RequestMapping(value={"/download"})
    public void download(String attId, HttpServletResponse response, HttpServletRequest request) {
        ImportEmlAttchMents attachment = this.importEmlAttchMentsService.getById(attId);
        if (attachment == null) {
            LOGGER.warn("\u8be5\u9644\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        String fileName = attachment.getFileName();
        response.reset();
        response.setHeader("Content-disposition", ContentDispositionUtil.standardizeAttachment((String)fileName));
        response.setHeader("Content-type", "text/html;charset=UTF-8");
        response.setContentType("application/octet-stream");
        try (ServletOutputStream out = response.getOutputStream();){
            this.y9FileStoreService.downloadFileToOutputStream(attachment.getFileStoreId(), (OutputStream)out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/batchDownload"})
    public void download4Batch(String importEmlId, HttpServletResponse response, HttpServletRequest request) {
        List<ImportEmlAttchMents> attachmentList = this.importEmlAttchMentsService.listByImportEmlId(importEmlId);
        if (attachmentList.isEmpty()) {
            LOGGER.warn("\u8be5\u9644\u4ef6\u4e0d\u5b58\u5728\uff01");
        }
        ImportEml eml = this.importEmlService.getById(importEmlId);
        String fileName = null;
        ZipOutputStream zipOutputStream = null;
        try {
            fileName = eml.getSubject() + "_\u9644\u4ef6\u6253\u5305.zip";
            response.setContentType("text/html;charset=UTF-8");
            response.setContentType("application/octet-stream");
            response.setHeader("Content-disposition", ContentDispositionUtil.standardizeAttachment((String)fileName));
            zipOutputStream = new ZipOutputStream(new BufferedOutputStream((OutputStream)response.getOutputStream()));
            zipOutputStream.setMethod(8);
            for (ImportEmlAttchMents attachment : attachmentList) {
                this.compress(zipOutputStream, eml.getSubject(), attachment);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                zipOutputStream.close();
            }
            catch (IOException e) {
                LOGGER.error("\u5173\u95ed\u538b\u7f29\u6d41\u5931\u8d25\uff01", (Throwable)e);
            }
        }
    }

    @RiseLog(moduleName="\u7535\u5b50\u90ae\u4ef6", operationName="\u6839\u636e\u5bfc\u5165id\uff0c\u83b7\u53d6\u8be6\u7ec6\u4fe1\u606f")
    @GetMapping(value={"/getById"})
    public Y9Result<ImportEmlVO> getById(@RequestParam @NotBlank String id) {
        List<String> ids;
        ImportEml eml = this.importEmlService.getById(id);
        ImportEmlVO emlVO = (ImportEmlVO)Y9ModelConvertUtil.convert((Object)eml, ImportEmlVO.class);
        if (Boolean.TRUE.equals(eml.getExistAttchMent())) {
            List<ImportEmlAttchMents> attchMentsList = this.importEmlAttchMentsService.listByImportEmlId(id);
            emlVO.setAttchMentsList(Y9ModelConvertUtil.convert(attchMentsList, ImportEmlAttchMentVO.class));
        }
        if (!(ids = this.importEmlService.listIdsByPersonId(Y9LoginUserHolder.getPersonId())).isEmpty()) {
            int index = ids.indexOf(id);
            int len = ids.size();
            String nextId = "-1";
            String prevId = "-1";
            if (index > 0) {
                prevId = ids.get(index - 1);
            }
            if (index + 1 < len) {
                nextId = ids.get(index + 1);
            }
            String firstId = ids.get(0);
            String lastId = ids.get(ids.size() - 1);
            if (firstId.equals(id)) {
                prevId = "-1";
            }
            if (lastId.equals(id)) {
                nextId = "-1";
            }
            emlVO.setNextUid(nextId);
            emlVO.setPreviousUid(prevId);
        }
        return Y9Result.success((Object)emlVO, (String)"\u83b7\u53d6\u90ae\u4ef6EML\u8be6\u7ec6\u4fe1\u606f\u6210\u529f");
    }

    @RiseLog(moduleName="\u7535\u5b50\u90ae\u4ef6", operationName="\u4e0a\u4f20\u90ae\u4ef6EML\u6587\u4ef6", operationType=OperationTypeEnum.ADD)
    @PostMapping(value={"/importEml"})
    public Y9Result<Object> importOrgTreeXls(@RequestParam MultipartFile file) {
        Y9Result y9Result;
        block8: {
            InputStream dataStream = file.getInputStream();
            try {
                MimeConfig config = MimeConfig.PERMISSIVE;
                Message message = Message.Builder.of().use(config).parse(dataStream).build();
                this.importEmlService.importEmailByEml(message);
                y9Result = Y9Result.success();
                if (dataStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dataStream != null) {
                        try {
                            dataStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.warn(e.getMessage(), (Throwable)e);
                    return Y9Result.failure((String)("\u4e0a\u4f20\u5931\u8d25:" + e.getMessage()));
                }
            }
            dataStream.close();
        }
        return y9Result;
    }

    @RiseLog(moduleName="\u7535\u5b50\u90ae\u4ef6", operationName="\u5206\u9875\u83b7\u53d6\u90ae\u4ef6\u4fe1\u606f")
    @GetMapping(value={"/page"})
    public Y9Page<ImportEml> page(String subject, String text, Y9PageQuery pageQuery) {
        Page<ImportEml> pageList = this.importEmlService.pageSearch(Y9LoginUserHolder.getPersonId(), subject, text, pageQuery);
        return Y9Page.success((int)pageQuery.getPage(), (int)pageList.getTotalPages(), (long)pageList.getTotalElements(), (List)pageList.getContent(), (String)"\u83b7\u53d6\u6570\u636e\u6210\u529f");
    }

    @Generated
    public ImportEmlController(ImportEmlService importEmlService, ImportEmlAttchMentsService importEmlAttchMentsService, Y9FileStoreService y9FileStoreService) {
        this.importEmlService = importEmlService;
        this.importEmlAttchMentsService = importEmlAttchMentsService;
        this.y9FileStoreService = y9FileStoreService;
    }
}

